/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.model.LEDebugSetting;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEDebugFacility {
    LEDSSPortMaster m_dss;
    LEVector m_settings = new LEVector();
    LEVector m_hex = new LEVector();
    int m_mask;
    long m_hexRequest;

    public LEDebugFacility(LEDSSPortMaster lEDSSPortMaster) {
        this.m_dss = lEDSSPortMaster;
    }

    public synchronized boolean startDebug(int n, int n2) {
        if (n == 393216) {
            return this.startHexDebug(n2);
        }
        return this.startEntityDebug(n, n2);
    }

    public synchronized void stopDebug(int n, int n2) {
        if (n == 393216) {
            this.stopHexDebug(n2);
            return;
        }
        this.stopEntityDebug(n, n2);
    }

    boolean startHexDebug(int n) {
        int n2 = this.m_mask;
        this.m_mask |= n;
        this.m_hex.addElement(new Integer(n));
        if (this.m_mask == n2) {
            return true;
        }
        return this.resetHexDebug();
    }

    boolean startEntityDebug(int n, int n2) {
        boolean bl = true;
        LEDebugSetting lEDebugSetting = this.getSetting(n, n2);
        if (lEDebugSetting == null) {
            try {
                long l = this.m_dss.debug(n, n2);
                lEDebugSetting = new LEDebugSetting(n, n2, l);
                this.m_settings.addElement(lEDebugSetting);
            }
            catch (Exception exception) {
                bl = false;
                LEDebug.getLog().logln(20, exception);
            }
        } else {
            lEDebugSetting.increment();
        }
        return bl;
    }

    void stopHexDebug(int n) {
        this.m_hex.removeElement(new Integer(n));
        int n2 = 0;
        int n3 = this.m_hex.size();
        int n4 = 0;
        while (n4 < n3) {
            Integer n5 = (Integer)this.m_hex.elementAt(n4);
            n2 |= n5.intValue();
            ++n4;
        }
        if (this.m_mask == n2) {
            return;
        }
        this.m_mask = n2;
        this.resetHexDebug();
    }

    void stopEntityDebug(int n, int n2) {
        LEDebugSetting lEDebugSetting = this.getSetting(n, n2);
        if (lEDebugSetting == null) {
            return;
        }
        if (lEDebugSetting.decrement() == 0) {
            this.m_settings.removeElement(lEDebugSetting);
            try {
                this.m_dss.killDebug(lEDebugSetting.getRequestID());
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    boolean resetHexDebug() {
        if (this.m_hexRequest > 0L) {
            try {
                this.m_dss.killDebug(this.m_hexRequest);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_hexRequest = 0L;
        }
        if (this.m_mask > 0) {
            try {
                this.m_hexRequest = this.m_dss.debug(393216, this.m_mask);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                this.m_mask = 0;
                return false;
            }
        }
        return true;
    }

    LEDebugSetting getSetting(int n, int n2) {
        LEDebugSetting lEDebugSetting = null;
        int n3 = this.m_settings.size();
        int n4 = 0;
        while (lEDebugSetting == null && n4 < n3) {
            lEDebugSetting = (LEDebugSetting)this.m_settings.elementAt(n4);
            if (!lEDebugSetting.matches(n, n2)) {
                lEDebugSetting = null;
            }
            ++n4;
        }
        return lEDebugSetting;
    }
}

