/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PMDial
extends CLUtil {
    private static final String IDLE_FLAG = "-t";
    private static final String VERBOSE_FLAG = "-v";
    String m_session_time = null;
    String m_old_time;
    String m_locname;
    LEDebugLog m_log = LEDebug.getLog();

    public static void main(String[] args) {
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(args);
        LEAppInfo.setAppName("pmdial");
        LEAppInfo.setAppVersion("4.0");
        LEAppInfo.setIsApplet(false);
        try {
            String path = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File debugFile = new File(path);
            FileOutputStream fostream = new FileOutputStream(debugFile);
            LEDebug.initialize(fostream);
        }
        catch (IOException e) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, e);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        PMDial dl = new PMDial();
        dl.processArgs(args);
    }

    public void processArgs(String[] args) {
        super.processArgs(args);
        if (args.length < 3) {
            this.checkArgs();
        } else {
            String timeout;
            if (LEAppInfo.getFlag("-version") != null) {
                this.printAppInfo();
            }
            if ((timeout = LEAppInfo.getFlag(IDLE_FLAG)) != null) {
                this.m_session_time = timeout;
            }
            this.dialLocation(args[args.length - 1]);
        }
    }

    public void dialLocation(String loc_name) {
        LEPMCommand result;
        boolean verbose = false;
        if (LEAppInfo.getFlag(VERBOSE_FLAG) != null) {
            verbose = true;
        }
        this.m_locname = loc_name;
        this.connectToPortMaster();
        if (LEAppInfo.getFlag(IDLE_FLAG) != null) {
            this.setLocationTimeout(String.valueOf(this.m_session_time) + " minutes");
        }
        try {
            String cmd = new String("dial " + loc_name);
            result = this.m_pm.getDSS().execute(cmd);
            if (verbose) {
                System.out.println(result.getResult());
            }
        }
        catch (Exception e) {
            System.out.println("Exception in dialing location " + loc_name + " : " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            this.disconnect();
            return;
        }
        if (!result.getStatus()) {
            System.out.println("Error in dialing location " + loc_name + " : " + result.getResult());
            this.disconnect();
            return;
        }
        if (LEAppInfo.getFlag(IDLE_FLAG) != null) {
            this.setLocationTimeout(this.m_old_time);
        }
        this.disconnect();
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[-v] [-t <minutes>] <location_name>");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-v] : specifies verbose output.");
        System.out.println("[-t <minutes>] : specifies the number of minutes for idle timeout.");
        System.out.println("<location_name> : specifies the location to dial.");
    }

    private void setLocationTimeout(String new_time) {
        try {
            LELocations locs = (LELocations)this.m_pm.get("1703936");
            LELocation loc = (LELocation)locs.get(this.m_locname);
            this.m_old_time = (String)loc.get("297");
            StringBuffer cmd = new StringBuffer(100);
            cmd.append("set ");
            cmd.append(this.m_locname);
            cmd.append(" idle ");
            cmd.append(new_time);
            LEPMCommand result = this.m_pm.getDSS().execute(cmd.toString());
            if (!result.getStatus()) {
                System.out.println("Could not set the timeout from " + this.m_old_time + " to " + new_time);
                System.out.println("Reason: " + result.getResult());
            } else {
                this.m_pm.getDSS().execute("save location " + this.m_locname);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

