/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSFlatFile_I;
import com.lucent.ra.nms.backend.LEDSSPMAuthFailureException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_I;
import com.lucent.ra.nms.backend.LETemplateDSSFlatFile_I;
import com.lucent.ra.nms.util.LEIDCompare;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEConnectionManager_I {
    LEAMRouter_RI m_router;
    Hashtable m_cache = new Hashtable();
    int m_maxConnections = -1;

    public LEConnectionManager_I() {
        this.m_router = LEAMRouter_RI.Initialize();
    }

    public LEAMRouter_RI getAMRouter() {
        return this.m_router;
    }

    public LEDSSPortMaster_I connectToPM(String string, String string2, String string3) throws IOException, LEDSSException {
        String string4 = LEResourceID.CreatePM_ID(string, string2);
        LEDSSPortMaster_I lEDSSPortMaster_I = (LEDSSPortMaster_I)this.m_cache.get(string4);
        if (lEDSSPortMaster_I == null) {
            if (this.m_maxConnections != -1 && this.m_cache.size() >= this.m_maxConnections) {
                throw new LEDSSException("Maximum connections reached");
            }
            try {
                LEAMManager_RI.GetManager().addID(this.m_router, string4);
                lEDSSPortMaster_I = new LEDSSPortMaster_I(string, string2, string3);
                this.m_cache.put(string4, lEDSSPortMaster_I);
            }
            catch (IOException iOException) {
                LEAMManager_RI.GetManager().removeID(this.m_router, string4);
                throw iOException;
            }
            catch (LEDSSException lEDSSException) {
                LEAMManager_RI.GetManager().removeID(this.m_router, string4);
                throw lEDSSException;
            }
        } else if (!string3.equals(lEDSSPortMaster_I.getPassword())) {
            throw new LEDSSPMAuthFailureException("");
        }
        return lEDSSPortMaster_I;
    }

    public LEDSSFlatFile_I connectToFile(String string, int n) {
        return new LEDSSFlatFile_I(string, n);
    }

    public LETemplateDSSFlatFile_I connectToTemplateFile(String string, int n, LEVector lEVector) {
        return new LETemplateDSSFlatFile_I(string, n, lEVector);
    }

    public void setMaxConnections(int n) {
        this.m_maxConnections = n;
    }

    public LEVector getPMConnections() {
        LEVector lEVector = new LEVector();
        Enumeration enumeration = this.m_cache.keys();
        while (enumeration.hasMoreElements()) {
            lEVector.addElement((String)enumeration.nextElement());
        }
        lEVector.quickSort(new LEIDCompare());
        return lEVector;
    }

    public LEDSSPortMaster_I getCached(String string) {
        return (LEDSSPortMaster_I)this.m_cache.get(string);
    }

    public synchronized void checkCache() {
        Enumeration enumeration = this.m_cache.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LEDSSPortMaster_I lEDSSPortMaster_I = (LEDSSPortMaster_I)this.m_cache.get(string);
            if (this.m_router.verifyClientsFor(lEDSSPortMaster_I.getResourceID())) continue;
            this.remove(string);
        }
    }

    public void remove(String string) {
        LEDSSPortMaster_I lEDSSPortMaster_I = (LEDSSPortMaster_I)this.m_cache.remove(string);
        if (lEDSSPortMaster_I != null) {
            if (lEDSSPortMaster_I.isConnected()) {
                lEDSSPortMaster_I.disconnect();
            }
            LEAMManager_RI.GetManager().removeID(this.m_router, string);
        }
    }

    public synchronized void shutdown() {
        Enumeration enumeration = this.m_cache.keys();
        while (enumeration.hasMoreElements()) {
            this.remove((String)enumeration.nextElement());
        }
        this.m_cache.clear();
    }
}

