/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEDebugLog;
import com.lucent.ra.nms.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class PMReset
extends PMUtil {
    public static final String SLOT_FLAG = "-slot";
    LEDebugLog m_log = LEDebug.getLog();

    public static void main(String[] stringArray) {
        Object object;
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(stringArray);
        LEAppInfo.setAppName("pmreset");
        LEAppInfo.setAppVersion("4.2");
        LEAppInfo.setIsApplet(false);
        try {
            object = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File file = new File((String)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LEDebug.initialize(fileOutputStream);
        }
        catch (IOException iOException) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, iOException);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        object = new PMReset();
        ((PMReset)object).processArgs(stringArray);
        System.exit(0);
    }

    public PMReset() {
        this.initialize();
    }

    public void processArgs(String[] stringArray) {
        super.processArgs(stringArray);
        int n = 0;
        if (stringArray.length < 3) {
            this.checkArgs();
            return;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            this.printAppInfo();
            ++n;
        }
        if (LEAppInfo.getFlag("-h") != null) {
            n = stringArray[0].equals("-h") ? (n += 2) : ++n;
        }
        if (LEAppInfo.getFlag("-p") != null) {
            n = stringArray[2].equals("-p") ? (n += 2) : ++n;
        }
        if (LEAppInfo.getFlag("-u") != null) {
            n += 2;
        }
        if (LEAppInfo.getFlag(SLOT_FLAG) != null) {
            n += 2;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        int n2 = n;
        while (n2 < stringArray.length) {
            if (n2 != n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        this.resetPort(stringBuffer.toString());
    }

    public void resetPort(String string) {
        LEVector lEVector = this.processPorts(string);
        this.connectToPortMaster();
        try {
            String string2;
            LEPMCommand lEPMCommand;
            int n = lEVector.size();
            String string3 = LEAppInfo.getFlag(SLOT_FLAG);
            if (string3 != null && !(lEPMCommand = this.m_pm.execute(string2 = new String("set view " + string3))).getStatus()) {
                System.out.println("Error in setting view: " + lEPMCommand.getResult());
                this.disconnect();
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                String string4 = (String)lEVector.elementAt(n2);
                string2 = new String("reset " + string4);
                lEPMCommand = this.m_pm.execute(string2);
                if (!lEPMCommand.getStatus()) {
                    System.out.println("Error in resetting port: " + lEPMCommand.getResult());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error in resetting port: " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
            this.disconnect();
        }
        this.disconnect();
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("-slot <0-9>");
        System.out.println("<\"ports\">");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("-slot <0-9> : specifies the slot on a PortMaster 4.");
        System.out.println("<\"ports\"> : specifies the ports to reset.  Ports can be specified ");
        System.out.println("on an individual basis (\"s1\"), as a comma separated list (\"s1,s2,s4\"), ");
        System.out.println("as a group (\"s1-s4\"), or any combination of above (\"s1,s4,s6-s10\").");
        System.out.println("You can also specify \"all\" and all ports will be reset.");
    }

    private LEVector processPorts(String string) {
        LEVector lEVector = new LEVector();
        if (string.indexOf(44) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                int n = string2.indexOf(45);
                if (n > 0) {
                    this.processDashPorts(lEVector, string2, n);
                    continue;
                }
                lEVector.add(string2);
            }
        } else {
            int n = string.indexOf(45);
            if (n > 0) {
                this.processDashPorts(lEVector, string, n);
            } else {
                lEVector.add(string);
            }
        }
        return lEVector;
    }

    private void processDashPorts(LEVector lEVector, String string, int n) {
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            int n2 = Integer.parseInt(string2.substring(1));
            int n3 = Integer.parseInt(string3.substring(1));
            int n4 = n2;
            while (n4 <= n3) {
                String string4 = new String(String.valueOf(string2.substring(0, 1)) + n4);
                lEVector.add(string4);
                ++n4;
            }
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

