/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.async;

import com.lucent.ra.nms.async.DialStatusMessage;
import com.lucent.ra.nms.async.LEDialer;
import com.lucent.ra.nms.async.LEDialerStatusMessage;
import com.lucent.ra.nms.async.LEDialerUpdateMessage;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;

public class DialAPI
extends LEObservable
implements LEObserver {
    public static final int SUCCESS = 0;
    public static final int GENERAL_FAILURE = -1000;
    public static final int NOPORT_FAILURE = -1001;
    public static final int DIALNOP_FAILURE = -1002;
    LEDialer m_dialer;
    boolean m_debug = false;

    public void connectToPM(String string, String string2, String string3) throws IOException {
        this.m_dialer = new LEDialer(string, string2, string3);
        this.m_dialer.addObserver(this);
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public void dialLocation(String string, String string2, String string3) throws IOException {
        if (this.m_dialer == null) {
            IOException iOException = new IOException("Not connected to a PortMaster.");
            throw iOException;
        }
        LEVector lEVector = this.m_dialer.setLocation(string, string2, string3);
        if (lEVector != null && lEVector.size() > 0) {
            LEPMCommand lEPMCommand = (LEPMCommand)lEVector.elementAt(0);
            IOException iOException = new IOException(lEPMCommand.getResult());
            throw iOException;
        }
        this.m_dialer.dialLocation(string3);
        this.m_dialer.removeLocation(string3);
    }

    public void disconnectFromPM() {
        this.m_dialer.deleteObserver(this);
        this.m_dialer.disconnect();
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof LEDialerStatusMessage) {
            String string;
            LEDialerStatusMessage lEDialerStatusMessage = (LEDialerStatusMessage)object;
            String string2 = lEDialerStatusMessage.m_msg;
            DialStatusMessage dialStatusMessage = new DialStatusMessage();
            if (lEDialerStatusMessage.dialSucceeded()) {
                dialStatusMessage.setStatus(0);
            } else {
                int n = string2.indexOf("No available dialout ports");
                if (n > -1) {
                    dialStatusMessage.setStatus(-1001);
                } else {
                    n = string2.indexOf("Cannot perform a dial operation on this PortMaster.");
                    if (n > -1) {
                        dialStatusMessage.setStatus(-1002);
                    } else {
                        int n2 = lEDialerStatusMessage.getTermination();
                        if (n2 < 0) {
                            dialStatusMessage.setStatus(n2);
                        } else {
                            dialStatusMessage.setStatus(-1000);
                        }
                    }
                }
            }
            String string3 = lEDialerStatusMessage.getPortName();
            if (string3.length() > 0) {
                dialStatusMessage.setPort(Integer.parseInt(string3));
            }
            if ((string = lEDialerStatusMessage.getBoard()).length() > 0) {
                dialStatusMessage.setBoard(Integer.parseInt(string));
            }
            dialStatusMessage.setMessage(string2);
            dialStatusMessage.setLocation(lEDialerStatusMessage.getLocation());
            this.notifyObservers(dialStatusMessage);
            return;
        }
        if (object instanceof LEDialerUpdateMessage && this.m_debug) {
            LEDialerUpdateMessage lEDialerUpdateMessage = (LEDialerUpdateMessage)object;
            String string = lEDialerUpdateMessage.getMessage();
            this.notifyObservers(string);
        }
    }
}

