/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMOpFailureException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import java.io.BufferedReader;
import java.io.IOException;

class LEDSSPMTftpUpgrade {
    static final int TIMEOUT = 80000;
    static final short FILE_WRITESIZE = 256;
    LEStatusManager m_status;
    static final int StateInit = 1;
    static final int StateFindEOL = 2;
    static final int StateComment = 3;
    static final int StateDatafile = 4;
    static final int StateCommand = 5;
    static final int StateDone = 6;
    static final String DatafileStart = "file";
    static final String DatafileEnd = "end";
    LEDSSPortMaster m_dss;
    BufferedReader m_reader;
    int m_state;
    byte[] m_workBuffer;
    byte[] m_dataBuffer;
    byte[] m_sendBuffer;
    String m_fileName;
    short m_sendCount;
    int m_fileCount;

    static byte Dec(int n) {
        return (byte)(n - 32 & 0x3F);
    }

    /*
     * Unable to fully structure code
     */
    public byte[] decodeBytes(byte[] var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        if ((var4_4 = LEDSSPMTftpUpgrade.Dec(var1_1[var3_3++])) > 0) ** GOTO lbl13
        return new byte[0];
lbl-1000:
        // 1 sources

        {
            if (var4_4 >= 1) {
                this.m_workBuffer[var2_2++] = (byte)(LEDSSPMTftpUpgrade.Dec(var1_1[var3_3++]) << 2 | LEDSSPMTftpUpgrade.Dec(var1_1[var3_3]) >> 4);
            }
            if (var4_4 >= 2) {
                this.m_workBuffer[var2_2++] = (byte)(LEDSSPMTftpUpgrade.Dec(var1_1[var3_3++]) << 4 | LEDSSPMTftpUpgrade.Dec(var1_1[var3_3]) >> 2);
            }
            if (var4_4 >= 3) {
                this.m_workBuffer[var2_2++] = (byte)(LEDSSPMTftpUpgrade.Dec(var1_1[var3_3++]) << 6 | LEDSSPMTftpUpgrade.Dec(var1_1[var3_3]));
            }
            var4_4 -= 3;
            ++var3_3;
lbl13:
            // 2 sources

            ** while (var4_4 > 0)
        }
lbl14:
        // 1 sources

        var5_5 = new byte[var2_2];
        System.arraycopy(this.m_workBuffer, 0, var5_5, 0, var2_2);
        return var5_5;
    }

    LEDSSPMTftpUpgrade(LEDSSPortMaster lEDSSPortMaster, BufferedReader bufferedReader, LEStatusManager lEStatusManager) {
        this.m_dss = lEDSSPortMaster;
        this.m_reader = bufferedReader;
        this.m_sendBuffer = new byte[256];
        this.m_workBuffer = new byte[256];
        this.m_sendCount = 0;
        this.m_fileCount = 0;
        this.m_status = lEStatusManager;
    }

    void doTftpUpgrade() throws LEDSSException {
        String string = null;
        int n = 25;
        this.m_state = 1;
        try {
            int n2 = 0;
            while ((string = this.m_reader.readLine()) != null) {
                byte[] byArray = string.getBytes();
                if (byArray.length == 0) continue;
                switch (this.m_state) {
                    case 4: {
                        if (string.regionMatches(0, DatafileEnd, 0, 3)) {
                            this.flush((byte)6);
                            this.send((byte)6, (short)0, this.m_dataBuffer);
                            this.dumpLogV("End of file " + this.m_fileName + " " + Integer.toString(this.m_fileCount) + " bytes");
                            this.m_status.setStatus("Finished file " + this.m_fileName, 0);
                            this.m_state = 5;
                            this.m_sendCount = 0;
                            this.m_fileCount = 0;
                            n2 = 0;
                            break;
                        }
                        if (++n2 % n == 0) {
                            this.m_status.setStatus(n2 / n);
                        }
                        this.m_dataBuffer = this.decodeBytes(byArray);
                        this.queue((byte)6, this.m_dataBuffer.length, this.m_dataBuffer);
                        break;
                    }
                    default: {
                        Object object;
                        if (byArray[0] == 35 || byArray[0] == 33) {
                            char[] cArray = new char[string.length() - 1];
                            if (string.length() > 1) {
                                string.getChars(1, string.length() - 1, cArray, 0);
                                object = new String(cArray);
                            } else {
                                object = "";
                            }
                            this.m_status.setStatus((String)object);
                            this.dumpLogV("Comment: " + (String)object);
                            break;
                        }
                        if (string.regionMatches(0, DatafileStart, 0, 3)) {
                            int n3 = DatafileStart.length() + 1;
                            object = new char[string.length() - n3];
                            this.m_state = 4;
                            string.getChars(n3, string.length() - n3, (char[])object, 0);
                            this.m_fileName = new String((char[])object);
                            this.send((byte)5, this.m_fileName);
                            this.m_sendCount = 0;
                            this.m_fileCount = 0;
                            this.dumpLogV("File: " + this.m_fileName);
                            this.m_status.setStatus("Downloading file " + this.m_fileName);
                            break;
                        }
                        this.dumpLogV("Command: " + string);
                        this.m_status.setStatus("Command: " + string);
                        this.m_dss.execute(string, 80000);
                    }
                }
            }
            return;
        }
        catch (IOException iOException) {
            this.dumpLogV("doTftpUpgrade Exception: " + iOException.getClass().getName());
            String string2 = "Upgrade failed";
            if (iOException.getMessage() != null) {
                string2 = String.valueOf(string2) + ": " + iOException.getMessage();
            }
            throw new LEDSSException(iOException, string2);
        }
    }

    void flush(byte by) throws LEDSSException, IOException {
        if (this.m_sendCount > 0) {
            this.send(by, this.m_sendCount, this.m_sendBuffer);
        }
        this.m_sendCount = 0;
    }

    void queue(byte by, int n, byte[] byArray) throws LEDSSException, IOException {
        this.dumpLogV("Queue'ing more data: " + n);
        if (this.m_sendCount + n > 256) {
            short s = (short)(this.m_sendCount + n - 256);
            System.arraycopy(byArray, 0, this.m_sendBuffer, this.m_sendCount, 256 - this.m_sendCount);
            this.send(by, (short)256, this.m_sendBuffer);
            System.arraycopy(byArray, 256 - this.m_sendCount, this.m_sendBuffer, 0, s);
            this.m_sendCount = s;
            return;
        }
        System.arraycopy(byArray, 0, this.m_sendBuffer, this.m_sendCount, n);
        this.m_sendCount = (short)(this.m_sendCount + n);
    }

    void send(byte by, String string) throws LEDSSException, IOException {
        byte[] byArray = string.getBytes();
        this.send(by, (short)string.length(), byArray);
    }

    void send(byte by, short s, byte[] byArray) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Sending " + LEDSSPortMaster_RI.GetOpCodeString(by) + " Length: " + Integer.toString(s) + " bytes");
        LESendResponse lESendResponse = this.m_dss.send(by, s, byArray, false, 80000);
        if (!lESendResponse.successful()) {
            this.dumpLogV("TFTP Upgrade: Data Send Failed");
            throw new LEDSSPMOpFailureException("Data Send Failed: " + LEDSSPortMaster_RI.GetOpCodeString(by));
        }
        this.dumpLogV("TFTP Upgrade: Data Send Succeeded");
        this.m_fileCount += s;
    }

    void dump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == 0) break;
            if ((short)(byArray[n2] & 0xFF) < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString((short)(byArray[n2] & 0xFF), 16));
            stringBuffer.append(' ');
            if (stringBuffer.length() > 60) {
                this.dumpLogV(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            this.dumpLogV(stringBuffer.toString());
        }
    }

    protected final synchronized void dumpLogV(String string) {
        LEDebug.getLog().logln(40, string);
    }
}

