/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.io.Serializable;
import java.util.Hashtable;

public class LEMonEnvMessage
extends LEEntityMessage
implements Serializable {
    public static final String TOP = "top";
    public static final String MIDDLE = "middle";
    public static final String BOTTOM = "bottom";
    public static final String REMOVED = "removed";
    public static final String PRESENT = "present";
    public static final String WORKING = "working";
    String m_toppower;
    String m_midpower;
    String m_bottompower;
    String m_currentpower;
    String m_maxpower;
    String m_usedpower;
    String m_reqpower;
    String m_prime_dc;
    String m_second_dc;
    String m_fan1;
    String m_fan2;
    String m_fan3;
    String m_fan4;
    int m_currentfan;
    String m_currentboard;
    Hashtable m_boardpower = new Hashtable(10);
    Hashtable m_boardtemp = new Hashtable(10);
    LEVector m_boards = new LEVector(10);

    public LEMonEnvMessage(String string, int n, String string2) {
        super(string, n, string2);
        this.m_messageType = "MONITOR";
    }

    public String getPowerSupply(String string) {
        if (string.equals(TOP)) {
            return this.m_toppower;
        }
        if (string.equals(MIDDLE)) {
            return this.m_midpower;
        }
        if (string.equals(BOTTOM)) {
            return this.m_bottompower;
        }
        return null;
    }

    public String getMaxPower() {
        return this.m_maxpower;
    }

    public String getUsedPower() {
        return this.m_usedpower;
    }

    public String getReqPower() {
        return this.m_reqpower;
    }

    public String getPrimaryDC() {
        return this.m_prime_dc;
    }

    public String getSecondaryDC() {
        return this.m_second_dc;
    }

    public String getFan(int n) {
        switch (n) {
            case 1: {
                return this.m_fan1;
            }
            case 2: {
                return this.m_fan2;
            }
            case 3: {
                return this.m_fan3;
            }
            case 4: {
                return this.m_fan4;
            }
        }
        return this.m_fan1;
    }

    public String getBoardPower(String string) {
        return (String)this.m_boardpower.get(string);
    }

    public String getBoardTemp(String string) {
        return (String)this.m_boardtemp.get(string);
    }

    public LEVector getBoards() {
        return this.m_boards;
    }

    public void setAttribute(int n, String string) {
        try {
            switch (n) {
                case 448: {
                    this.m_currentpower = string;
                    return;
                }
                case 449: {
                    if (this.m_currentpower.equals(TOP)) {
                        this.m_toppower = string;
                        return;
                    }
                    if (this.m_currentpower.equals(MIDDLE)) {
                        this.m_midpower = string;
                        return;
                    }
                    if (this.m_currentpower.equals(BOTTOM)) {
                        this.m_bottompower = string;
                        return;
                    }
                    break;
                }
                case 450: {
                    this.m_maxpower = string;
                    return;
                }
                case 451: {
                    this.m_usedpower = string;
                    return;
                }
                case 458: {
                    this.m_reqpower = string;
                    return;
                }
                case 452: {
                    this.m_prime_dc = string;
                    return;
                }
                case 453: {
                    this.m_second_dc = string;
                    return;
                }
                case 454: {
                    this.m_currentfan = Integer.parseInt(string);
                    return;
                }
                case 455: {
                    switch (this.m_currentfan) {
                        case 1: {
                            this.m_fan1 = string;
                            return;
                        }
                        case 2: {
                            this.m_fan2 = string;
                            return;
                        }
                        case 3: {
                            this.m_fan3 = string;
                            return;
                        }
                        case 4: {
                            this.m_fan4 = string;
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 275: {
                    this.m_currentboard = string;
                    this.m_boards.add(string);
                    return;
                }
                case 456: {
                    this.m_boardpower.put(this.m_currentboard, string);
                    return;
                }
                case 457: {
                    this.m_boardtemp.put(this.m_currentboard, string);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }
}

