/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LELogFacility_R;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;
import java.util.Enumeration;

public class LELogFacility
implements LEAMObserver {
    LEVector m_logReq = new LEVector();
    LEPMConnectionFacade m_facade;
    LELogFacility_R m_facility;

    public LELogFacility(LEPMConnectionFacade lEPMConnectionFacade, LELogFacility_R lELogFacility_R, String string) {
        this.m_facade = lEPMConnectionFacade;
        this.m_facility = lELogFacility_R;
        LEStatusFactory.GetFactory().addObserver(string, this);
    }

    public boolean startLog(int n) {
        boolean bl = false;
        LELogFacility lELogFacility = this;
        synchronized (lELogFacility) {
            this.m_logReq.addUnique(new Integer(n));
        }
        try {
            if (this.m_facility != null) {
                bl = this.m_facility.startLog(n);
            }
        }
        catch (RemoteException remoteException) {
            this.m_facade.handleRemoteException(remoteException);
            bl = false;
        }
        return bl;
    }

    public void stopLog() {
        this.m_logReq.removeAllElements();
        try {
            if (this.m_facility != null) {
                this.m_facility.stopLog();
                return;
            }
        }
        catch (RemoteException remoteException) {
            this.m_facade.handleRemoteException(remoteException);
        }
    }

    public void reconnect() {
        LEDSSPortMaster lEDSSPortMaster = (LEDSSPortMaster)this.m_facade.getDSS();
        this.m_facility = lEDSSPortMaster != null ? lEDSSPortMaster.getLogFacility() : null;
        if (this.m_facility == null) {
            return;
        }
        try {
            Enumeration enumeration = this.m_logReq.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                this.m_facility.startLog(n);
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.m_facade.handleRemoteException(remoteException);
            return;
        }
    }

    public void lostConnection() {
        this.m_facility = null;
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        int n;
        if (object instanceof LEStatusMessage && (n = ((LEStatusMessage)object).getStatus()) == 1) {
            this.reconnect();
        }
    }
}

