/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.util;

import com.lucent.ra.nms.util.LEClientMDF_R;
import com.lucent.ra.nms.util.LEClientPerf;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEMessageType;
import com.lucent.ra.nms.util.LETQClient;
import com.lucent.ra.nms.util.LEThreadedQueue;
import java.rmi.ConnectException;
import java.rmi.RemoteException;

public class LEServerPostBox {
    public long m_last_timeout;
    int m_messages_dropped = 0;
    LESPBX_postman m_postman = new LESPBX_postman();
    LEThreadedQueue m_incoming_messages = new LEThreadedQueue(this.m_postman);
    LEClientMDF_R m_client_mdf = null;

    public void postMessage(LEMessageType lEMessageType) {
        if (this.m_incoming_messages == null) {
            LEDebug.getLog().logln(20, "Server Postbox incorrectly set up.");
            LEDebug.getLog().logln(20, "  Server TQ is NULL!");
            return;
        }
        this.m_incoming_messages.add(lEMessageType);
    }

    public void setClientMDF(LEClientMDF_R lEClientMDF_R) {
        this.m_client_mdf = lEClientMDF_R;
    }

    public void flush() {
        this.m_incoming_messages.shutdown();
        this.m_incoming_messages = null;
        this.m_client_mdf = null;
    }

    public LEClientPerf getClientPerf() {
        LEThreadedQueue lEThreadedQueue = this.m_incoming_messages;
        return new LEClientPerf("", lEThreadedQueue.getQueueSize(), lEThreadedQueue.getIdleTime(), this.m_messages_dropped);
    }

    public void incrMessagesDropped() {
        ++this.m_messages_dropped;
    }

    class LESPBX_postman
    implements LETQClient {
        public void next(Object object) {
            LEMessageType lEMessageType = (LEMessageType)object;
            lEMessageType.getMessageAdminGroup();
            if (LEServerPostBox.this.m_client_mdf == null) {
                LEDebug.getLog().logln(10, "Server Postbox incorrectly set up.");
                LEDebug.getLog().logln(10, "   client mdf not yet set");
                return;
            }
            try {
                LEDebug.getLog().logln(100, "Sending a message of type '" + lEMessageType.getMessageType() + "' with an admin group of '" + lEMessageType.getMessageAdminGroup() + "'");
                LEServerPostBox.this.m_client_mdf.receive(lEMessageType);
                LEServerPostBox.this.m_last_timeout = 0L;
                return;
            }
            catch (ConnectException connectException) {
                if (LEServerPostBox.this.m_last_timeout == 0L) {
                    LEServerPostBox.this.m_last_timeout = System.currentTimeMillis();
                }
                object = null;
                return;
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, "Exception while queueing to client : ");
                LEDebug.getLog().logln(20, remoteException.getMessage());
                object = null;
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LEDebug.getLog().logln(10, "OutOfMemory sending a message to client");
                object = null;
                return;
            }
        }

        LESPBX_postman() {
            LEServerPostBox.this = LEServerPostBox.this;
        }
    }
}

