/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEAsyncCmdFacility_R;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.util.LEDebug;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEAsyncCmdFacility_RI
extends UnicastRemoteObject
implements LEAsyncCmdFacility_R {
    LEDSSPortMaster_RI m_dss;
    Hashtable m_asyncs = new Hashtable();

    public LEAsyncCmdFacility_RI(LEDSSPortMaster_RI dss) throws RemoteException {
        this.m_dss = dss;
    }

    public synchronized boolean startAsync(int entity, int board, String cmd) throws RemoteException {
        try {
            long req = this.m_dss.async(entity, board, cmd);
            this.m_asyncs.put(cmd, new Long(req));
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public synchronized void stopAsync(int entity, int board, String cmd) throws RemoteException {
        Long request = (Long)this.m_asyncs.remove(cmd);
        try {
            if (request != null) {
                this.m_dss.killAsync(request);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    synchronized void shutdown() {
        Enumeration enumeration = this.m_asyncs.keys();
        while (enumeration.hasMoreElements()) {
            String cmd = (String)enumeration.nextElement();
            Long req = (Long)this.m_asyncs.get(cmd);
            try {
                if (!this.m_dss.isConnected()) continue;
                this.m_dss.killAsync(req);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
    }
}

