/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.io.Serializable;
import java.util.Hashtable;

public class LEMonEnvMessage
extends LEEntityMessage
implements Serializable {
    public static final String TOP = "top";
    public static final String MIDDLE = "middle";
    public static final String BOTTOM = "bottom";
    public static final String REMOVED = "removed";
    public static final String PRESENT = "present";
    public static final String WORKING = "working";
    String m_toppower;
    String m_midpower;
    String m_bottompower;
    String m_currentpower;
    String m_maxpower;
    String m_usedpower;
    String m_reqpower;
    String m_prime_dc;
    String m_second_dc;
    String m_fan1;
    String m_fan2;
    String m_fan3;
    String m_fan4;
    int m_currentfan;
    String m_currentboard;
    Hashtable m_boardpower = new Hashtable(10);
    Hashtable m_boardtemp = new Hashtable(10);
    LEVector m_boards = new LEVector(10);

    public LEMonEnvMessage(String id, int request, String name) {
        super(id, request, name);
        this.m_messageType = "MONITOR";
    }

    public String getPowerSupply(String supply) {
        if (supply.equals(TOP)) {
            return this.m_toppower;
        }
        if (supply.equals(MIDDLE)) {
            return this.m_midpower;
        }
        if (supply.equals(BOTTOM)) {
            return this.m_bottompower;
        }
        return null;
    }

    public String getMaxPower() {
        return this.m_maxpower;
    }

    public String getUsedPower() {
        return this.m_usedpower;
    }

    public String getReqPower() {
        return this.m_reqpower;
    }

    public String getPrimaryDC() {
        return this.m_prime_dc;
    }

    public String getSecondaryDC() {
        return this.m_second_dc;
    }

    public String getFan(int num) {
        switch (num) {
            case 1: {
                return this.m_fan1;
            }
            case 2: {
                return this.m_fan2;
            }
            case 3: {
                return this.m_fan3;
            }
            case 4: {
                return this.m_fan4;
            }
        }
        return this.m_fan1;
    }

    public String getBoardPower(String id) {
        return (String)this.m_boardpower.get(id);
    }

    public String getBoardTemp(String id) {
        return (String)this.m_boardtemp.get(id);
    }

    public LEVector getBoards() {
        return this.m_boards;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(int attribute, String value) {
        try {
            switch (attribute) {
                case 448: {
                    this.m_currentpower = value;
                    return;
                }
                case 449: {
                    if (this.m_currentpower.equals(TOP)) {
                        this.m_toppower = value;
                        return;
                    } else if (this.m_currentpower.equals(MIDDLE)) {
                        this.m_midpower = value;
                        return;
                    } else {
                        if (!this.m_currentpower.equals(BOTTOM)) return;
                        this.m_bottompower = value;
                        return;
                    }
                }
                case 450: {
                    this.m_maxpower = value;
                    return;
                }
                case 451: {
                    this.m_usedpower = value;
                    return;
                }
                case 458: {
                    this.m_reqpower = value;
                    return;
                }
                case 452: {
                    this.m_prime_dc = value;
                    return;
                }
                case 453: {
                    this.m_second_dc = value;
                    return;
                }
                case 454: {
                    this.m_currentfan = Integer.parseInt(value);
                    return;
                }
                case 455: {
                    switch (this.m_currentfan) {
                        case 1: {
                            this.m_fan1 = value;
                            return;
                        }
                        case 2: {
                            this.m_fan2 = value;
                            return;
                        }
                        case 3: {
                            this.m_fan3 = value;
                            return;
                        }
                        case 4: {
                            this.m_fan4 = value;
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 275: {
                    this.m_currentboard = value;
                    this.m_boards.add(value);
                    return;
                }
                case 456: {
                    this.m_boardpower.put(this.m_currentboard, value);
                    return;
                }
                case 457: {
                    this.m_boardtemp.put(this.m_currentboard, value);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

