/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSFlatFile_RI;
import com.lucent.ra.nms.backend.LELocationTemplate;
import com.lucent.ra.nms.backend.LETemplateDSSFlatFile_R;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class LETemplateDSSFlatFile_RI
extends LEDSSFlatFile_RI
implements LETemplateDSSFlatFile_R {
    static final String LOCATION_PATTERN = "\\w+\\s+location\\s+";
    LEVector m_templates;
    Perl5Matcher m_matcher;
    Perl5Pattern m_locationPattern;

    public LETemplateDSSFlatFile_RI(String fullpath, int mode, LEVector templates) throws RemoteException {
        super(fullpath, mode);
        this.m_templates = templates;
        this.m_matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_locationPattern = (Perl5Pattern)compiler.compile(LOCATION_PATTERN, 1);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public LEVector getTemplateKeys() throws RemoteException {
        return this.m_templates;
    }

    public synchronized void writeSection(String section, LEVector commands) throws RemoteException {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        prw.println('#');
        prw.print("# ");
        prw.println(section);
        prw.println('#');
        this.writeTemplateCommands(prw, commands, this.m_templates);
        prw.flush();
        prw = null;
    }

    public synchronized void writeConfig(LEVector commands) throws RemoteException {
        if (this.m_writer == null || commands == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        this.writeTemplateCommands(prw, commands, this.m_templates);
        prw.flush();
        prw = null;
    }

    protected LEVector loadCommands() {
        LEVector cmds = new LEVector();
        boolean is_template = false;
        try {
            String line = this.m_reader.readLine();
            while (line != null) {
                if (line.length() > 3) {
                    if (line.startsWith("## TEMPLATE")) {
                        is_template = true;
                        line = this.m_reader.readLine();
                        if (line == null) break;
                    }
                    if (line.startsWith("## PASS_ENC ")) {
                        line = this.convertPasswordLine(line);
                    }
                    cmds.addElement(line);
                    if (is_template) {
                        if (this.m_matcher.contains(line, (Pattern)this.m_locationPattern)) {
                            LELocationTemplate.ReadTemplateLine(this.m_templates, line);
                        } else {
                            this.readTemplateLine(line);
                        }
                    }
                    is_template = false;
                }
                line = this.m_reader.readLine();
            }
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
        }
        return cmds;
    }

    protected void readTemplateLine(String line) {
        int valuepos = line.lastIndexOf(32);
        if (valuepos > -1) {
            String template_value = line.substring(valuepos);
            template_value = template_value.trim();
            int keypos = line.lastIndexOf(32, valuepos);
            if (keypos > -1) {
                String template_key = line.substring(keypos, valuepos);
                template_key = template_key.trim();
                this.m_templates.add(template_key);
            }
        }
    }

    private void writeTemplateCommands(PrintWriter prw, LEVector commands, LEVector templates) {
        int cmd_len = 0;
        if (commands != null) {
            cmd_len = commands.size();
        }
        int template_len = 0;
        if (templates != null) {
            template_len = templates.size();
        }
        boolean is_template = false;
        int i = 0;
        while (i < cmd_len) {
            int j = 0;
            String command = (String)commands.elementAt(i);
            while (j < template_len && !is_template) {
                String template_key = (String)templates.elementAt(j);
                int index = command.lastIndexOf(template_key);
                if (index > -1) {
                    is_template = true;
                }
                ++j;
            }
            if (is_template) {
                prw.println("## TEMPLATE");
            }
            this.writeCommand(prw, command);
            is_template = false;
            ++i;
        }
    }
}

