/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEBinding;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEBindings
extends LETable {
    public LEBindings(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEBindings config = new LEBindings(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String ipaddress, String macaddress) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer();
        buf.append("set dhcp bind ");
        buf.append(ipaddress);
        buf.append(" ");
        buf.append(macaddress);
        LEPMCommand ret = this.m_facade.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
            }
            this.refresh();
        } else {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String ipaddress) {
        LEVector errors = null;
        StringBuffer cmd = new StringBuffer();
        cmd.append("delete dhcp bindings ");
        cmd.append(ipaddress);
        LEPMCommand ret = this.m_facade.execute(cmd.toString());
        if (ret.getStatus()) {
            this.remove(ipaddress);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        } else {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEBinding(this.m_facade, key);
    }
}

