/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDBNetUser;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEDBNetUsers
extends LETable {
    public LEDBNetUsers(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEDBNetUsers config = new LEDBNetUsers(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String name, String location) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("netuser", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            cmd = this.makeSetCommand("user", name, "dialback", location);
            ret = this.m_facade.execute(cmd);
        }
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("user", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEDBNetUser(this.m_facade, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("netuser", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("user", key));
        return true;
    }
}

