/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEBindings;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEDHCP
extends LEConfig {
    public static final String BINDINGS = "bindings";
    public static final String DOMAIN = "159";
    public static final String ENCAPSULATION = "190";
    public static final String GATEWAY = "75";
    public static final String IPPOOL = "ippool";
    public static final String LEASE = "200";
    public static final String NAMESERVER_1 = "157";
    public static final String NAMESERVER_2 = "158";
    public static final String NETBIOS_SCOPE = "201";
    public static final String NETMASK = "15";
    public static final String RELAY = "204";
    public static final String STATUS = "17";
    public static final String WINSERVER_1 = "202";
    public static final String WINSERVER_2 = "203";
    public static final int KEY_COUNT = 14;
    public static final String RESET = "reset dhcp";
    static String[] s_keys = null;
    boolean m_reset;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[14];
            int i = 0;
            LEDHCP.s_keys[i++] = BINDINGS;
            LEDHCP.s_keys[i++] = DOMAIN;
            LEDHCP.s_keys[i++] = ENCAPSULATION;
            LEDHCP.s_keys[i++] = GATEWAY;
            LEDHCP.s_keys[i++] = IPPOOL;
            LEDHCP.s_keys[i++] = LEASE;
            LEDHCP.s_keys[i++] = NAMESERVER_1;
            LEDHCP.s_keys[i++] = NAMESERVER_2;
            LEDHCP.s_keys[i++] = NETBIOS_SCOPE;
            LEDHCP.s_keys[i++] = NETMASK;
            LEDHCP.s_keys[i++] = RELAY;
            LEDHCP.s_keys[i++] = STATUS;
            LEDHCP.s_keys[i++] = WINSERVER_1;
            LEDHCP.s_keys[i++] = WINSERVER_2;
        }
        return s_keys;
    }

    public LEDHCP(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEDHCP config = new LEDHCP(this.m_facade);
        config.copy(this);
        return config;
    }

    public boolean requiresReset(String key) {
        if (key.equals(BINDINGS)) {
            return true;
        }
        if (key.equals(DOMAIN)) {
            return true;
        }
        if (key.equals(ENCAPSULATION)) {
            return true;
        }
        if (key.equals(GATEWAY)) {
            return true;
        }
        if (key.equals(IPPOOL)) {
            return true;
        }
        if (key.equals(LEASE)) {
            return true;
        }
        if (key.equals(NAMESERVER_1)) {
            return true;
        }
        if (key.equals(NAMESERVER_2)) {
            return true;
        }
        if (key.equals(NETBIOS_SCOPE)) {
            return true;
        }
        if (key.equals(NETMASK)) {
            return true;
        }
        if (key.equals(WINSERVER_1)) {
            return true;
        }
        if (key.equals(WINSERVER_2)) {
            return true;
        }
        if (key.equals(STATUS)) {
            return true;
        }
        return key.equals(RELAY);
    }

    LEConfig createConfig(String key) {
        if (key.equals(BINDINGS)) {
            return new LEBindings(this.m_facade);
        }
        return new LEConfig(this.m_facade);
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret && this.m_reset) {
            cmds.addElement("save all");
            cmds.addElement(RESET);
            this.m_reset = false;
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret && this.m_reset) {
            cmds.addElement("save all");
            cmds.addElement(RESET);
            this.m_reset = false;
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String lease;
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(DOMAIN)) {
            this.makeSetCommand(cmds, null, DOMAIN, "dhcp domain");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(ENCAPSULATION)) {
            this.makeSetCommand(cmds, null, ENCAPSULATION, "dhcp encapsulation");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(GATEWAY)) {
            this.makeSetCommand(cmds, null, GATEWAY, "dhcp gateway");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(IPPOOL)) {
            this.makeSetCommand(cmds, null, IPPOOL, "dhcp pool");
            this.m_reset = true;
        }
        if ((allCmds || keys.contains(LEASE)) && (lease = (String)this.get(LEASE)) != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("set ");
            buf.append("dhcp lease ");
            buf.append(lease);
            buf.append(" minutes");
            cmds.addElement(buf.toString());
            this.m_reset = true;
        }
        if (allCmds || keys.contains(NAMESERVER_1)) {
            this.makeSetCommand(cmds, null, NAMESERVER_1, "dhcp nameserver 1");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(NAMESERVER_2)) {
            this.makeSetCommand(cmds, null, NAMESERVER_2, "dhcp nameserver 2");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(NETBIOS_SCOPE)) {
            this.makeSetCommand(cmds, null, NETBIOS_SCOPE, "dhcp netbios-scope");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, null, NETMASK, "dhcp netmask");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(WINSERVER_1)) {
            this.makeSetCommand(cmds, null, WINSERVER_1, "dhcp wins-server 1");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(WINSERVER_2)) {
            this.makeSetCommand(cmds, null, WINSERVER_2, "dhcp wins-server 2");
            this.m_reset = true;
        }
        if (allCmds || keys.contains(STATUS) || keys.contains(RELAY)) {
            String status = (String)this.get(STATUS);
            if (status.equals("on")) {
                this.set(RELAY, "0.0.0.0");
                this.makeSetCommand(cmds, null, RELAY, "dhcp relay");
                this.makeSetCommand(cmds, null, STATUS, "dhcp server");
            } else if (status.equals("off")) {
                String relay = (String)this.get(RELAY);
                if (relay != null && !relay.equals("0.0.0.0")) {
                    this.makeSetCommand(cmds, null, STATUS, "dhcp server");
                    this.makeSetCommand(cmds, null, RELAY, "dhcp relay");
                } else {
                    this.makeSetCommand(cmds, null, RELAY, "dhcp relay");
                    this.makeSetCommand(cmds, null, STATUS, "dhcp server");
                }
            }
            this.m_reset = true;
        }
        return cmds.size() > start;
    }
}

