/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEFilter;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEFilters
extends LETable {
    public LEFilters(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEFilters config = new LEFilters(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("filter", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            if (ret.getStatus()) {
                LEFilter filter = (LEFilter)this.getConfig(name);
                filter.initialize();
            } else {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("filter", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("filter", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("filter", key));
        return true;
    }

    LEConfig createConfig(String key) {
        return new LEFilter(this.m_facade, key);
    }
}

