/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEGateway
extends LEConfig {
    private static final String GATEWAY = "gateway";
    public static final String AUTH_FLAG = "61465";
    public static final String AUTH_RETRY = "61466";
    public static final String AUTH_DELAY = "61467";
    public static final String DEST_RETRY = "61468";
    public static final String SAM_IP = "61469";
    public static final String GW_STATUS = "61472";
    public static final String FTP_IP = "61478";
    public static final String H225_SIGPORT = "61479";
    public static final String H225_T303 = "61480";
    public static final String H225_T310 = "61481";
    public static final String SAM_PORT = "61482";
    public static final String RAS_RRQ_RETRY = "61483";
    public static final String RAS_RRQ_TIMEOUT = "61484";
    public static final String RAS_ARQ_RETRY = "61485";
    public static final String RAS_ARQ_TIMEOUT = "61486";
    public static final String RAS_URQ_RETRY = "61487";
    public static final String H225_T301 = "61488";
    public static final String VOICE_DIR = "61489";
    public static final String GW_SECRET = "61490";
    public static final String UID_MAX = "61496";
    public static final String PIN_MAX = "61497";
    public static final String RAS_URQ_TIMEOUT = "61498";
    public static final String RAS_TIMETOLIVE = "61499";
    public static final String UIDPIN_RETRY = "61500";
    public static final String ECHO_CAN = "61504";
    public static final String FRAMES_PER_PACKET = "61505";
    public static final String MAX_JITTER = "61506";
    public static final String MIN_JITTER = "61507";
    public static final String CODEC = "61508";
    public static final String VOICE_SERVICE = "61510";
    public static final String FAX_SERVICE = "61511";
    public static final String RAS_REREG = "61514";
    public static final String FAX_MAX_PAYLOAD = "61515";
    public static final String FAX_FRAMES_PACKET = "61516";
    public static final String FAX_BUILDOUT = "61517";
    public static final int KEY_COUNT = 35;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[35];
            int i = 0;
            LEGateway.s_keys[i++] = AUTH_FLAG;
            LEGateway.s_keys[i++] = AUTH_RETRY;
            LEGateway.s_keys[i++] = AUTH_DELAY;
            LEGateway.s_keys[i++] = DEST_RETRY;
            LEGateway.s_keys[i++] = SAM_IP;
            LEGateway.s_keys[i++] = SAM_PORT;
            LEGateway.s_keys[i++] = GW_STATUS;
            LEGateway.s_keys[i++] = FTP_IP;
            LEGateway.s_keys[i++] = H225_SIGPORT;
            LEGateway.s_keys[i++] = H225_T303;
            LEGateway.s_keys[i++] = H225_T310;
            LEGateway.s_keys[i++] = H225_T301;
            LEGateway.s_keys[i++] = VOICE_DIR;
            LEGateway.s_keys[i++] = GW_SECRET;
            LEGateway.s_keys[i++] = RAS_RRQ_RETRY;
            LEGateway.s_keys[i++] = RAS_RRQ_TIMEOUT;
            LEGateway.s_keys[i++] = RAS_ARQ_RETRY;
            LEGateway.s_keys[i++] = RAS_ARQ_TIMEOUT;
            LEGateway.s_keys[i++] = RAS_URQ_RETRY;
            LEGateway.s_keys[i++] = RAS_URQ_TIMEOUT;
            LEGateway.s_keys[i++] = RAS_REREG;
            LEGateway.s_keys[i++] = RAS_TIMETOLIVE;
            LEGateway.s_keys[i++] = UID_MAX;
            LEGateway.s_keys[i++] = PIN_MAX;
            LEGateway.s_keys[i++] = UIDPIN_RETRY;
            LEGateway.s_keys[i++] = ECHO_CAN;
            LEGateway.s_keys[i++] = FRAMES_PER_PACKET;
            LEGateway.s_keys[i++] = MAX_JITTER;
            LEGateway.s_keys[i++] = MIN_JITTER;
            LEGateway.s_keys[i++] = FAX_MAX_PAYLOAD;
            LEGateway.s_keys[i++] = FAX_FRAMES_PACKET;
            LEGateway.s_keys[i++] = FAX_BUILDOUT;
        }
        return s_keys;
    }

    public LEGateway(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEGateway config = new LEGateway(this.m_facade);
        config.copy(this);
        return config;
    }

    public boolean requiresReboot(String key) {
        return key.equals(AUTH_FLAG) || key.equals(AUTH_RETRY) || key.equals(AUTH_DELAY) || key.equals(DEST_RETRY) || key.equals(SAM_IP) || key.equals(GW_STATUS) || key.equals(FTP_IP) || key.equals(H225_SIGPORT) || key.equals(H225_T303) || key.equals(H225_T310) || key.equals(H225_T301) || key.equals(VOICE_DIR) || key.equals(GW_SECRET) || key.equals(SAM_PORT) || key.equals(RAS_RRQ_RETRY) || key.equals(RAS_RRQ_TIMEOUT) || key.equals(RAS_ARQ_RETRY) || key.equals(RAS_ARQ_TIMEOUT) || key.equals(RAS_URQ_RETRY) || key.equals(RAS_URQ_TIMEOUT) || key.equals(RAS_REREG) || key.equals(RAS_TIMETOLIVE) || key.equals(UID_MAX) || key.equals(PIN_MAX) || key.equals(UIDPIN_RETRY) || key.equals(ECHO_CAN) || key.equals(FRAMES_PER_PACKET) || key.equals(MAX_JITTER) || key.equals(MIN_JITTER) || key.equals(CODEC) || key.equals(VOICE_SERVICE) || key.equals(FAX_SERVICE) || key.equals(FAX_MAX_PAYLOAD) || key.equals(FAX_FRAMES_PACKET) || key.equals(FAX_BUILDOUT);
    }

    String getViewCommand() {
        String cmd = null;
        StringBuffer buf = new StringBuffer(20);
        buf.append("set view ");
        buf.append(GATEWAY);
        cmd = buf.toString();
        return cmd;
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String auth;
        boolean allCmds = keys == null;
        int start = cmds.size();
        if ((allCmds || keys.contains(AUTH_FLAG)) && (auth = (String)this.get(AUTH_FLAG)) != null) {
            StringBuffer buf = new StringBuffer("set ");
            buf.append(" auth-flag ");
            if (auth.equals("No authorization")) {
                buf.append("none");
            } else if (auth.equals("Ani authorization")) {
                buf.append("ani");
            } else if (auth.equals("Uid/Pin authorization")) {
                buf.append("uid");
            } else if (auth.equals("Ani with fall back authorization")) {
                buf.append("fallback");
            }
            cmds.addElement(new String(buf));
        }
        if (allCmds || keys.contains(AUTH_RETRY)) {
            this.makeSetCommand(cmds, "", AUTH_RETRY, "auth-retry");
        }
        if (allCmds || keys.contains(AUTH_DELAY)) {
            this.makeSetCommand(cmds, "", AUTH_DELAY, "auth-retry-delay");
        }
        if (allCmds || keys.contains(DEST_RETRY)) {
            this.makeSetCommand(cmds, "", DEST_RETRY, "dest-retry");
        }
        if (allCmds || keys.contains(SAM_IP)) {
            this.makeSetCommand(cmds, "", SAM_IP, "sam-addr");
        }
        if (allCmds || keys.contains(GW_STATUS)) {
            this.makeSetCommand(cmds, "", GW_STATUS, "gw-state");
        }
        if (allCmds || keys.contains(FTP_IP)) {
            this.makeSetCommand(cmds, "", FTP_IP, "ftp");
        }
        if (allCmds || keys.contains(H225_SIGPORT)) {
            this.makeSetCommand(cmds, "", H225_SIGPORT, "h225-sigport");
        }
        if (allCmds || keys.contains(H225_T303)) {
            this.makeSetCommand(cmds, "", H225_T303, "h225-t303");
        }
        if (allCmds || keys.contains(H225_T310)) {
            this.makeSetCommand(cmds, "", H225_T310, "h225-t310");
        }
        if (allCmds || keys.contains(H225_T301)) {
            this.makeSetCommand(cmds, "", H225_T301, "h225-t301");
        }
        if (allCmds || keys.contains(VOICE_DIR)) {
            this.makeSetCommand(cmds, "", VOICE_DIR, "voice-dir");
        }
        if (allCmds || keys.contains(GW_SECRET)) {
            this.makeSetCommand(cmds, "", GW_SECRET, "gw-secret");
        }
        if (allCmds || keys.contains(SAM_PORT)) {
            this.makeSetCommand(cmds, "", SAM_PORT, "sam-port");
        }
        if (allCmds || keys.contains(RAS_RRQ_RETRY)) {
            this.makeSetCommand(cmds, "", RAS_RRQ_RETRY, "ras-rrq-retry");
        }
        if (allCmds || keys.contains(RAS_RRQ_TIMEOUT)) {
            this.makeSetCommand(cmds, "", RAS_RRQ_TIMEOUT, "ras-rrq-timeout");
        }
        if (allCmds || keys.contains(RAS_ARQ_RETRY)) {
            this.makeSetCommand(cmds, "", RAS_ARQ_RETRY, "ras-arq-retry");
        }
        if (allCmds || keys.contains(RAS_ARQ_TIMEOUT)) {
            this.makeSetCommand(cmds, "", RAS_ARQ_TIMEOUT, "ras-arq-timeout");
        }
        if (allCmds || keys.contains(RAS_URQ_RETRY)) {
            this.makeSetCommand(cmds, "", RAS_URQ_RETRY, "ras-urq-retry");
        }
        if (allCmds || keys.contains(RAS_URQ_TIMEOUT)) {
            this.makeSetCommand(cmds, "", RAS_URQ_TIMEOUT, "ras-urq-timeout");
        }
        if (allCmds || keys.contains(RAS_REREG)) {
            this.makeSetCommand(cmds, "", RAS_REREG, "ras-init-reregistration");
        }
        if (allCmds || keys.contains(RAS_TIMETOLIVE)) {
            this.makeSetCommand(cmds, "", RAS_TIMETOLIVE, "ras-timetolive");
        }
        if (allCmds || keys.contains(UID_MAX)) {
            this.makeSetCommand(cmds, "", UID_MAX, "uid-max");
        }
        if (allCmds || keys.contains(PIN_MAX)) {
            this.makeSetCommand(cmds, "", PIN_MAX, "pin-max");
        }
        if (allCmds || keys.contains(UIDPIN_RETRY)) {
            this.makeSetCommand(cmds, "", UIDPIN_RETRY, "uidpin-retry");
        }
        if (allCmds || keys.contains(ECHO_CAN)) {
            this.makeSetCommand(cmds, "", ECHO_CAN, "echo-cancellation");
        }
        if (allCmds || keys.contains(FRAMES_PER_PACKET)) {
            this.makeSetCommand(cmds, "", FRAMES_PER_PACKET, "frames-per-packet");
        }
        if (allCmds || keys.contains(MAX_JITTER)) {
            this.makeSetCommand(cmds, "", MAX_JITTER, "max-jitter");
        }
        if (allCmds || keys.contains(MIN_JITTER)) {
            this.makeSetCommand(cmds, "", MIN_JITTER, "min-jitter");
        }
        if (allCmds || keys.contains(CODEC)) {
            this.makeSetCommand(cmds, "", CODEC, "codec");
        }
        if (allCmds || keys.contains(VOICE_SERVICE)) {
            this.makeSetCommand(cmds, "", VOICE_SERVICE, "service voice");
        }
        if (allCmds || keys.contains(FAX_SERVICE)) {
            this.makeSetCommand(cmds, "", FAX_SERVICE, "service fax");
        }
        if (allCmds || keys.contains(FAX_MAX_PAYLOAD)) {
            this.makeSetCommand(cmds, "", FAX_MAX_PAYLOAD, "fax-max-payload");
        }
        if (allCmds || keys.contains(FAX_FRAMES_PACKET)) {
            this.makeSetCommand(cmds, "", FAX_FRAMES_PACKET, "fax-frames-per-packet");
        }
        if (allCmds || keys.contains(FAX_BUILDOUT)) {
            this.makeSetCommand(cmds, "", FAX_BUILDOUT, "fax-buildout");
        }
        return cmds.size() > start;
    }
}

