/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPSecProfileRule;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;
import java.util.Enumeration;

public class LEIPSecProfile
extends LETable {
    String m_name;

    public LEIPSecProfile(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
    }

    public Object clone() {
        LEIPSecProfile config = new LEIPSecProfile(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public LEVector add(String pfilter, String sa) {
        LEPMCommand ret;
        StringBuffer buf;
        LEVector errors = null;
        int num = this.size() + 1;
        if (pfilter.length() > 0) {
            buf = new StringBuffer("set ");
            buf.append(" sec-profile ");
            buf.append(this.m_name);
            buf.append(" ");
            buf.append(num);
            buf.append(" policy-filter ");
            buf.append(pfilter);
            ret = this.m_facade.execute(new String(buf));
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
                return errors;
            }
        }
        if (sa.length() > 0) {
            buf = new StringBuffer("set ");
            buf.append(" sec-profile ");
            buf.append(this.m_name);
            buf.append(" ");
            buf.append(num);
            buf.append(" static-sa ");
            buf.append(sa);
            ret = this.m_facade.execute(new String(buf));
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
                return errors;
            }
        }
        ret = this.m_facade.execute("save all");
        this.refresh();
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(int ruleNum) {
        int numRules = this.size();
        if (ruleNum > numRules) {
            return null;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append("sec-profile ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(ruleNum);
        LEVector errors = null;
        LEPMCommand ret = this.m_facade.execute(new String(buf));
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        this.refresh();
        return errors;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
        Enumeration enumeration = this.m_fields.elements();
        while (enumeration.hasMoreElements()) {
            ((LEIPSecProfileRule)enumeration.nextElement()).setName(this.m_name);
        }
    }

    LEConfig createConfig(String key) {
        return new LEIPSecProfileRule(this.m_facade, this.m_name, key);
    }
}

