/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LELine;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.util.LEVector;

public class LEMuxChannel
extends LEConfig {
    public static final String LOOP = "462";
    public static final String CHANNEL = "channel";
    public static final int KEY_COUNT = 2;
    public static final String AUTO = "auto";
    static String[] s_keys = null;
    String m_number;
    boolean m_reboot;
    String m_last;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[2];
            int i = 0;
            LEMuxChannel.s_keys[i++] = LOOP;
            LEMuxChannel.s_keys[i++] = CHANNEL;
        }
        return s_keys;
    }

    public LEMuxChannel(LEConnectionFacade facade, String board, String key) {
        super(facade, board);
        this.m_number = key;
    }

    public Object clone() {
        LEMuxChannel config = new LEMuxChannel(this.m_facade, this.m_board, this.m_number);
        config.copy(this);
        return config;
    }

    public boolean requiresPowerCycle(String key) {
        return key.equals(CHANNEL);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int size = cmds.size();
        if (allCmds || keys.contains(LOOP)) {
            StringBuffer buf = new StringBuffer();
            buf.append("set mux channel-loop ");
            buf.append(this.m_number);
            buf.append(" ");
            buf.append((String)this.get(LOOP));
            cmds.addElement(buf.toString());
        }
        if (!allCmds && keys.contains(CHANNEL)) {
            LELine line;
            LELines lines;
            String lineno;
            String slot;
            LEBoards boards = (LEBoards)this.getOwner().getOwner().getOwner();
            String value = (String)this.get(CHANNEL);
            boolean blank = false;
            if (value.length() > 0) {
                slot = value.substring(0, 1);
                lineno = "line" + value.substring(2);
            } else {
                blank = true;
                value = this.m_last;
                slot = value.substring(0, 1);
                lineno = "line" + value.substring(2);
            }
            LEBoard board = (LEBoard)boards.get(slot);
            if (board != null && (lines = (LELines)board.get(LEBoard.LINES)) != null && (line = (LELine)lines.get(lineno)) != null) {
                this.setLineValues(line, this.m_number, blank);
                line.getChanges(cmds);
            }
            this.m_last = value;
        }
        return cmds.size() > size;
    }

    void setLineValues(LELine line, String channel, boolean blank) {
        if (blank) {
            line.set("477", "local");
        } else {
            line.set("477", "mux card");
            line.set("478", String.valueOf(this.m_board) + ":" + channel);
        }
    }
}

