/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LENewEntry;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEIPSecSA;
import COM.livingston.model.LEIPSecSAs;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESAs;
import COM.livingston.model.LETable;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPSecSAsForm
extends LETableForm {
    String m_addName;

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IPSec SA", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An SA name must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LESAs lESAs = (LESAs)lEPortMaster.get("2424832");
        if (lESAs.getSA(this.m_addName) == null) {
            LEIPSecSAs lEIPSecSAs = (LEIPSecSAs)this.getTable(lEPortMaster);
            LEVector lEVector = lEIPSecSAs.add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
            this.addEntry(lEPortMaster.getHostname(), lEIPSecSAs, this.m_addName);
            lENewEntry = new LENewEntry(lEPortMaster, lEIPSecSAs, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains an SA named " + this.m_addName);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEIPSecSAs)) {
            return;
        }
        LEIPSecSAs lEIPSecSAs = (LEIPSecSAs)lETable;
        LEVector lEVector = lEIPSecSAs.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        if (!(object instanceof LEIPSecSA)) {
            return null;
        }
        LEIPSecSA lEIPSecSA = (LEIPSecSA)object;
        LEIPSecSAs lEIPSecSAs = (LEIPSecSAs)this.getTable(lEPortMaster);
        String string = lEIPSecSA.getName();
        LESAs lESAs = (LESAs)lEPortMaster.get("2424832");
        if (lESAs.getSA(string) != null) {
            string = LEIPSecSAsForm.GetUniqueKey(lESAs, string, 8);
        }
        if ((lEVector = lEIPSecSAs.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            string = null;
        }
        return string;
    }

    static String GetUniqueKey(LESAs lESAs, String string, int n) {
        boolean bl = false;
        int n2 = 1;
        String string2 = string;
        while (!bl) {
            String string3 = Integer.toString(n2);
            if (string.length() + string3.length() > n) {
                string = string.substring(0, n - string3.length());
            }
            if (lESAs.getSA(string2 = String.valueOf(string) + string3) == null) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return string2;
    }
}

