/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDebugFactory;
import COM.livingston.backend.LEDebugMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEDebugFacility;
import COM.livingston.model.LEDialerStatusMessage;
import COM.livingston.model.LEDialerUpdateMessage;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEVector;

public class LEDialer
extends LEObservable
implements LEAMObserver {
    private static final String IDLE = "IDLE";
    private static final String CONNECTING = "CONNECTING";
    private static final String ESTABLISHED = "ESTABLISHED";
    private static final int SESSION_MONITOR = 65536;
    private static final int MONITOR_TIME = 3000;
    private static final int DIAL_DEBUG = 17;
    LELocation m_location;
    boolean m_locexists = false;
    LEPortMaster m_pm;
    String m_port;
    String m_slot;
    String m_previous_state = "";
    int m_dial_count;
    long m_monitorID;
    boolean m_debug;

    public LEDialer(LEPortMaster pm) {
        this.m_pm = pm;
        this.m_dial_count = 0;
        this.m_port = "";
        this.m_slot = "";
        this.m_debug = false;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public LEVector setLocation(LELocation loc) {
        LEVector errs = new LEVector();
        this.m_location = (LELocation)loc.clone();
        LELocations locations = (LELocations)this.m_pm.get("1703936");
        LEVector keys = locations.getKeys();
        if (keys.contains(this.m_location.getName())) {
            this.m_locexists = true;
        } else {
            locations.set(this.m_location.getName(), this.m_location);
            errs = locations.saveChanges();
        }
        return errs;
    }

    public LEVector removeLocation() {
        LEVector errs = new LEVector();
        if (!this.m_locexists) {
            LELocations locs = (LELocations)this.m_pm.get("1703936");
            errs = locs.delete(this.m_location.getName());
        }
        return errs;
    }

    public void dialLocation() {
        int slot_num = -1;
        String dial_cmd = "dial " + this.m_location.getName();
        LEMonitorFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
        if (this.m_debug) {
            LEDebugFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
            LEDebugFacility facility = this.m_pm.getDebugFacility();
            if (facility != null) {
                facility.startDebug(393216, 17, -1);
            }
        }
        LEPMCommand pmcommand = this.m_pm.execute(dial_cmd);
        String result = pmcommand.getResult();
        if (!pmcommand.getStatus()) {
            this.sendFailMessage(result);
        } else {
            int index = result.indexOf("using");
            if (index > -1) {
                String portstr = result.substring(index + 6);
                this.m_port = (index = portstr.indexOf(" ")) > -1 ? portstr.substring(0, index).trim() : portstr.trim();
            }
            if ((index = result.indexOf("Slot")) > -1) {
                this.m_slot = result.substring(index + 4).trim();
                slot_num = Integer.parseInt(this.m_slot);
            }
            try {
                this.m_monitorID = slot_num > -1 ? this.m_pm.getDSS().monitor(65536, 3000, slot_num) : this.m_pm.getDSS().monitor(65536, 3000);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                this.sendFailMessage(e.getMessage());
                this.disconnect();
            }
            LEDialerUpdateMessage debug_msg = new LEDialerUpdateMessage();
            debug_msg.setMessage(result);
            this.notifyObservers(debug_msg);
        }
    }

    public void cancelDial() {
        if (this.m_port != null) {
            StringBuffer cancel_cmd = new StringBuffer();
            cancel_cmd.append("reset ");
            cancel_cmd.append(this.m_port);
            LEPMCommand pmcommand = this.m_pm.execute(cancel_cmd.toString());
            if (!pmcommand.getStatus()) {
                StringBuffer errmsg = new StringBuffer();
                errmsg.append("Could not reset port ");
                errmsg.append(this.m_port);
                this.notifyObservers(errmsg.toString());
            } else {
                StringBuffer msg = new StringBuffer();
                msg.append("Reset port ");
                msg.append(this.m_port);
                LEDialerUpdateMessage dmsg = new LEDialerUpdateMessage();
                dmsg.setMessage(msg.toString());
                this.notifyObservers(dmsg);
            }
        }
    }

    public void update(LEAMFactory factory, String host, Object data) {
        if (data instanceof LEMonSessionsMessage) {
            LEMonSessionsMessage msg = (LEMonSessionsMessage)data;
            if (!this.m_slot.equals("") && !msg.getBoard().equals(this.m_slot)) {
                return;
            }
            if (!msg.getPortName().equals(this.m_port)) {
                return;
            }
            String status = msg.getStatus();
            if (this.m_dial_count < 10) {
                ++this.m_dial_count;
            } else {
                this.sendFailMessage(null);
                this.disconnect();
            }
            if (status.equals(IDLE)) {
                if (this.m_previous_state.equals(CONNECTING)) {
                    this.sendFailMessage(null);
                    this.disconnect();
                }
                this.m_previous_state = status;
            } else if (status.equals(CONNECTING)) {
                this.m_previous_state = status;
            } else if (status.equals(ESTABLISHED)) {
                this.sendSuccessMessage();
                this.disconnect();
            }
        } else if (data instanceof LEDebugMessage) {
            LEDebugMessage debug_msg = (LEDebugMessage)data;
            LEDialerUpdateMessage msg = new LEDialerUpdateMessage();
            msg.setMessage(debug_msg.getData());
            this.notifyObservers(msg);
        }
    }

    protected void sendFailMessage(String reason) {
        LEDialerStatusMessage msg = new LEDialerStatusMessage();
        msg.setSuccess(false);
        msg.setPortName(this.m_port);
        msg.setBoard(this.m_slot);
        msg.setLocation(this.m_location.getName());
        msg.setMessage(reason);
        this.notifyObservers(msg);
    }

    protected void sendSuccessMessage() {
        LEDialerStatusMessage msg = new LEDialerStatusMessage();
        msg.setSuccess(true);
        msg.setPortName(this.m_port);
        msg.setBoard(this.m_slot);
        msg.setLocation(this.m_location.getName());
        this.notifyObservers(msg);
    }

    protected void disconnect() {
        LEMonitorFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        LEDebugFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        try {
            this.m_pm.getDSS().killMonitor(this.m_monitorID);
            LEDebugFacility facility = this.m_pm.getDebugFacility();
            facility.stopDebug(393216, 17, -1);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

