/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEAlarmFactory;
import com.lucent.ra.nms.backend.LEAlarmMessage;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class LEAlarmFacility_RI
extends UnicastRemoteObject
implements LEAlarmFacility_R,
LEAMObserver,
Runnable {
    LEDSSPortMaster_RI m_dss;
    LEVector m_alarms = new LEVector();
    String m_id;
    long m_req;
    boolean m_running = true;

    public LEAlarmFacility_RI(LEDSSPortMaster_RI dss) throws RemoteException {
        this.m_dss = dss;
        this.m_id = this.m_dss.getResourceID();
        LEStatusFactory.GetFactory().addObserver(this.m_id, this);
        LEAlarmFactory.GetFactory().addObserver(this.m_id, this);
        new Thread(this).start();
    }

    public LEVector getAlarms() throws RemoteException {
        return this.m_alarms;
    }

    public boolean clearAlarm(String id) throws RemoteException {
        if (this.m_req == 0L || !this.m_dss.isConnected()) {
            return false;
        }
        boolean success = true;
        try {
            this.m_dss.clearAlarm(Long.parseLong(id));
            int len = this.m_alarms.size();
            int i = len - 1;
            while (i > -1) {
                LEAlarmMessage msg = (LEAlarmMessage)this.m_alarms.elementAt(i);
                if (msg.getName().equals(id)) {
                    this.alarmCleared(msg);
                }
                --i;
            }
        }
        catch (Exception exception) {
            success = false;
        }
        return success;
    }

    public synchronized void update(LEAMFactory factory, String host, Object arg) {
        if (arg instanceof LEAlarmMessage) {
            this.updateAlarm((LEAlarmMessage)arg);
        } else if (arg instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)arg);
        }
    }

    public void run() {
        while (this.m_running) {
            try {
                LEAlarmFacility_RI lEAlarmFacility_RI;
                if (this.m_dss.isConnected()) {
                    this.markAlarmsStale();
                    this.startAlarms();
                    lEAlarmFacility_RI = this;
                    synchronized (lEAlarmFacility_RI) {
                        if (this.m_running) {
                            this.wait(5000L);
                        }
                    }
                    this.stopAlarms();
                    lEAlarmFacility_RI = this;
                    synchronized (lEAlarmFacility_RI) {
                        if (this.m_running) {
                            this.wait(5000L);
                        }
                        if (this.m_running) {
                            this.checkAlarms();
                        }
                        if (this.m_running) {
                            this.wait(20000L);
                        }
                        continue;
                    }
                }
                lEAlarmFacility_RI = this;
                synchronized (lEAlarmFacility_RI) {
                    if (this.m_running) {
                        this.wait(60000L);
                    }
                }
            }
            catch (Exception e) {
                LEDebug.getLog().logln(10, e);
            }
        }
    }

    void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_id, this);
        LEAlarmFactory.GetFactory().deleteObserver(this.m_id, this);
        LEAlarmFacility_RI lEAlarmFacility_RI = this;
        synchronized (lEAlarmFacility_RI) {
            this.m_running = false;
            this.notifyAll();
        }
    }

    void updateAlarm(LEAlarmMessage msg) {
        String id = msg.getName();
        int len = this.m_alarms.size();
        boolean found = false;
        int i = 0;
        while (!found && i < len) {
            LEAlarmMessage alarm = (LEAlarmMessage)this.m_alarms.elementAt(i);
            if (id.equals(alarm.getName())) {
                found = true;
                this.m_alarms.setElementAt(msg, i);
            }
            ++i;
        }
        if (!found) {
            this.m_alarms.addElement(msg);
        }
    }

    void updateStatus(LEStatusMessage msg) {
        switch (msg.getStatus()) {
            case 2: 
            case 4: {
                this.m_alarms.removeAllElements();
                break;
            }
        }
    }

    void markAlarmsStale() {
        int len = this.m_alarms.size();
        int i = 0;
        while (i < len) {
            LEAlarmMessage alarm = (LEAlarmMessage)this.m_alarms.elementAt(i);
            alarm.setState("Stale");
            ++i;
        }
    }

    void checkAlarms() {
        int len = this.m_alarms.size();
        int i = 0;
        while (i < len) {
            LEAlarmMessage alarm = (LEAlarmMessage)this.m_alarms.elementAt(i);
            if (alarm.getState().equals("Stale")) {
                this.alarmCleared(alarm);
            }
            ++i;
        }
    }

    void alarmCleared(LEAlarmMessage msg) {
        msg.clear();
        LEAMRouter_RI.GetAMRouter().distribute(msg.getResourceID(), "ALARM", msg);
    }

    void startAlarms() {
        try {
            this.m_req = this.m_dss.alarm(655360);
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    void stopAlarms() {
        try {
            if (this.m_req > 0L && this.m_dss.isConnected()) {
                this.m_dss.killAlarm(this.m_req);
            }
            this.m_req = 0L;
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

