/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAsyncMessage;
import com.lucent.ra.nms.backend.LEAsyncCmdMessage;
import com.lucent.ra.nms.backend.LEEntityFactory;
import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LETokenizer;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;

public class LEAsyncCmdFactory
extends LEEntityFactory {
    public static final String ASYNC = "ASYNC";
    static LEAsyncCmdFactory s_factory = null;
    LEEntityMessage m_msg;
    String m_next;

    public static LEAMFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEAsyncCmdFactory();
        }
        return s_factory;
    }

    public static void Register() {
        LEAsyncCmdFactory.GetFactory();
    }

    protected LEAsyncCmdFactory() {
        LEAMFactory.GetFactory().register(ASYNC, this);
    }

    protected void produce(LEAsyncMessage msg, LEVector observers) {
        if (observers == null) {
            return;
        }
        Object obj = msg.getData();
        if (obj instanceof LEEntityMessage) {
            this.notify(observers, msg.getID(), obj);
            return;
        }
        if (!(obj instanceof LETokenizer)) {
            return;
        }
        LETokenizer tok = (LETokenizer)obj;
        int request = -1;
        try {
            request = tok.getNextInt();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return;
        }
        String id = msg.getID();
        long timestamp = msg.getTimestamp();
        Object emsg = null;
        String name = null;
        StringBuffer currentvalue = new StringBuffer();
        boolean more = true;
        int pos = -1;
        while (more) {
            try {
                int tmp = tok.getNextInt();
                String value = tok.getNextQuotedString();
                if (tmp >= 65536) {
                    if (value.equals(name) && value.length() != 0) continue;
                    if (this.m_msg == null) {
                        this.m_msg = this.createMessage(id, request, tmp, value);
                    }
                    if (this.m_msg != null) {
                        this.m_msg.setTimestamp(timestamp);
                    }
                    name = value;
                    continue;
                }
                if (this.m_msg == null) continue;
                pos = value.indexOf("\r\n");
                if (pos > -1) {
                    if (this.m_next != null) {
                        currentvalue.append(this.m_next);
                    }
                    currentvalue.append(value.substring(0, pos));
                    this.m_next = value.substring(pos + 2);
                } else {
                    currentvalue.append(value);
                    this.m_next = null;
                }
                this.m_msg.setAttribute(tmp, currentvalue.toString());
            }
            catch (IOException iOException) {
                more = false;
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                more = false;
            }
        }
        if (this.m_msg != null && pos > -1) {
            this.notify(observers, id, this.m_msg);
            this.m_msg = null;
        }
    }

    LEEntityMessage createMessage(String id, int request, int entity, String name) {
        return new LEAsyncCmdMessage(id, request, name);
    }
}

