/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAsyncMessage;
import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LETokenizer;
import com.lucent.ra.nms.util.LEVector;
import java.io.EOFException;

public class LEDebugFactory
extends LEAMFactory {
    public static final String DEBUG = "DEBUG";
    static LEDebugFactory s_factory = null;

    public static LEAMFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEDebugFactory();
        }
        return s_factory;
    }

    public static void Register() {
        LEDebugFactory.GetFactory();
    }

    protected LEDebugFactory() {
        LEAMFactory.GetFactory().register(DEBUG, this);
    }

    protected void produce(LEAsyncMessage msg, LEVector observers) {
        if (observers == null) {
            return;
        }
        LETokenizer tok = (LETokenizer)msg.getData();
        if (tok == null) {
            return;
        }
        int request = -1;
        try {
            request = tok.getNextInt();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            return;
        }
        String id = msg.getID();
        long timestamp = msg.getTimestamp();
        try {
            while (true) {
                int tmp = tok.getNextInt();
                String value = tok.getNextQuotedString();
                if (tmp != 120) continue;
                this.notify(observers, id, new LEDebugMessage(request, timestamp, value, id));
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

