/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LERenameDialog;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LELoginUser;
import com.lucent.ra.nms.model.LELoginUsers;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LELoginUsersForm
extends LETableForm {
    String m_addName;

    public LELoginUsersForm() {
        this.m_renameEntries = true;
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Login User", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.getFrame(this), "A user name must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
        if (lEUsers.getUser(this.m_addName) == null) {
            LELoginUsers lELoginUsers = (LELoginUsers)this.getTable(lEPortMaster);
            LEVector lEVector = lELoginUsers.add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.getFrame(this), lEPortMaster.getConnectionFacade(), lEVector);
            }
            this.addEntry(lEPortMaster.getDescription(), lELoginUsers, this.m_addName);
            lENewEntry = new LENewEntry(lEPortMaster, lELoginUsers, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.getFrame(this), String.valueOf(lEPortMaster.getDescription()) + " already contains a user named " + this.m_addName);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LELoginUsers)) {
            return;
        }
        LELoginUsers lELoginUsers = (LELoginUsers)lETable;
        LEVector lEVector = lELoginUsers.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.getFrame(this), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        if (!(object instanceof LELoginUser)) {
            return null;
        }
        LELoginUser lELoginUser = (LELoginUser)object;
        LELoginUsers lELoginUsers = (LELoginUsers)this.getTable(lEPortMaster);
        String string = lELoginUser.getName();
        LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
        if (lEUsers.getUser(string) != null) {
            string = LELoginUsersForm.GetUniqueKey(lEUsers, string, 8);
        }
        if ((lEVector = lELoginUsers.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.getFrame(this), lEPortMaster.getConnectionFacade(), lEVector);
            string = null;
        }
        return string;
    }

    static String GetUniqueKey(LEUsers lEUsers, String string, int n) {
        boolean bl = false;
        int n2 = 1;
        String string2 = string;
        while (!bl) {
            String string3 = Integer.toString(n2);
            if (string.length() + string3.length() > n) {
                string = string.substring(0, n - string3.length());
            }
            if (lEUsers.getUser(string2 = String.valueOf(string) + string3) == null) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return string2;
    }

    String renameEntry(LEPortMaster lEPortMaster, LETable lETable, String string) {
        String string2 = null;
        LERenameDialog lERenameDialog = new LERenameDialog(LEUiUtils.GetBaseFrame(), lETable.getKeySpec(), string);
        String string3 = lERenameDialog.getNewName();
        if (string3 != null) {
            LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
            Object object = lEUsers.getUser(string3);
            if (object == null) {
                LEVector lEVector = ((LELoginUsers)lETable).add(string3);
                if (lEVector == null) {
                    string2 = string3;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a user named " + string3);
            }
        }
        return string2;
    }
}

