/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LELine;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LEMuxChannel;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEVector;

public class LEChannels
extends LETable {
    public LEChannels(LEConnectionFacade facade, String board, String key) {
        super(facade, board, key);
    }

    public Object clone() {
        LEChannels config = new LEChannels(this.m_facade, this.m_board, this.m_fetchKey);
        config.copy(this);
        return config;
    }

    public void refresh() {
        LEBoards boards = (LEBoards)this.getOwner().getOwner();
        LEVector keys = boards.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            LELines lines;
            String id = (String)keys.elementAt(i);
            LEBoard board = (LEBoard)boards.get(id);
            if (board != null && (lines = (LELines)board.get(LEBoard.LINES)) != null) {
                lines.refresh();
            }
            ++i;
        }
        this.m_fetched = false;
        this.fetch();
    }

    public void refetch() {
        this.m_fetched = false;
        this.fetch();
    }

    void fetch() {
        LEBoard board;
        String id;
        if (this.m_fetched) {
            return;
        }
        StringBuffer buf = new StringBuffer("Getting ");
        buf.append(this.getDescription());
        if (this.m_board != null) {
            buf.append(" for board ");
            buf.append(this.m_board);
        }
        buf.append(" from ");
        buf.append(this.m_facade.getDescription());
        LEStatusManager.SetStatus(buf.toString());
        this.m_facade.getConfig(this.m_fetchKey, this.m_board);
        this.m_fetched = true;
        LEBoards boards = (LEBoards)this.getOwner().getOwner();
        LEVector keys = boards.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            id = (String)keys.elementAt(i);
            board = (LEBoard)boards.get(id);
            if (board != null) {
                this.extractBoardInfo(id, board);
            }
            ++i;
        }
        int max = 28;
        board = (LEBoard)this.getOwner();
        if (board.getType().equals("E3 Mux")) {
            max = 32;
        }
        int i2 = 1;
        while (i2 <= max) {
            id = Integer.toString(i2);
            LEMuxChannel muxchan = (LEMuxChannel)this.get(id);
            if (muxchan != null) {
                String channel = (String)muxchan.get("channel");
                if (channel == null) {
                    muxchan.setField("channel", "");
                }
            } else {
                muxchan = new LEMuxChannel(this.getConnectionFacade(), this.m_board, this.m_fetchKey);
                muxchan.setField("channel", "");
                this.setField(id, muxchan);
            }
            ++i2;
        }
    }

    void extractBoardInfo(String slot, LEBoard board) {
        LELines lines = (LELines)board.get(LEBoard.LINES);
        if (lines != null) {
            LEVector keys = lines.getKeys();
            int len = keys.size();
            int i = 0;
            while (i < len) {
                String id = (String)keys.elementAt(i);
                LELine line = (LELine)lines.get(id);
                this.extractLineInfo(slot, id, line);
                ++i;
            }
        }
    }

    void extractLineInfo(String board, String id, LELine line) {
        String type = (String)line.get("477");
        if (type == null || type.equals("local")) {
            return;
        }
        String source = (String)line.get("478");
        int index = source.indexOf(58);
        String slot = source.substring(0, index);
        String channel = source.substring(index + 1);
        String lineno = id.substring(4);
        LEMuxChannel muxchan = (LEMuxChannel)this.m_fields.get(channel);
        if (muxchan == null) {
            muxchan = new LEMuxChannel(this.getConnectionFacade(), this.m_board, this.m_fetchKey);
            muxchan.setField("462", "auto");
            this.setField(channel, muxchan);
        }
        muxchan.setField("channel", String.valueOf(board) + " " + lineno);
        muxchan.m_last = String.valueOf(board) + " " + lineno;
    }

    LEConfig createConfig(String key) {
        return new LEMuxChannel(this.m_facade, this.m_board, key);
    }
}

