/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDHCP;
import com.lucent.ra.nms.model.LEEthernet;
import com.lucent.ra.nms.model.LEEthernets;
import com.lucent.ra.nms.model.LEFilterFileParser;
import com.lucent.ra.nms.model.LEFilters;
import com.lucent.ra.nms.model.LEGlobal;
import com.lucent.ra.nms.model.LELocationFileParser;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LENATMaps;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.model.LESNMP;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;

public class LEFileConnectionFacade
implements LEConnectionFacade {
    LEConnectionManager m_cm;
    String m_path;
    String m_id;
    LEConfig m_config;
    LEDSSFlatFile m_dssfile;
    int m_mode;

    public LEFileConnectionFacade(LEConnectionManager cm, LEConfig config, String dirname, String filename) {
        this.m_cm = cm;
        this.m_path = LEAppInfo.createFullPath(dirname, filename);
        this.m_id = LEResourceID.CreateFile_ID(this.m_path);
        this.m_config = config;
        this.m_dssfile = null;
        this.m_mode = -1;
    }

    public LEFileConnectionFacade(LEConnectionManager cm, LEConfig config, String fullpath) {
        this.m_cm = cm;
        this.m_path = fullpath;
        this.m_id = LEResourceID.CreateFile_ID(this.m_path);
        this.m_config = config;
        this.m_dssfile = null;
        this.m_mode = -1;
    }

    public LEDSS getDSS() {
        return this.m_dssfile;
    }

    public String getResourceID() {
        return this.m_id;
    }

    public String getDescription() {
        return this.m_path;
    }

    public boolean getConfig(String key) {
        try {
            this.openFile(0);
            LEVector cmds = this.m_dssfile.getCommands();
            if (key.equals("filter")) {
                LEFilterFileParser parser = new LEFilterFileParser();
                parser.readFilters(cmds);
                LEFilters filters = parser.getFilters();
                this.m_config.set(key, filters);
            } else if (key.equals("1703936")) {
                LELocationFileParser parser = new LELocationFileParser();
                parser.createPatterns();
                parser.readLocations(cmds);
                LELocations locations = parser.getLocations();
                this.m_config.set(key, locations);
            } else if (key.equals("2686976")) {
                LENATMaps maps = new LENATMaps(this);
                this.m_config.set(key, maps);
            } else if (key.equals("3670032")) {
                LEDHCP dhcp = new LEDHCP(this);
                this.m_config.set(key, dhcp);
            } else if (key.equals("262144")) {
                LEPorts ports = new LEPorts(this);
                this.m_config.set(key, ports);
            } else if (key.equals("720896")) {
                LEEthernets ethers = new LEEthernets(this);
                this.m_config.set(key, ethers);
                LEEthernet ether = new LEEthernet(this, "ether0");
                ethers.set("ether0", ether);
            } else if (key.equals("2162688")) {
                LEGlobal global = new LEGlobal(this);
                this.m_config.set(key, global);
            } else if (key.equals("1376256")) {
                LESNMP snmp = new LESNMP(this);
                this.m_config.set(key, snmp);
            }
        }
        catch (LEDSSException lEDSSException) {
            return false;
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public boolean getConfig(String key, String board_id) {
        return this.getConfig(key);
    }

    public LEVector getTOC(int entity) {
        return null;
    }

    public LEPMCommand execute(String command) {
        LEVector cmd = new LEVector(1);
        cmd.add(command);
        LEPMCommand pmcmd = new LEPMCommand(command);
        try {
            this.openFile(1);
            this.m_dssfile.writeConfig(cmd);
            pmcmd.setStatus(true);
        }
        catch (LEDSSException lEDSSException) {
            pmcmd.setResult("No connection");
            pmcmd.setStatus(false);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            pmcmd.setResult("No connection");
            pmcmd.setStatus(false);
        }
        cmd = null;
        return pmcmd;
    }

    public boolean supportsEntities() {
        return true;
    }

    public boolean supports(int entity) {
        return true;
    }

    public void close() throws IOException {
        if (this.m_dssfile != null) {
            this.m_cm.disconnectFrom(this.m_dssfile);
        }
        this.m_dssfile = null;
    }

    public boolean isConnected() {
        return this.m_dssfile != null;
    }

    public void disconnect() {
        try {
            this.close();
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public boolean reconnect() {
        return true;
    }

    protected void openFile(int mode) throws IOException, LEDSSException {
        if (this.m_dssfile != null) {
            if (this.m_mode == mode) {
                return;
            }
            this.close();
        }
        this.m_mode = mode;
        this.m_dssfile = this.m_cm.connectToFile(this.m_path, this.m_mode);
        this.m_dssfile.connect();
    }
}

