/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.util.LEVector;

public class LEIPPool
extends LEConfig {
    public static final String GATEWAY = "75";
    public static final String RANGES = "ranges";
    public static final int KEY_COUNT = 2;
    public static final String RESET = "reset ippool";
    static String[] s_keys = null;
    String m_name;
    String m_tag;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[2];
            int i = 0;
            LEIPPool.s_keys[i++] = GATEWAY;
            LEIPPool.s_keys[i++] = RANGES;
        }
        return s_keys;
    }

    public LEIPPool(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
        this.m_tag = "ippool " + name;
    }

    public Object clone() {
        LEIPPool config = new LEIPPool(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean requiresReset(String key) {
        return key.equals(GATEWAY);
    }

    LEConfig createConfig(String key) {
        if (key.equals(RANGES)) {
            return new LEIPRanges(this.m_facade, this.m_name);
        }
        return new LEConfig(this.m_facade);
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            cmds.addElement(RESET);
            this.m_reboot = false;
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            cmds.addElement(RESET);
            this.m_reboot = false;
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String gateway;
        boolean allCmds = keys == null;
        int start = cmds.size();
        this.m_reboot = false;
        if ((allCmds || keys.contains(GATEWAY)) && (gateway = (String)this.get(GATEWAY)) != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("set ");
            buf.append("ippool ");
            buf.append(this.m_name);
            buf.append(" default-gateway ");
            buf.append(gateway);
            cmds.addElement(buf.toString());
            this.m_reboot = true;
        }
        return cmds.size() > start;
    }
}

