/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDomCustomPlans;
import com.lucent.ra.nms.model.LEIntlCustomPlans;
import com.lucent.ra.nms.model.LEPriCustomPlans;
import com.lucent.ra.nms.util.LEVector;

public class LENumberingPlan
extends LEConfig {
    public static final String COUNTRY_CODE = "61440";
    public static final String DOM_FILE = "61441";
    public static final String INTL_FILE = "61442";
    public static final String PRIVATE_FILE = "61443";
    public static final String GATEWAY_TYPE = "61444";
    public static final String INTL_PREFIX = "61445";
    public static final String TERM_NET_PREFIX = "61446";
    public static final String ORG_NET_PREFIX = "61447";
    public static final String DOM_FORMAT = "61448";
    public static final String INTL_FORMAT = "61449";
    public static final String PRIVATE_FORMAT = "61450";
    public static final String SUB_PREFIX = "61451";
    public static final String TRUNK_CODE = "61452";
    public static final String PRI_AREA_CODE = "61453";
    public static final String DIAL_TERM = "61460";
    public static final String INIT_DIG_TIME = "61461";
    public static final String INTER_DIG_TIME = "61462";
    public static final String COUNTRY_NAME = "61473";
    public static final String DIAL_MODE = "61474";
    public static final String MIN_DEST = "61475";
    public static final String SEQ_DIAL = "61476";
    public static final String NATL_TRUNK_PREFIX = "61477";
    public static final String MAX_SN = "61495";
    public static final String PRIVATE_MINDIGS = "61501";
    public static final String DOM_MINDIGS = "61502";
    public static final String INTL_MINDIGS = "61503";
    public static final String DOM_CUST_PLANS = "1048580";
    public static final String INTL_CUST_PLANS = "1048581";
    public static final String PRIVATE_CUST_PLANS = "1048582";
    public static final int KEY_COUNT = 29;
    public static final String SET_NUM = "set view numbering";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[29];
            int i = 0;
            LENumberingPlan.s_keys[i++] = COUNTRY_CODE;
            LENumberingPlan.s_keys[i++] = DOM_FILE;
            LENumberingPlan.s_keys[i++] = INTL_FILE;
            LENumberingPlan.s_keys[i++] = PRIVATE_FILE;
            LENumberingPlan.s_keys[i++] = GATEWAY_TYPE;
            LENumberingPlan.s_keys[i++] = INTL_PREFIX;
            LENumberingPlan.s_keys[i++] = TERM_NET_PREFIX;
            LENumberingPlan.s_keys[i++] = ORG_NET_PREFIX;
            LENumberingPlan.s_keys[i++] = DOM_FORMAT;
            LENumberingPlan.s_keys[i++] = INTL_FORMAT;
            LENumberingPlan.s_keys[i++] = PRIVATE_FORMAT;
            LENumberingPlan.s_keys[i++] = SUB_PREFIX;
            LENumberingPlan.s_keys[i++] = TRUNK_CODE;
            LENumberingPlan.s_keys[i++] = PRI_AREA_CODE;
            LENumberingPlan.s_keys[i++] = DIAL_TERM;
            LENumberingPlan.s_keys[i++] = INIT_DIG_TIME;
            LENumberingPlan.s_keys[i++] = INTER_DIG_TIME;
            LENumberingPlan.s_keys[i++] = COUNTRY_NAME;
            LENumberingPlan.s_keys[i++] = DIAL_MODE;
            LENumberingPlan.s_keys[i++] = MIN_DEST;
            LENumberingPlan.s_keys[i++] = SEQ_DIAL;
            LENumberingPlan.s_keys[i++] = NATL_TRUNK_PREFIX;
            LENumberingPlan.s_keys[i++] = MAX_SN;
            LENumberingPlan.s_keys[i++] = PRIVATE_MINDIGS;
            LENumberingPlan.s_keys[i++] = DOM_MINDIGS;
            LENumberingPlan.s_keys[i++] = INTL_MINDIGS;
            LENumberingPlan.s_keys[i++] = DOM_CUST_PLANS;
            LENumberingPlan.s_keys[i++] = INTL_CUST_PLANS;
            LENumberingPlan.s_keys[i++] = PRIVATE_CUST_PLANS;
        }
        return s_keys;
    }

    public LENumberingPlan(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LENumberingPlan config = new LENumberingPlan(this.m_facade);
        config.copy(this);
        return config;
    }

    public boolean requiresReboot(String key) {
        return true;
    }

    LEConfig createConfig(String key) {
        if (key.equals(DOM_CUST_PLANS)) {
            return new LEDomCustomPlans(this.m_facade, null, key);
        }
        if (key.equals(INTL_CUST_PLANS)) {
            return new LEIntlCustomPlans(this.m_facade, null, key);
        }
        if (key.equals(PRIVATE_CUST_PLANS)) {
            return new LEPriCustomPlans(this.m_facade, null, key);
        }
        return new LEConfig(this.m_facade);
    }

    String getViewCommand() {
        String cmd = null;
        StringBuffer buf = new StringBuffer(20);
        buf.append(SET_NUM);
        cmd = buf.toString();
        return cmd;
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(GATEWAY_TYPE)) {
            this.makeSetCommand(cmds, null, GATEWAY_TYPE, "gateway-type");
        }
        if (allCmds || keys.contains(COUNTRY_NAME)) {
            this.makeSetCommand(cmds, null, COUNTRY_NAME, "country-name");
        }
        if (allCmds || keys.contains(INTL_PREFIX)) {
            this.makeSetCommand(cmds, null, INTL_PREFIX, "intl-prefix");
        }
        if (allCmds || keys.contains(COUNTRY_CODE)) {
            this.makeSetCommand(cmds, null, COUNTRY_CODE, "country-code");
        }
        if (allCmds || keys.contains(NATL_TRUNK_PREFIX)) {
            this.makeSetCommand(cmds, null, NATL_TRUNK_PREFIX, "ntl-trunk-prefix");
        }
        if (allCmds || keys.contains(SUB_PREFIX)) {
            this.makeSetCommand(cmds, null, SUB_PREFIX, "trunk-prefix");
        }
        if (allCmds || keys.contains(TRUNK_CODE)) {
            this.makeSetCommand(cmds, null, TRUNK_CODE, "trunk-code");
        }
        if (allCmds || keys.contains(ORG_NET_PREFIX)) {
            this.makeSetCommand(cmds, null, ORG_NET_PREFIX, "org-net-prefix");
        }
        if (allCmds || keys.contains(TERM_NET_PREFIX)) {
            this.makeSetCommand(cmds, null, TERM_NET_PREFIX, "term-net-prefix");
        }
        if (allCmds || keys.contains(PRI_AREA_CODE)) {
            this.makeSetCommand(cmds, null, PRI_AREA_CODE, "private-area-code");
        }
        if (allCmds || keys.contains(DIAL_MODE)) {
            this.makeSetCommand(cmds, null, DIAL_MODE, "dial-type");
        }
        if (allCmds || keys.contains(MAX_SN)) {
            this.makeSetCommand(cmds, null, MAX_SN, "max-public-sn");
        }
        if (allCmds || keys.contains(MIN_DEST)) {
            this.makeSetCommand(cmds, null, MIN_DEST, "min-dest");
        }
        if (allCmds || keys.contains(SEQ_DIAL)) {
            this.makeSetCommand(cmds, null, SEQ_DIAL, "seq-dial");
        }
        if (allCmds || keys.contains(INIT_DIG_TIME)) {
            this.makeSetCommand(cmds, null, INIT_DIG_TIME, "init-timer");
        }
        if (allCmds || keys.contains(INTER_DIG_TIME)) {
            this.makeSetCommand(cmds, null, INTER_DIG_TIME, "inter-timer");
        }
        if (allCmds || keys.contains(DIAL_TERM)) {
            this.makeSetCommand(cmds, null, DIAL_TERM, "pound-sign");
        }
        if (allCmds || keys.contains(DOM_FORMAT)) {
            this.makeSetCommand(cmds, null, DOM_FORMAT, "dom-format");
        }
        if (allCmds || keys.contains(DOM_MINDIGS)) {
            this.makeSetCommand(cmds, null, DOM_MINDIGS, "dom-mindigs");
        }
        if (allCmds || keys.contains(INTL_FORMAT)) {
            this.makeSetCommand(cmds, null, INTL_FORMAT, "int-format");
        }
        if (allCmds || keys.contains(INTL_MINDIGS)) {
            this.makeSetCommand(cmds, null, INTL_MINDIGS, "int-mindigs");
        }
        if (allCmds || keys.contains(PRIVATE_FORMAT)) {
            this.makeSetCommand(cmds, null, PRIVATE_FORMAT, "pri-format");
        }
        if (allCmds || keys.contains(PRIVATE_MINDIGS)) {
            this.makeSetCommand(cmds, null, PRIVATE_MINDIGS, "private-mindigs");
        }
        if (allCmds || keys.contains(DOM_FILE)) {
            cmds.addElement("reset custom dom");
            this.makeSetCommand(cmds, null, DOM_FILE, "dom-file");
        }
        if (allCmds || keys.contains(INTL_FILE)) {
            cmds.addElement("reset custom intl");
            this.makeSetCommand(cmds, null, INTL_FILE, "int-file");
        }
        if (allCmds || keys.contains(PRIVATE_FILE)) {
            cmds.addElement("reset custom pri");
            this.makeSetCommand(cmds, null, PRIVATE_FILE, "pri-file");
        }
        return cmds.size() > start;
    }
}

