/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;

public class LEOrderedList
extends LEConfig {
    LEVector m_list = new LEVector();

    public LEOrderedList(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEOrderedList config = new LEOrderedList(this.m_facade);
        config.copy(this);
        return config;
    }

    public int length() {
        return this.m_list.size();
    }

    public LEVector getKeys(boolean fetch) {
        LEVector keys = new LEVector();
        int len = this.length();
        int i = 0;
        while (i < len) {
            keys.addElement(Integer.toString(i));
            ++i;
        }
        return keys;
    }

    public Object get(String key) {
        Object ret = null;
        try {
            int pos = Integer.parseInt(key);
            int len = this.length();
            if (pos < len) {
                ret = this.get(pos);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, "Bad key: " + key);
        }
        return ret;
    }

    public Object get(int pos) {
        return this.m_list.elementAt(pos);
    }

    public void add(Object obj) {
        this.m_list.addElement(obj);
        this.markChanged();
    }

    public void deleteAll() {
        this.m_list.removeAllElements();
        this.markChanged();
    }

    public String getDescriptionFor(String key) {
        return key;
    }

    public LEDataSpec getSpecFor(String key) {
        LEDataSpec spec = null;
        if (this.m_spec != null) {
            spec = this.m_spec.getSpecFor("entry");
        }
        return spec;
    }

    void markChanged() {
        if (this.m_changed == null) {
            this.m_changed = new LEVector();
        }
        this.setChanged();
        this.notifyObservers();
    }

    void clearList() {
        this.m_list.removeAllElements();
        this.setChanged();
        this.notifyObservers();
    }

    void addField(Object value) {
        this.m_list.addElement(value);
    }

    LEConfig addConfig() {
        int len = this.m_list.size();
        return this.getConfig(len);
    }

    LEConfig getConfig(int pos) {
        int len = this.m_list.size();
        if (pos < len) {
            return (LEConfig)this.m_list.elementAt(pos);
        }
        LEConfig config = this.createConfig();
        LEDataSpec spec = this.getSpecFor(null);
        config.setSpec(spec);
        this.addField(config);
        return config;
    }

    LEConfig createConfig() {
        return new LEConfig(this.m_facade);
    }
}

