/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LELEDs;
import com.lucent.ra.nms.util.LEResource;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEIRX_114Display
implements LEMonitorDisplay,
LEAMObserver,
ImageObserver {
    static Image s_irx = null;
    LEPortMaster m_pm;
    String m_host;
    int m_height = -1;
    int m_width = -1;
    int m_nameHeight;
    int m_x;
    int m_y;
    int m_flags;
    boolean m_blink;
    boolean m_active;
    boolean m_connected;
    boolean m_drawHeartbeat;
    boolean m_drawInterfaces;
    Image m_hb;
    Image m_etherTop;
    Image m_etherBottom;

    public LEIRX_114Display() {
        if (s_irx == null) {
            s_irx = LEResource.GetImage("rx114.gif");
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (!toolkit.prepareImage(s_irx, -1, -1, this)) {
                this.m_flags = 2;
            }
        }
        this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
        this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
        this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
    }

    public void setPortMaster(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_host = this.m_pm.getDescription();
        this.m_connected = this.m_pm.isConnected();
        LEStatusFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
        if (!this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
        }
        this.m_active = this.m_pm.getConnectionFacade().supportsEntities();
        this.startMonitoring();
    }

    public void select(int n, int n2, LEViewListener lEViewListener) {
    }

    public int getHeight(Graphics graphics) {
        if (this.m_height < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_height;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_width < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_width;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_width == -1 || this.m_height == -1) {
            this.determineSize(graphics);
        }
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(n, n2, this.m_width, this.m_height);
        Font font = LEFont.getBoldFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = n + (this.m_width - fontMetrics.stringWidth(this.m_host)) / 2;
        graphics.setColor(LEColor.getForeground());
        graphics.drawString(this.m_host, n3, n2 + fontMetrics.getAscent());
        this.m_nameHeight = fontMetrics.getHeight() + 2;
        this.m_x = n;
        this.m_y = n2 + this.m_nameHeight;
        graphics.drawImage(s_irx, this.m_x, this.m_y, this);
        this.drawHeartbeat(graphics);
        this.drawInterfaces(graphics);
        if (!this.m_active || !this.m_connected) {
            if (!this.m_connected) {
                graphics.setFont(LEFont.getFont());
                fontMetrics = graphics.getFontMetrics();
                int n4 = fontMetrics.stringWidth("Not connected") + 20;
                int n5 = fontMetrics.getHeight() + 20;
                n3 = this.m_x + (this.m_width - n4) / 2;
                int n6 = this.m_y + (this.m_height - this.m_nameHeight - n5) / 2;
                this.drawBox(graphics, n3, n6, n4, n5);
                graphics.drawString("Not connected", n3 + 10, n6 + 10 + fontMetrics.getAscent());
                return;
            }
            graphics.setFont(LEFont.getFont());
            fontMetrics = graphics.getFontMetrics();
            int n7 = fontMetrics.stringWidth("Monitoring requires ComOS 3.8 or later") + 20;
            int n8 = fontMetrics.getHeight() + 20;
            n3 = this.m_x + (this.m_width - n7) / 2;
            int n9 = this.m_y + (this.m_height - this.m_nameHeight - n8) / 2;
            this.drawBox(graphics, n3, n9, n7, n8);
            graphics.drawString("Monitoring requires ComOS 3.8 or later", n3 + 10, n9 + 10 + fontMetrics.getAscent());
        }
    }

    public synchronized int heartbeat(Graphics graphics) {
        if (this.m_active && this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.drawHeartbeat(graphics);
            this.m_drawHeartbeat = true;
            return 1;
        }
        return 0;
    }

    public synchronized int blink(Graphics graphics, boolean bl) {
        this.m_blink = bl;
        if (this.m_active && this.m_connected && this.m_drawHeartbeat) {
            this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
            this.drawHeartbeat(graphics);
        }
        if (this.m_active && this.m_connected && this.m_drawInterfaces) {
            this.drawInterfaces(graphics);
        }
        int n = this.m_flags;
        this.m_flags = 0;
        return n;
    }

    public void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        this.stopMonitoring();
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_flags |= 2;
            return false;
        }
        return true;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void determineSize(Graphics graphics) {
        this.m_width = s_irx.getWidth(this);
        this.m_height = s_irx.getHeight(this);
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        Font font = LEFont.getBoldFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.m_height += fontMetrics.getHeight() + 4;
    }

    void startMonitoring() {
    }

    void stopMonitoring() {
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.m_active = this.m_pm.getConnectionFacade().supportsEntities();
                this.m_connected = true;
                this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_flags |= 2;
                return;
            }
            case 2: 
            case 4: {
                this.m_connected = false;
                this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_flags |= 2;
                return;
            }
        }
    }

    void drawHeartbeat(Graphics graphics) {
        graphics.drawImage(this.m_hb, this.m_x + 183, this.m_y + 36, null);
        this.m_drawHeartbeat = false;
        this.m_flags |= 1;
    }

    void drawInterfaces(Graphics graphics) {
        graphics.drawImage(this.m_etherTop, this.m_x + 307, this.m_y + 33, null);
        graphics.drawImage(this.m_etherBottom, this.m_x + 307, this.m_y + 39, null);
        this.m_flags |= 1;
        this.m_drawInterfaces = false;
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }
}

