/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEAlarmFactory;
import com.lucent.ra.nms.backend.LEAlarmMessage;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class LEAlarmFacility_RI
extends UnicastRemoteObject
implements LEAlarmFacility_R,
LEAMObserver,
Runnable {
    LEDSSPortMaster_RI m_dss;
    LEVector m_alarms = new LEVector();
    String m_id;
    long m_req;
    boolean m_running = true;

    public LEAlarmFacility_RI(LEDSSPortMaster_RI lEDSSPortMaster_RI) throws RemoteException {
        this.m_dss = lEDSSPortMaster_RI;
        this.m_id = this.m_dss.getResourceID();
        LEStatusFactory.GetFactory().addObserver(this.m_id, this);
        LEAlarmFactory.GetFactory().addObserver(this.m_id, this);
        new Thread(this).start();
    }

    public LEVector getAlarms() throws RemoteException {
        return this.m_alarms;
    }

    public boolean clearAlarm(String string) throws RemoteException {
        if (this.m_req == 0L || !this.m_dss.isConnected()) {
            return false;
        }
        boolean bl = true;
        try {
            this.m_dss.clearAlarm(Long.parseLong(string));
            int n = this.m_alarms.size();
            int n2 = n - 1;
            while (n2 > -1) {
                LEAlarmMessage lEAlarmMessage = (LEAlarmMessage)this.m_alarms.elementAt(n2);
                if (lEAlarmMessage.getName().equals(string)) {
                    this.alarmCleared(lEAlarmMessage);
                }
                --n2;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEAlarmMessage) {
            this.updateAlarm((LEAlarmMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    public void run() {
        while (this.m_running) {
            try {
                LEAlarmFacility_RI lEAlarmFacility_RI;
                if (this.m_dss.isConnected()) {
                    this.markAlarmsStale();
                    this.startAlarms();
                    lEAlarmFacility_RI = this;
                    synchronized (lEAlarmFacility_RI) {
                        if (this.m_running) {
                            this.wait(5000L);
                        }
                    }
                    this.stopAlarms();
                    lEAlarmFacility_RI = this;
                    synchronized (lEAlarmFacility_RI) {
                        if (this.m_running) {
                            this.wait(5000L);
                        }
                        if (this.m_running) {
                            this.checkAlarms();
                        }
                        if (this.m_running) {
                            this.wait(20000L);
                        }
                        continue;
                    }
                }
                lEAlarmFacility_RI = this;
                synchronized (lEAlarmFacility_RI) {
                    if (this.m_running) {
                        this.wait(60000L);
                    }
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(10, exception);
            }
        }
    }

    void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_id, this);
        LEAlarmFactory.GetFactory().deleteObserver(this.m_id, this);
        LEAlarmFacility_RI lEAlarmFacility_RI = this;
        synchronized (lEAlarmFacility_RI) {
            this.m_running = false;
            this.notifyAll();
            return;
        }
    }

    void updateAlarm(LEAlarmMessage lEAlarmMessage) {
        String string = lEAlarmMessage.getName();
        int n = this.m_alarms.size();
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < n) {
            LEAlarmMessage lEAlarmMessage2 = (LEAlarmMessage)this.m_alarms.elementAt(n2);
            if (string.equals(lEAlarmMessage2.getName())) {
                bl = true;
                this.m_alarms.setElementAt(lEAlarmMessage, n2);
            }
            ++n2;
        }
        if (!bl) {
            this.m_alarms.addElement(lEAlarmMessage);
        }
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 2: 
            case 4: {
                this.m_alarms.removeAllElements();
                return;
            }
        }
    }

    void markAlarmsStale() {
        int n = this.m_alarms.size();
        int n2 = 0;
        while (n2 < n) {
            LEAlarmMessage lEAlarmMessage = (LEAlarmMessage)this.m_alarms.elementAt(n2);
            lEAlarmMessage.setState("Stale");
            ++n2;
        }
    }

    void checkAlarms() {
        int n = this.m_alarms.size();
        int n2 = 0;
        while (n2 < n) {
            LEAlarmMessage lEAlarmMessage = (LEAlarmMessage)this.m_alarms.elementAt(n2);
            if (lEAlarmMessage.getState().equals("Stale")) {
                this.alarmCleared(lEAlarmMessage);
            }
            ++n2;
        }
    }

    void alarmCleared(LEAlarmMessage lEAlarmMessage) {
        lEAlarmMessage.clear();
        LEAMRouter_RI.GetAMRouter().distribute(lEAlarmMessage.getResourceID(), "ALARM", lEAlarmMessage);
    }

    void startAlarms() {
        try {
            this.m_req = this.m_dss.alarm(655360);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void stopAlarms() {
        try {
            if (this.m_req > 0L && this.m_dss.isConnected()) {
                this.m_dss.killAlarm(this.m_req);
            }
            this.m_req = 0L;
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

