/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEIPPanel;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEBGPPrefixFormLine
extends Panel
implements LEFormLine,
MouseListener {
    LEFormLineListener m_listener;
    String m_valid;
    LEIPPanel m_ip = new LEIPPanel();
    Choice m_cidr;

    public LEBGPPrefixFormLine() {
        super(new FlowLayout(0, 0, 0));
        this.add(this.m_ip);
        this.add(new Label(" /"));
        this.m_cidr = new Choice();
        this.initCIDR();
        this.add(this.m_cidr);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public void setValue(Object object) {
        int n;
        String string = object.toString();
        if (string.length() > 0 && (n = string.indexOf(47)) > 0) {
            this.m_ip.setAddress(string.substring(0, n));
            this.m_cidr.select(string.substring(n + 1));
        }
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_ip.getAddress();
        if (string.equals("")) {
            return "";
        }
        stringBuffer.append(string);
        stringBuffer.append("/");
        stringBuffer.append(this.m_cidr.getSelectedItem());
        return stringBuffer.toString();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < 4) {
                if (n > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(0);
                ++n;
            }
            stringBuffer.append("/8 - ");
            int n2 = 0;
            while (n2 < 4) {
                if (n2 > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(255);
                ++n2;
            }
            stringBuffer.append("/32");
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object object) {
        if (object instanceof String) {
            String string = this.getValue();
            return string.equals((String)object);
        }
        return false;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean isValueValid() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void initCIDR() {
        int n = 8;
        while (n < 33) {
            this.m_cidr.add(Integer.toString(n));
            ++n;
        }
        this.m_cidr.select("20");
    }
}

