/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LELoginUsersForm;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LERenameDialog;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LENetUser;
import com.lucent.ra.nms.model.LENetUsers;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LENetUsersForm
extends LETableForm {
    String m_addName;

    public LENetUsersForm() {
        this.m_renameEntries = true;
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Network User", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A user name must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
        if (lEUsers.getUser(this.m_addName) == null) {
            LENetUsers lENetUsers = (LENetUsers)this.getTable(lEPortMaster);
            LEVector lEVector = lENetUsers.add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            }
            this.addEntry(lEPortMaster.getDescription(), lENetUsers, this.m_addName);
            lENewEntry = new LENewEntry(lEPortMaster, lENetUsers, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a user named " + this.m_addName);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LENetUsers)) {
            return;
        }
        LENetUsers lENetUsers = (LENetUsers)lETable;
        LEVector lEVector = lENetUsers.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        if (!(object instanceof LENetUser)) {
            return null;
        }
        LENetUser lENetUser = (LENetUser)object;
        LENetUsers lENetUsers = (LENetUsers)this.getTable(lEPortMaster);
        String string = lENetUser.getName();
        LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
        if (lEUsers.getUser(string) != null) {
            string = LELoginUsersForm.GetUniqueKey(lEUsers, string, 8);
        }
        if ((lEVector = lENetUsers.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            string = null;
        }
        return string;
    }

    String renameEntry(LEPortMaster lEPortMaster, LETable lETable, String string) {
        String string2 = null;
        LERenameDialog lERenameDialog = new LERenameDialog(LEUiUtils.GetBaseFrame(), lETable.getKeySpec(), string);
        String string3 = lERenameDialog.getNewName();
        if (string3 != null) {
            LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
            Object object = lEUsers.getUser(string3);
            if (object == null) {
                LEVector lEVector = ((LENetUsers)lETable).add(string3);
                if (lEVector == null) {
                    string2 = string3;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a user named " + string3);
            }
        }
        return string2;
    }
}

