/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEBGPPolicyRule;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;
import java.util.Enumeration;

public class LEBGPPolicy
extends LETable {
    private static final String ACTION = "action";
    static String[] s_keys = null;
    String m_name;

    public LEBGPPolicy(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
    }

    public void initialize() {
    }

    public Object clone() {
        LEBGPPolicy config = new LEBGPPolicy(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
        Enumeration enumeration = this.m_fields.elements();
        while (enumeration.hasMoreElements()) {
            ((LEBGPPolicyRule)enumeration.nextElement()).setName(this.m_name);
        }
    }

    public LEVector add(String action) {
        LEVector errors = null;
        int num = this.size() + 1;
        StringBuffer buf = new StringBuffer("set ");
        buf.append("bgp policy");
        buf.append(" ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(num);
        buf.append(" ");
        buf.append(action);
        LEPMCommand ret = this.m_facade.execute(new String(buf));
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            if (ret.getStatus()) {
                LEBGPPolicyRule rule = (LEBGPPolicyRule)this.getConfig(Integer.toString(num));
                rule.initialize(action);
                rule.set("417", action);
            } else {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(int ruleNum) {
        int numRules = this.size();
        if (ruleNum > numRules) {
            return null;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append("bgp policy");
        buf.append(" ");
        buf.append(this.m_name);
        buf.append(" blank");
        LEPMCommand ret = this.m_facade.execute(new String(buf));
        if (!ret.getStatus()) {
            LEVector errors = new LEVector();
            errors.addElement(ret);
            return errors;
        }
        int i = 1;
        while (i <= numRules) {
            LEBGPPolicyRule rule = (LEBGPPolicyRule)this.remove(Integer.toString(i));
            String num = i < ruleNum ? Integer.toString(i) : (i > ruleNum ? Integer.toString(i - 1) : null);
            if (num != null) {
                rule.setNumber(num);
                this.set(num, rule);
            }
            ++i;
        }
        LEVector errors = this.saveChanges();
        if (errors != null) {
            this.refresh();
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEBGPPolicyRule(this.m_facade, this.m_name, key);
    }

    boolean getDeleteCommands(LEVector cmds) {
        StringBuffer buf = new StringBuffer();
        buf.append("set ");
        buf.append("bgp policy");
        buf.append(" ");
        buf.append(this.m_name);
        buf.append(" blank");
        cmds.addElement(buf.toString());
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            LEBGPPolicyRule rule = (LEBGPPolicyRule)this.get((String)keys.elementAt(i));
            if (rule != null) {
                rule.markChanged();
            }
            ++i;
        }
        this.m_deleted.removeAllElements();
        this.m_deleted = null;
        return true;
    }
}

