/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;

public class LECustomPlans
extends LETable {
    LEVector m_orderedKeys = new LEVector();
    boolean m_chgFlag = false;
    boolean m_plansChgFlag = false;

    public LECustomPlans(LEConnectionFacade facade, String name, String key) {
        super(facade, name, key);
    }

    public Object clone() {
        LECustomPlans config = new LECustomPlans(this.m_facade, this.m_board, this.m_fetchKey);
        config.copy(this);
        return config;
    }

    public LEVector saveChanges(LEVector cmds) {
        return this.saveChanges(cmds, true);
    }

    public LEVector saveChanges(LEVector cmds, boolean reboot) {
        LEVector errors = null;
        int len = cmds.size();
        int i = 0;
        while (i < len) {
            LEPMCommand ret;
            String cmd = (String)cmds.elementAt(i);
            if (!(LEPMCommand.IsReboot(cmd) && !reboot || (ret = this.m_facade.execute(cmd)).getStatus())) {
                if (errors == null) {
                    errors = new LEVector();
                }
                errors.addElement(ret);
            }
            ++i;
        }
        if (errors == null) {
            this.setChgFlag(false);
            this.setPlansChgFlag(false);
        }
        return errors;
    }

    public LEVector getKeys() {
        if (!this.m_fetched) {
            this.fetch();
        }
        return (LEVector)this.m_orderedKeys.clone();
    }

    public void swapRows(int low, int high) {
        Object lowobj = this.m_orderedKeys.elementAt(low);
        Object highobj = this.m_orderedKeys.elementAt(high);
        try {
            this.m_orderedKeys.setElementAt(lowobj, high);
            this.m_orderedKeys.setElementAt(highobj, low);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void setChgFlag(boolean flag) {
        this.m_chgFlag = flag;
    }

    public boolean isChgFlag() {
        return this.m_chgFlag;
    }

    public void setPlansChgFlag(boolean flag) {
        this.m_plansChgFlag = flag;
    }

    public boolean isPlansChgFlag() {
        return this.m_plansChgFlag;
    }

    LEConfig getConfig(String key) {
        this.m_orderedKeys.addElement(key);
        return super.getConfig(key);
    }

    void refresh(LEConfig config) {
        int len = this.m_orderedKeys.size();
        int i = 0;
        while (i < len) {
            this.m_fields.remove((String)this.m_orderedKeys.elementAt(i));
            ++i;
        }
        this.m_orderedKeys.removeAllElements();
        this.setChgFlag(false);
        this.setPlansChgFlag(false);
        super.refresh(this);
    }

    Object remove(String key) {
        this.m_orderedKeys.removeElement(key);
        this.setChgFlag(true);
        this.setPlansChgFlag(true);
        return super.remove(key);
    }

    String makeAddCommand(String key, String tag) {
        StringBuffer buf = new StringBuffer("add ");
        buf.append("custom ");
        buf.append(tag);
        buf.append(" ");
        if (!key.equalsIgnoreCase("default")) {
            buf.append("entryname ");
        }
        buf.append(key);
        return buf.toString();
    }

    boolean getChangedCommands(LEVector cmds) {
        return false;
    }

    boolean getDeleteCommands(LEVector cmds) {
        return false;
    }
}

