/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEDialScript
extends LEConfig {
    public static final String EXPECT = "expect";
    public static final String SEND = "send";
    public static final String EXPECT_1 = "expect1";
    public static final String EXPECT_2 = "expect2";
    public static final String EXPECT_3 = "expect3";
    public static final String EXPECT_4 = "expect4";
    public static final String EXPECT_5 = "expect5";
    public static final String EXPECT_6 = "expect6";
    public static final String SEND_1 = "send1";
    public static final String SEND_2 = "send2";
    public static final String SEND_3 = "send3";
    public static final String SEND_4 = "send4";
    public static final String SEND_5 = "send5";
    public static final String SEND_6 = "send6";
    public static final int KEY_COUNT = 12;
    public static final String BLANK = "";
    public static final String RESET = "99";
    static String[] s_keys = null;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[12];
            int i = 0;
            LEDialScript.s_keys[i++] = EXPECT_1;
            LEDialScript.s_keys[i++] = EXPECT_2;
            LEDialScript.s_keys[i++] = EXPECT_3;
            LEDialScript.s_keys[i++] = EXPECT_4;
            LEDialScript.s_keys[i++] = EXPECT_5;
            LEDialScript.s_keys[i++] = EXPECT_6;
            LEDialScript.s_keys[i++] = SEND_1;
            LEDialScript.s_keys[i++] = SEND_2;
            LEDialScript.s_keys[i++] = SEND_3;
            LEDialScript.s_keys[i++] = SEND_4;
            LEDialScript.s_keys[i++] = SEND_5;
            LEDialScript.s_keys[i++] = SEND_6;
        }
        return s_keys;
    }

    public LEDialScript(LEConnectionFacade facade, String tag) {
        super(facade);
        this.m_tag = tag;
    }

    public Object clone() {
        LEDialScript config = new LEDialScript(this.m_facade, this.m_tag);
        config.copy(this);
        return config;
    }

    public static void LoadScript(LEDialScript script, String data) {
        int fs = 1;
        int eol = 2;
        int start = 0;
        int end = 0;
        int len = data.length();
        int i = 0;
        while (i < 6) {
            String key = SEND + (i + 1);
            int ch = 0;
            while (end < len && ch != fs && ch != eol) {
                ch = data.charAt(end++);
            }
            String val = start < len ? data.substring(start, end - 1) : BLANK;
            script.setField(key, val);
            start = end;
            key = EXPECT + (i + 1);
            ch = 0;
            while (end < len && ch != fs && ch != eol) {
                ch = data.charAt(end++);
            }
            val = start < len ? data.substring(start, end - 1) : BLANK;
            script.setField(key, val);
            start = end;
            ++i;
        }
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        StringBuffer buf = new StringBuffer("set ");
        buf.append(this.m_tag);
        buf.append(" ");
        buf.append(RESET);
        cmds.addElement(new String(buf));
        int i = 0;
        while (i < 6) {
            this.makeScriptCommand(cmds, i);
            ++i;
        }
        return true;
    }

    void makeScriptCommand(LEVector cmds, int rule) {
        String[] keys = LEDialScript.GetAllPossibleKeys();
        String send = (String)this.get(keys[rule + 6]);
        String expect = (String)this.get(keys[rule]);
        if (send != null && send.length() > 0 || expect != null && expect.length() > 0) {
            StringBuffer buf = new StringBuffer("set ");
            buf.append(this.m_tag);
            buf.append(" ");
            buf.append(rule + 1);
            buf.append(" \"");
            if (send != null) {
                buf.append(send);
            }
            buf.append("\" \"");
            if (expect != null) {
                buf.append(expect);
            }
            buf.append("\"");
            cmds.addElement(new String(buf));
        }
    }
}

