/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LESA;
import com.lucent.ra.nms.util.LEVector;

public class LEIPSecSA
extends LESA {
    public static final String DESTINATION = "74";
    public static final String ESP_SEC_PROPOSAL = "226";
    public static final String AH_SEC_PROPOSAL = "227";
    public static final String ESP_LOCAL_SPI = "228";
    public static final String AH_LOCAL_SPI = "229";
    public static final String ESP_DEST_SPI = "230";
    public static final String AH_DEST_SPI = "231";
    public static final String ESP_LOCAL_KEY = "232";
    public static final String AH_LOCAL_KEY = "233";
    public static final String ESP_DEST_KEY = "234";
    public static final String AH_DEST_KEY = "235";
    public static final String LOCAL_ADDR = "236";
    public static final String MODE = "289";
    public static final int KEY_COUNT = 12;
    static String[] s_keys = null;
    public static final String DES_PROPOSAL = "esp-des-rfc1827";
    public static final String DES3_PROPOSAL = "esp-3des-rfc1827";
    public static final String MD5_PROPOSAL = "ah-md5-rfc1826";

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[12];
            int i = 0;
            LEIPSecSA.s_keys[i++] = DESTINATION;
            LEIPSecSA.s_keys[i++] = ESP_SEC_PROPOSAL;
            LEIPSecSA.s_keys[i++] = AH_SEC_PROPOSAL;
            LEIPSecSA.s_keys[i++] = ESP_LOCAL_SPI;
            LEIPSecSA.s_keys[i++] = AH_LOCAL_SPI;
            LEIPSecSA.s_keys[i++] = ESP_DEST_SPI;
            LEIPSecSA.s_keys[i++] = AH_DEST_SPI;
            LEIPSecSA.s_keys[i++] = ESP_LOCAL_KEY;
            LEIPSecSA.s_keys[i++] = AH_LOCAL_KEY;
            LEIPSecSA.s_keys[i++] = ESP_DEST_KEY;
            LEIPSecSA.s_keys[i++] = AH_DEST_KEY;
            LEIPSecSA.s_keys[i++] = LOCAL_ADDR;
        }
        return s_keys;
    }

    public LEIPSecSA(LEConnectionFacade facade, String name) {
        super(facade, name);
    }

    public Object clone() {
        LEIPSecSA config = new LEIPSecSA(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String key;
        String spi;
        StringBuffer buf;
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(MODE)) {
            buf = new StringBuffer();
            buf.append("set ");
            buf.append(this.m_tag);
            buf.append(" mode sec-ipip-tunnel");
            cmds.addElement(buf.toString());
        }
        if (allCmds || keys.contains(DESTINATION)) {
            this.makeSetCommand(cmds, this.m_tag, DESTINATION, "peer-identifier");
        }
        if (allCmds || keys.contains(ESP_SEC_PROPOSAL) || keys.contains(AH_SEC_PROPOSAL)) {
            String ah_prop;
            buf = new StringBuffer("set ");
            buf.append(this.m_tag);
            buf.append(" sec-proposal ");
            String esp_prop = (String)this.get(ESP_SEC_PROPOSAL);
            if (esp_prop != null) {
                buf.append(esp_prop);
                buf.append(" ");
            }
            if ((ah_prop = (String)this.get(AH_SEC_PROPOSAL)) != null) {
                buf.append(ah_prop);
                buf.append(" ");
            }
            cmds.add(new String(buf));
        }
        if ((allCmds || keys.contains(ESP_LOCAL_SPI)) && (spi = (String)this.get(ESP_LOCAL_SPI)) != null && !spi.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, ESP_LOCAL_SPI, "esp-inbound-spi");
        }
        if ((allCmds || keys.contains(AH_LOCAL_SPI)) && (spi = (String)this.get(AH_LOCAL_SPI)) != null && !spi.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, AH_LOCAL_SPI, "ah-inbound-spi");
        }
        if ((allCmds || keys.contains(ESP_DEST_SPI)) && (spi = (String)this.get(ESP_DEST_SPI)) != null && !spi.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, ESP_DEST_SPI, "esp-outbound-spi");
        }
        if ((allCmds || keys.contains(AH_DEST_SPI)) && (spi = (String)this.get(AH_DEST_SPI)) != null && !spi.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, AH_DEST_SPI, "ah-outbound-spi");
        }
        if (!allCmds && keys.contains(ESP_LOCAL_KEY) && (key = (String)this.get(ESP_LOCAL_KEY)) != null && !key.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, ESP_LOCAL_KEY, "esp-inbound-key");
        }
        if (!allCmds && keys.contains(AH_LOCAL_KEY) && (key = (String)this.get(AH_LOCAL_KEY)) != null && !key.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, AH_LOCAL_KEY, "ah-inbound-key");
        }
        if (!allCmds && keys.contains(ESP_DEST_KEY) && (key = (String)this.get(ESP_DEST_KEY)) != null && !key.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, ESP_DEST_KEY, "esp-outbound-key");
        }
        if (!allCmds && keys.contains(AH_DEST_KEY) && (key = (String)this.get(AH_DEST_KEY)) != null && !key.equals("")) {
            this.makeSetCommand(cmds, this.m_tag, AH_DEST_KEY, "ah-outbound-key");
        }
        if (allCmds || keys.contains(LOCAL_ADDR)) {
            this.makeSetCommand(cmds, this.m_tag, LOCAL_ADDR, "local-address");
        }
        return cmds.size() > start;
    }
}

