/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LERadius
extends LEConfig {
    public static final String ACCT_SERVER_0 = "210";
    public static final String ACCT_SERVER_1 = "211";
    public static final String ACCT_SERVER_2 = "218";
    public static final String ACCT_PORT_0 = "214";
    public static final String ACCT_PORT_1 = "215";
    public static final String ACCT_PORT_2 = "219";
    public static final String AUTH_SERVER_0 = "208";
    public static final String AUTH_SERVER_1 = "209";
    public static final String AUTH_SERVER_2 = "216";
    public static final String AUTH_PORT_0 = "212";
    public static final String AUTH_PORT_1 = "213";
    public static final String AUTH_PORT_2 = "217";
    public static final String RETRY_COUNT = "12";
    public static final String RETRY_INTERVAL = "278";
    public static final String AUTH_RETRY = "282";
    public static final String AUTH_FAILOVER = "283";
    public static final String SECRET = "secret";
    public static final int KEY_COUNT = 17;
    static String[] s_keys = null;
    boolean m_secretFetched = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[17];
            int i = 0;
            LERadius.s_keys[i++] = ACCT_SERVER_0;
            LERadius.s_keys[i++] = ACCT_SERVER_1;
            LERadius.s_keys[i++] = ACCT_SERVER_2;
            LERadius.s_keys[i++] = ACCT_PORT_0;
            LERadius.s_keys[i++] = ACCT_PORT_1;
            LERadius.s_keys[i++] = ACCT_PORT_2;
            LERadius.s_keys[i++] = AUTH_SERVER_0;
            LERadius.s_keys[i++] = AUTH_SERVER_1;
            LERadius.s_keys[i++] = AUTH_SERVER_2;
            LERadius.s_keys[i++] = AUTH_PORT_0;
            LERadius.s_keys[i++] = AUTH_PORT_1;
            LERadius.s_keys[i++] = AUTH_PORT_2;
            LERadius.s_keys[i++] = SECRET;
            LERadius.s_keys[i++] = RETRY_COUNT;
            LERadius.s_keys[i++] = RETRY_INTERVAL;
            LERadius.s_keys[i++] = AUTH_RETRY;
            LERadius.s_keys[i++] = AUTH_FAILOVER;
        }
        return s_keys;
    }

    public LERadius(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LERadius config = new LERadius(this.m_facade);
        config.copy(this);
        return config;
    }

    void setSecret(String secret) {
        this.m_secretFetched = true;
        this.setField(SECRET, secret);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String auth_port;
        String acc_port;
        StringBuffer cmdbuf;
        String serveraddr;
        boolean allCmds;
        int start = cmds.size();
        boolean bl = allCmds = keys == null;
        if ((allCmds || keys.contains(ACCT_SERVER_0)) && (serveraddr = (String)this.get(ACCT_SERVER_0)) != null && !serveraddr.equals("")) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("accounting ");
            cmdbuf.append(serveraddr);
            acc_port = (String)this.get(ACCT_PORT_0);
            if (acc_port != null && !acc_port.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(acc_port);
            }
            cmds.add(cmdbuf.toString());
        }
        if ((allCmds || keys.contains(ACCT_SERVER_1)) && (serveraddr = (String)this.get(ACCT_SERVER_1)) != null && !serveraddr.equals("")) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("accounting 2 ");
            cmdbuf.append(serveraddr);
            acc_port = (String)this.get(ACCT_PORT_1);
            if (acc_port != null && !acc_port.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(acc_port);
            }
            cmds.add(cmdbuf.toString());
        }
        if ((allCmds || keys.contains(ACCT_SERVER_2)) && (serveraddr = (String)this.get(ACCT_SERVER_2)) != null && !serveraddr.equals("")) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("accounting 3 ");
            cmdbuf.append(serveraddr);
            acc_port = (String)this.get(ACCT_PORT_2);
            if (acc_port != null && !acc_port.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(acc_port);
            }
            cmds.add(cmdbuf.toString());
        }
        if ((allCmds || keys.contains(AUTH_SERVER_0)) && (serveraddr = (String)this.get(AUTH_SERVER_0)) != null && !serveraddr.equals("")) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("authentication_server ");
            cmdbuf.append(serveraddr);
            auth_port = (String)this.get(AUTH_PORT_0);
            if (auth_port != null && !auth_port.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(auth_port);
            }
            cmds.add(cmdbuf.toString());
        }
        if ((allCmds || keys.contains(AUTH_SERVER_1)) && (serveraddr = (String)this.get(AUTH_SERVER_1)) != null && !serveraddr.equals("")) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("alternate_auth_server ");
            cmdbuf.append(serveraddr);
            auth_port = (String)this.get(AUTH_PORT_1);
            if (auth_port != null && !auth_port.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(auth_port);
            }
            cmds.add(cmdbuf.toString());
        }
        if ((allCmds || keys.contains(AUTH_SERVER_2)) && (serveraddr = (String)this.get(AUTH_SERVER_2)) != null && !serveraddr.equals("")) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("authentication 3 ");
            cmdbuf.append(serveraddr);
            auth_port = (String)this.get(AUTH_PORT_2);
            if (auth_port != null && !auth_port.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(auth_port);
            }
            cmds.add(cmdbuf.toString());
        }
        if (allCmds && this.m_secretFetched) {
            this.makeSetCommand(cmds, null, SECRET, SECRET);
        } else if (!allCmds && keys.contains(SECRET)) {
            this.makeSetCommand(cmds, null, SECRET, SECRET);
        }
        if (allCmds || keys.contains(RETRY_COUNT)) {
            this.makeSetCommand(cmds, null, RETRY_COUNT, "accounting count");
        }
        if (allCmds || keys.contains(RETRY_INTERVAL)) {
            this.makeSetCommand(cmds, null, RETRY_INTERVAL, "accounting interval");
        }
        if (allCmds || keys.contains(AUTH_RETRY)) {
            this.makeSetCommand(cmds, null, AUTH_RETRY, "authentication interval");
        }
        if (allCmds || keys.contains(AUTH_FAILOVER)) {
            this.makeSetCommand(cmds, null, AUTH_FAILOVER, "authentication failover");
        }
        return cmds.size() > start;
    }
}

