/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.util.LEResource;
import java.awt.Image;
import java.awt.Toolkit;

public class LELEDs {
    public static int LED_WIDTH = 7;
    public static int LED_HEIGHT = 7;
    public static int BLACK;
    public static int BLUE;
    public static int GRAY;
    public static int GREEN;
    public static int RED;
    public static int YELLOW;
    public static int SQBLACK;
    public static int SQBLUE;
    public static int SQGRAY;
    public static int SQGREEN;
    public static int SQRED;
    public static int SQYELLOW;
    public static int OVAL_GRAY;
    public static int OVAL_GREEN;
    public static int OVAL_YELLOW;
    public static int OVAL_RED;
    public static int VSQ_GRAY;
    public static int VSQ_YELLOW;
    public static int VSQ_BLACK;
    static int SQ_OFFSET;
    static int OVAL_OFFSET;
    static int VSQ_OFFSET;
    static Image[] s_ovalLEDs;
    static Image[] s_smallLEDs;
    static Image[] s_sqLEDs;
    static Image[] s_vsqLEDs;

    static Image[] MakeSmallLEDs() {
        Image[] imageArray = new Image[6];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        imageArray[0] = LEResource.GetImage("led-black.gif");
        imageArray[1] = LEResource.GetImage("led-blue.gif");
        imageArray[2] = LEResource.GetImage("led-gray.gif");
        imageArray[3] = LEResource.GetImage("led-green.gif");
        imageArray[4] = LEResource.GetImage("led-red.gif");
        imageArray[5] = LEResource.GetImage("led-yellow.gif");
        toolkit.prepareImage(imageArray[0], -1, -1, null);
        toolkit.prepareImage(imageArray[1], -1, -1, null);
        toolkit.prepareImage(imageArray[2], -1, -1, null);
        toolkit.prepareImage(imageArray[3], -1, -1, null);
        toolkit.prepareImage(imageArray[4], -1, -1, null);
        toolkit.prepareImage(imageArray[5], -1, -1, null);
        return imageArray;
    }

    static Image[] MakeSquareLEDs() {
        Image[] imageArray = new Image[6];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        imageArray[0] = LEResource.GetImage("sq-led-black.gif");
        imageArray[1] = LEResource.GetImage("sq-led-blue.gif");
        imageArray[2] = LEResource.GetImage("sq-led-gray.gif");
        imageArray[3] = LEResource.GetImage("sq-led-green.gif");
        imageArray[4] = LEResource.GetImage("sq-led-red.gif");
        imageArray[5] = LEResource.GetImage("sq-led-yellow.gif");
        toolkit.prepareImage(imageArray[0], -1, -1, null);
        toolkit.prepareImage(imageArray[1], -1, -1, null);
        toolkit.prepareImage(imageArray[2], -1, -1, null);
        toolkit.prepareImage(imageArray[3], -1, -1, null);
        toolkit.prepareImage(imageArray[4], -1, -1, null);
        toolkit.prepareImage(imageArray[5], -1, -1, null);
        return imageArray;
    }

    static Image[] MakeOvalLEDs() {
        Image[] imageArray = new Image[4];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        imageArray[0] = LEResource.GetImage("led-oval-gray.gif");
        imageArray[1] = LEResource.GetImage("led-oval-green.gif");
        imageArray[2] = LEResource.GetImage("led-oval-yellow.gif");
        imageArray[3] = LEResource.GetImage("led-oval-red.gif");
        toolkit.prepareImage(imageArray[0], -1, -1, null);
        toolkit.prepareImage(imageArray[1], -1, -1, null);
        toolkit.prepareImage(imageArray[2], -1, -1, null);
        toolkit.prepareImage(imageArray[3], -1, -1, null);
        return imageArray;
    }

    static Image[] MakeVSquareLEDs() {
        Image[] imageArray = new Image[3];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        imageArray[0] = LEResource.GetImage("led-vsq-gray.gif");
        imageArray[1] = LEResource.GetImage("led-vsq-yellow.gif");
        imageArray[2] = LEResource.GetImage("led-vsq-black.gif");
        toolkit.prepareImage(imageArray[0], -1, -1, null);
        toolkit.prepareImage(imageArray[1], -1, -1, null);
        toolkit.prepareImage(imageArray[2], -1, -1, null);
        return imageArray;
    }

    public static void Initialize() {
        if (s_smallLEDs == null) {
            s_smallLEDs = LELEDs.MakeSmallLEDs();
        }
        if (s_sqLEDs == null) {
            s_sqLEDs = LELEDs.MakeSquareLEDs();
        }
        if (s_ovalLEDs == null) {
            s_ovalLEDs = LELEDs.MakeOvalLEDs();
        }
        if (s_vsqLEDs == null) {
            s_vsqLEDs = LELEDs.MakeVSquareLEDs();
        }
    }

    public static Image GetLED(int n) {
        if (n >= BLACK && n <= YELLOW) {
            return s_smallLEDs[n];
        }
        if (n >= SQBLACK && n <= SQYELLOW) {
            return s_sqLEDs[n - SQ_OFFSET];
        }
        if (n >= OVAL_GRAY && n <= OVAL_RED) {
            return s_ovalLEDs[n - OVAL_OFFSET];
        }
        if (n >= VSQ_GRAY && n <= VSQ_YELLOW) {
            return s_vsqLEDs[n - VSQ_OFFSET];
        }
        return null;
    }

    static {
        BLUE = 1;
        GRAY = 2;
        GREEN = 3;
        RED = 4;
        YELLOW = 5;
        SQBLACK = 10;
        SQBLUE = 11;
        SQGRAY = 12;
        SQGREEN = 13;
        SQRED = 14;
        SQYELLOW = 15;
        OVAL_GRAY = 20;
        OVAL_GREEN = 21;
        OVAL_YELLOW = 22;
        OVAL_RED = 23;
        VSQ_GRAY = 30;
        VSQ_YELLOW = 31;
        VSQ_BLACK = 32;
        SQ_OFFSET = 10;
        OVAL_OFFSET = 20;
        VSQ_OFFSET = 30;
        s_ovalLEDs = null;
        s_smallLEDs = null;
        s_sqLEDs = null;
        s_vsqLEDs = null;
    }
}

