/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Image;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeExplicitParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSimpleChild;

public class DTreeSimpleParent
extends DTreeSimpleChild
implements DTreeExplicitParent {
    private DTreeItem[] _children;
    private int _nchildren;
    private int _subheight;
    private boolean _expanded;

    public DTreeSimpleParent(String string, Image image) {
        super(string, image);
    }

    public final void addItem(DTreeItem dTreeItem) {
        this.addItem(dTreeItem, -1);
    }

    public final void addItem(DTreeItem dTreeItem, int n) {
        DTreeItem[] dTreeItemArray = new DTreeItem[]{dTreeItem};
        this.addItems(dTreeItemArray, n);
    }

    public void addItems(DTreeItem[] dTreeItemArray, int n) {
        int n2 = dTreeItemArray.length;
        if (n2 <= 0) {
            return;
        }
        int n3 = this.getItemCount();
        if (n < 0 || n > n3) {
            n = n3;
        }
        if (this._children == null) {
            this._children = new DTreeItem[n2];
        } else if (this._children.length < n2 + n3) {
            DTreeItem[] dTreeItemArray2 = new DTreeItem[n2 + n3];
            System.arraycopy(this._children, 0, dTreeItemArray2, 0, n);
            System.arraycopy(this._children, n, dTreeItemArray2, n + n2, n3 - n);
            this._children = dTreeItemArray2;
        } else {
            System.arraycopy(this._children, n, this._children, n + n2, n3 - n);
        }
        System.arraycopy(dTreeItemArray, 0, this._children, n, n2);
        this._nchildren = n3 + n2;
        int n4 = n;
        while (n4 < n + n2) {
            this._children[n4].itemAdded(this, n4);
            ++n4;
        }
        while (n4 < this._nchildren) {
            this._children[n4].setIndex(n4);
            ++n4;
        }
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.itemsAdded(this, n, n2);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DTreeSimpleParent dTreeSimpleParent = (DTreeSimpleParent)super.clone();
        dTreeSimpleParent._nchildren = 0;
        dTreeSimpleParent.itemRemoved();
        DTreeItem[] dTreeItemArray = new DTreeItem[this._nchildren];
        int n = 0;
        while (n < this._nchildren) {
            DTreeItem dTreeItem;
            dTreeItemArray[n] = dTreeItem = (DTreeItem)this._children[n].clone();
            dTreeItem.itemAdded(dTreeSimpleParent, dTreeItem.getIndex());
            ++n;
        }
        dTreeSimpleParent._children = dTreeItemArray;
        dTreeSimpleParent._nchildren = dTreeItemArray.length;
        return dTreeSimpleParent;
    }

    public DTreeItem getItem(int n) {
        if (n >= this._nchildren) {
            return null;
        }
        return this._children[n];
    }

    public DTreeItem getItemAt(int n, int n2) {
        int n3 = this.getSubTreeHeight();
        if (n2 > n3) {
            return null;
        }
        int n4 = this.getHeight();
        if (n2 < n4) {
            return this;
        }
        if (this.isExpanded() && this._nchildren > 0) {
            int n5 = 0;
            int n6 = this.getY();
            while (n5 < this._nchildren) {
                DTreeItem dTreeItem = this.getItem(n5);
                int n7 = dTreeItem.getY() - n6;
                if (n2 >= n7 && n2 < n7 + dTreeItem.getSubTreeHeight()) {
                    return dTreeItem.getItemAt(n, n2 - n7);
                }
                if (n2 < n7) {
                    return null;
                }
                ++n5;
            }
        }
        return null;
    }

    public int getItemCount() {
        return this._nchildren;
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        int n = dTreeItem == null ? 0 : dTreeItem.getIndex() + 1;
        while (n < this._nchildren) {
            DTreeItem dTreeItem2 = this._children[n];
            if (dTreeItem2.isExpanded()) {
                return dTreeItem2;
            }
            ++n;
        }
        return null;
    }

    public int getSubTreeHeight() {
        return this._subheight;
    }

    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void layout(int n, int n2) {
        super.layout(n, n2);
        int n3 = this.getHeight();
        if (this._expanded && this._nchildren != 0) {
            DTreeItem dTreeItem = this.getParent();
            DTree dTree = this.getTree();
            int n4 = 0;
            if (dTreeItem != null) {
                dTree.getIndentWidth();
            }
            int n5 = n;
            int n6 = n2 + this.getChildrenYOffset(n3);
            if (this != dTree.getRoot()) {
                n5 += this.getChildrenXOffset(dTree.getIndentWidth());
            }
            while (n4 < this._nchildren) {
                DTreeItem dTreeItem2 = this.getItem(n4);
                dTreeItem2.layout(n5, n6);
                n6 += dTreeItem2.getSubTreeHeight();
                ++n4;
            }
            n3 = n6 - n2;
        }
        this._subheight = n3;
    }

    public void removeItems(int n, int n2) {
        Object object;
        if (n2 == 0) {
            return;
        }
        int n3 = n;
        while (n3 < n + n2) {
            object = this._children[n3];
            object.itemRemoved();
            ++n3;
        }
        System.arraycopy(this._children, n + n2, this._children, n, this._nchildren - (n + n2));
        this._nchildren -= n2;
        n3 = n;
        while (n3 < this._nchildren) {
            this._children[n3].setIndex(n3);
            ++n3;
        }
        object = this.getTree();
        ((DTree)object).itemsRemoved(this, n, n2);
    }

    public void setExpanded(boolean bl) {
        if (bl == this.isExpanded()) {
            return;
        }
        DTree dTree = this.getTree();
        if (dTree == null) {
            this._expanded = bl;
            return;
        }
        if (!dTree.itemExpansionChanging(this, bl)) {
            this._expanded = bl;
            dTree.itemExpansionChanged(this, bl);
        }
    }

    protected int getChildrenXOffset(int n) {
        return n;
    }

    protected int getChildrenYOffset(int n) {
        return n;
    }

    protected void setSubTreeHeight(int n) {
        this._subheight = n;
    }
}

