/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Color;
import java.awt.Graphics;
import oracle.ewt.graphics.ColorUtils;

public class GraphicUtils {
    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        if (n != n3 && n2 != n4) {
            return;
        }
        if (n5 == 0 || n5 == 1) {
            graphics.drawLine(n, n2, n3, n4);
            return;
        }
        if (n == n3) {
            n9 = n - n5 / 2;
            n8 = n5;
            if (n2 < n4) {
                n7 = n2;
                n6 = n4 - n2 + 1;
            } else {
                n7 = n4;
                n6 = n2 - n4 + 1;
            }
        } else {
            n7 = n2 - n5 / 2;
            n6 = n5;
            if (n < n3) {
                n9 = n;
                n8 = n3 - n + 1;
            } else {
                n9 = n3;
                n8 = n - n3 + 1;
            }
        }
        graphics.fillRect(n9, n7, n8, n6);
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n5 == 0 || n5 == 1) {
            graphics.drawRect(n, n2, n3, n4);
            return;
        }
        int n7 = n5 / 2;
        int n8 = n - n7;
        int n9 = n8 + n3 + n5 - 1;
        int n10 = n6 = n2;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n10 = n6 = n2 + n4;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n10 = n2 + n7;
        n6 = n2 + n4 - n7 - 1;
        n8 = n9 = n;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n8 = n9 = n + n3;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
    }

    public static void drawPlainFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 / 2;
        GraphicUtils.drawRect(graphics, n + n6, n2 + n6, n3 - n5, n4 - n5, n5);
    }

    public static void drawInsetFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        Color color2 = ColorUtils.lighterShadeColor(color);
        Color color3 = ColorUtils.darkerShadeColor(color);
        GraphicUtils._drawInsetOutsetFrame(graphics, n, n2, n3, n4, n5, color3, color2);
    }

    public static void drawOutsetFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        Color color2 = ColorUtils.lighterShadeColor(color);
        Color color3 = ColorUtils.darkerShadeColor(color);
        GraphicUtils._drawInsetOutsetFrame(graphics, n, n2, n3, n4, n5, color2, color3);
    }

    public static void drawRaisedFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        Color color2 = ColorUtils.lighterShadeColor(color);
        Color color3 = ColorUtils.darkerShadeColor(color);
        GraphicUtils._drawRaisedLoweredFrame(graphics, n, n2, n3, n4, n5, color2, color3);
    }

    public static void drawLoweredFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        Color color2 = ColorUtils.lighterShadeColor(color);
        Color color3 = ColorUtils.darkerShadeColor(color);
        GraphicUtils._drawRaisedLoweredFrame(graphics, n, n2, n3, n4, n5, color3, color2);
    }

    public static void drawPlainSeparator(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n != n3 && n2 != n4) {
            return;
        }
        GraphicUtils.drawLine(graphics, n, n2, n3, n4, n5);
    }

    public static void drawInsetSeparator(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n != n3 && n2 != n4) {
            return;
        }
        Color color = graphics.getColor();
        Color color2 = ColorUtils.lighterShadeColor(color);
        Color color3 = ColorUtils.darkerShadeColor(color);
        GraphicUtils._drawInsetOutsetSeparator(graphics, n, n2, n3, n4, n5, color3, color2);
        graphics.setColor(color);
    }

    public static void drawOutsetSeparator(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n != n3 && n2 != n4) {
            return;
        }
        Color color = graphics.getColor();
        Color color2 = ColorUtils.lighterShadeColor(color);
        Color color3 = ColorUtils.darkerShadeColor(color);
        GraphicUtils._drawInsetOutsetSeparator(graphics, n, n2, n3, n4, n5, color2, color3);
        graphics.setColor(color);
    }

    static void drawDottedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n == n3) {
            if (n2 > n4) {
                int n5 = n4;
                n4 = n2;
                n2 = n5;
            }
            while (n2 <= n4) {
                graphics.drawLine(n, n2, n, n2);
                n2 += 2;
            }
            return;
        }
        if (n2 != n4) {
            throw new IllegalArgumentException("Only horizontal and vertical lines");
        }
        if (n > n3) {
            int n6 = n3;
            n3 = n;
            n = n6;
        }
        while (n <= n3) {
            graphics.drawLine(n, n2, n, n2);
            n += 2;
        }
    }

    static void drawDottedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        GraphicUtils.drawDottedLine(graphics, n, n2, n5, n2);
        GraphicUtils.drawDottedLine(graphics, n5, n2, n5, n6);
        GraphicUtils.drawDottedLine(graphics, n, n6, n5, n6);
        GraphicUtils.drawDottedLine(graphics, n, n2, n, n6);
    }

    public static void drawFocusRect(Graphics graphics, int n, int n2, int n3, int n4) {
        GraphicUtils.drawDottedRect(graphics, n, n2, n3, n4);
    }

    public static void drawDisabledString(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(Color.white);
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.setColor(ColorUtils.shadeColor(color, 102));
        graphics.drawString(string, n, n2);
        graphics.setColor(color);
    }

    private static void _drawInsetOutsetFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        if (n5 == 1) {
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            return;
        }
        if (n5 == 2) {
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 2, n4 - 2);
            graphics.setColor(color2);
            graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
            return;
        }
        int n6 = n5 / 2;
        int n7 = n5 % 2 == 0 ? 0 : 1;
        GraphicUtils._drawRaisedLoweredFrame(graphics, n, n2, n3, n4, n6 + n7, color, color2);
        GraphicUtils._drawRaisedLoweredFrame(graphics, n + n6 + n7, n2 + n6 + n7, n3 - n5 - n7, n4 - n5 - n7, n6, color2, color);
    }

    private static void _drawRaisedLoweredFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        int n6 = Math.min(n5, n3 / 2);
        int n7 = Math.min(n5, n4 / 2);
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        graphics.setColor(color);
        nArray[0] = n;
        nArray[1] = n + n3;
        nArray[2] = nArray[1] - n7;
        nArray[3] = n + n7;
        nArray[4] = n;
        nArray2[0] = n2;
        nArray2[1] = n2;
        nArray2[2] = n2 + n7;
        nArray2[3] = nArray2[2];
        nArray2[4] = n2;
        graphics.fillPolygon(nArray, nArray2, 5);
        nArray[0] = n;
        nArray[1] = n;
        nArray[2] = n + n6;
        nArray[3] = nArray[2];
        nArray[4] = n;
        nArray2[0] = n2;
        nArray2[1] = n2 + n4;
        nArray2[2] = nArray2[1] - n6;
        nArray2[3] = n2 + n6;
        nArray2[4] = n2;
        graphics.fillPolygon(nArray, nArray2, 5);
        graphics.setColor(color2);
        nArray[0] = n;
        nArray[1] = n + n3;
        nArray[2] = nArray[1] - n7;
        nArray[3] = n + n7;
        nArray[4] = n;
        nArray2[0] = n2 + n4;
        nArray2[1] = nArray2[0];
        nArray2[2] = nArray2[0] - n7;
        nArray2[3] = nArray2[2];
        nArray2[4] = nArray2[0];
        graphics.fillPolygon(nArray, nArray2, 5);
        nArray[0] = n + n3;
        nArray[1] = nArray[0];
        nArray[2] = nArray[0] - n6;
        nArray[3] = nArray[2];
        nArray[4] = nArray[0];
        nArray2[0] = n2;
        nArray2[1] = n2 + n4;
        nArray2[2] = nArray2[1] - n6;
        nArray2[3] = n2 + n6;
        nArray2[4] = n2;
        graphics.fillPolygon(nArray, nArray2, 5);
    }

    private static void _drawInsetOutsetSeparator(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        int n6 = n5 / 2;
        graphics.setColor(color);
        if (n == n3) {
            graphics.drawLine(n - n6, n2, n - n6, n4);
        } else {
            graphics.drawLine(n, n2 - n6, n3, n4 - n6);
        }
        if (n5 > 1) {
            int n7;
            graphics.setColor(color2);
            int n8 = n7 = n5 % 2 == 0 ? 0 : 1;
            if (n == n3) {
                GraphicUtils.drawLine(graphics, n + n7, n2, n + n7, n4, n5 - 1);
                return;
            }
            GraphicUtils.drawLine(graphics, n, n2 + n7, n3, n2 + n7, n5 - 1);
        }
    }

    public static void synchronizeGraphics(Graphics graphics, Graphics graphics2) {
        graphics.setFont(graphics2.getFont());
        graphics.setColor(graphics2.getColor());
        graphics.setClip(graphics2.getClip());
    }
}

