/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.backend.LEDebugMessage;
import COM.livingston.util.LEDebug;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class LEPPPDebugMessage
extends LEDebugMessage {
    private String m_type;
    private String m_value;
    private String m_hexdata;
    private String m_portNumber;
    private static String s_prevPortNumber;
    public static final String START_PAP = "START_PAP";
    public static final String START_CHAP = "START_CHAP";
    public static final String START_LCP = "START_LCP";
    public static final String START_IPCP = "START_IPCP";
    public static final String START_IPXCP = "START_IPXCP";
    public static final String START_CCP = "START_CCP";
    public static final String MISC = "MISC";
    public static final String TYPE_LCP = "LCP";
    public static final String TYPE_PAP = "PAP_";
    public static final String TYPE_CHAP = "CHAP_";
    public static final String TYPE_IPCP = "IPCP";
    public static final String TYPE_IPXCP = "IPXCP_";
    public static final String TYPE_CCP = "CCP";
    public static final String TYPE_MISC = "MISC";
    public static final String BLANK = "";
    public static final int MAX_PROTOCOL = 208;
    public static final String[] PROTOCOL_LIST;

    public LEPPPDebugMessage(int request, long timestamp, String data) {
        super(request, timestamp, data);
        this.determineAndSetType(data);
        this.setPortNum(this.m_value);
    }

    public LEPPPDebugMessage(LEDebugMessage msg) {
        super(msg.getRequestID(), msg.getTimestamp(), msg.getData());
        this.determineAndSetType(msg.getData());
        this.setPortNum(this.m_value);
    }

    void setType(String type) {
        this.m_type = type;
    }

    public String getType() {
        return this.m_type;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getPortNum() {
        return this.m_portNumber;
    }

    void setValue(String value) {
        this.m_value = value;
    }

    public boolean setHexData(String hexdata) {
        if (this.m_type != null) {
            this.m_hexdata = hexdata;
            return true;
        }
        return false;
    }

    public String getHexData() {
        return this.m_hexdata;
    }

    public String toString() {
        return "LEPPPDebugMessage contains \nType:" + this.m_type + "\nValue:" + this.m_value + "\nHex:" + this.m_hexdata;
    }

    void setPortNum(String str) {
        this.m_portNumber = s_prevPortNumber;
        int i = str.indexOf("port");
        try {
            if (i == -1) {
                if (str.charAt(0) == 'S' || str.charAt(0) == 'W' || str.charAt(0) == 'C') {
                    this.m_portNumber = str.charAt(2) == ':' ? str.substring(0, 2) : (str.charAt(3) == ':' ? str.substring(0, 3) : s_prevPortNumber);
                }
            } else {
                String newstr = str.substring(i + 5);
                this.m_portNumber = newstr.charAt(2) == ' ' ? newstr.substring(0, 2) : newstr.substring(0, 3);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            LEDebug.getLog().logln(20, e);
        }
        catch (NumberFormatException e) {
            this.m_portNumber = new String("-1");
            LEDebug.getLog().logln(20, e);
        }
        s_prevPortNumber = this.m_portNumber;
    }

    void determineAndSetType(String stringtoprocess) {
        block6: {
            int tempint = stringtoprocess.indexOf(":");
            if (tempint != -1) {
                StreamTokenizer strtok = new StreamTokenizer(new StringReader(stringtoprocess.substring(tempint + 1)));
                try {
                    if (strtok.nextToken() == -2) {
                        this.m_value = stringtoprocess.substring(0, tempint);
                        this.m_hexdata = stringtoprocess.substring(tempint + 1);
                        break block6;
                    }
                    this.m_value = stringtoprocess;
                    this.m_hexdata = null;
                }
                catch (IOException e) {
                    LEDebug.getLog().logln(20, e);
                }
                catch (Exception e) {
                    LEDebug.getLog().logln(20, e);
                }
            } else {
                this.m_value = stringtoprocess;
            }
        }
        this.m_type = stringtoprocess.indexOf(TYPE_LCP) != -1 ? TYPE_LCP : (stringtoprocess.indexOf(TYPE_PAP) != -1 ? TYPE_PAP : (stringtoprocess.indexOf(TYPE_CHAP) != -1 ? TYPE_CHAP : (stringtoprocess.indexOf(TYPE_IPCP) != -1 ? TYPE_IPCP : (stringtoprocess.indexOf(TYPE_IPXCP) != -1 ? TYPE_IPXCP : (stringtoprocess.indexOf(TYPE_CCP) != -1 ? TYPE_CCP : (stringtoprocess.indexOf(TYPE_PAP) != -1 ? TYPE_PAP : "MISC"))))));
    }

    static {
        PROTOCOL_LIST = new String[]{"0001", "Padding Protocol", "0021", "Internet Protocol version 4", "0023", "OSI Network Layer", "0025", "Xerox NS IDP", "0027", "DECnet Phase IV", "0029", "Appletalk", "002B", "Novell IPX", "002D", "Van Jacobson Compressed TCP/IP", "002F", "Van Jacobson Uncompressed TCP/IP", "0031", "Bridging PDU", "0033", "Stream Protocol (ST-II)", "0035", "Banyan Vines", "0037", "reserved (until 1993)", "0039", "AppleTalk EDDP", "003B", "AppleTalk SmartBuffered", "003D", "Multi-Link", "003F", "NETBIOS Framing", "0041", "Cisco Systems", "0043", "Ascom Timeplex", "0045", "Fujitsu Link Backup and Load Balancing (LBLB)", "0047", "DCA Remote Lan", "0049", "Serial Data Transport Protocol (PPP-SDTP)", "004B", "SNA over 802.2", "004D", "SNA", "004F", "IP6 Header Compression", "0051", "KNX Bridging Data", "0053", "Encryption", "0055", "Individual Link Encryption", "0057", "Internet Protocol version 6", "006F", "Stampede Bridging", "0071", "BAP Bandwidth Allocation Protocol", "0073", "MP+ Protocol", "007D", "reserved (Control Escape)", "007F", "reserved (compression inefficient)", "00C1", "NTCITS IPI", "00CF", "reserved (PPP NLPID)", "00FB", "single link compression in multilink", "00FD", "compressed datagram", "00FF", "reserved (compression inefficient)", "0201", "802.1d Hello Packets", "0203", "IBM Source Routing BPDU", "0205", "DEC LANBridge100 Spanning Tree", "0207", "Cisco Discovery Protocol", "0209", "Netcs Twin Routing", "0231", "Luxcom", "0233", "Sigma Network Systems", "0235", "Apple Client Server Protocol", "4001", "Cray Communications Control Protocol", "4003", "CDPD Mobile Network Registration Protocol", "4021", "Stacker LZS", "8021", "Internet Protocol Control Protocol", "8023", "OSI Network Layer Control Protocol", "8025", "Xerox NS IDP Control Protocol", "8027", "DECnet Phase IV Control Protocol", "8029", "Appletalk Control Protocol", "802B", "Novell IPX Control Protocol", "802D", "reserved", "802F", "reserved", "8031", "Bridging NCP", "8033", "Stream Protocol Control Protocol", "8035", "Banyan Vines Control Protocol", "8037", "reserved till 1993", "8039", "reserved", "803B", "reserved", "803D", "Multi-Link Control Protocol", "803F", "NETBIOS Framing Control Protocol", "8041", "Cisco Systems Control Protocol", "8043", "Ascom Timeplex", "8045", "Fujitsu LBLB Control Protocol", "8047", "DCA Remote Lan Network Control Protocol (RLNCP)", "8049", "Serial Data Control Protocol (PPP-SDCP)", "804B", "SNA over 802.2 Control Protocol", "804D", "SNA Control Protocol", "804F", "IP6 Header Compression Control Protocol", "8051", "KNX Bridging Control Protocol", "8053", "Encryption Control Protocol", "8055", "Individual Link Encryption Control Protocol", "8057", "IPv6 Control Protocol", "806F", "Stampede Bridging Control Protocol", "8073", "MP+ Control Protocol", "8071", "BACP Bandwidth Allocation Control Protocol", "807d", "Not Used - reserved", "80C1", "NTCITS IPI Control Protocol", "80CF", "Not Used - reserved", "80FB", "single link compression in multilink control", "80FD", "Compression Control Protocol", "80FF", "NotUsed - reserved", "8207", "Cisco Discovery Protocol Control", "8209", "Netcs Twin Routing", "8235", "Apple Client Server Protocol Control", "C021", "Link Control Protocol", "C023", "Password Authentication Protocol", "C025", "Link Quality Report", "C027", "Shiva Password Authentication Protocol", "C029", "CallBack Control Protocol (CBCP)", "C081", "Container Control Protocol", "C223", "Challenge Handshake Authentication Protocol", "C225", "RSA Authentication Protocol", "C227", "Extensible Authentication Protocol", "C229", "Mitsubishi Security Info Exch Ptcl (SIEP)", "C26F", "Stampede Bridging Authorization Protocol", "C281", "Proprietary Authentication Protocol", "C283", "Proprietary Authentication Protocol", "C481", "Proprietary Node ID Authentication Protocol"};
    }
}

