/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LETriStateBox;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemListener;

public class LEModemsPanel
extends Panel
implements LEObserver {
    LEPortMaster m_pm;
    LEConfig m_config;
    Checkbox[] m_cards = new Checkbox[6];
    LETriStateBox[] m_modems = new LETriStateBox[60];
    ItemListener m_listener;

    public LEModemsPanel(LEPortMaster lEPortMaster, LEVector lEVector, ItemListener itemListener) {
        this.setLayout(new GridLayout(6, 1, 5, 5));
        this.m_listener = itemListener;
        this.m_pm = lEPortMaster;
        this.m_config = lEPortMaster;
        int n = lEVector.size();
        int n2 = 0;
        while (this.m_config != null && n2 < n) {
            Object object = this.m_config.get((String)lEVector.elementAt(n2));
            this.m_config = object instanceof LEConfig ? (LEConfig)object : null;
            ++n2;
        }
        if (this.m_config != null) {
            this.buildMainPanel();
            this.m_config.addObserver(this);
        }
    }

    public LEPortMaster getPortMaster() {
        return this.m_pm;
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof String) {
            this.setModemState((String)object);
        }
    }

    public void gone() {
        if (this.m_config != null) {
            this.m_config.deleteObserver(this);
        }
    }

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        int n = 0;
        while (n < this.m_cards.length) {
            if (this.m_cards[n] != null) {
                this.m_cards[n].setCheckboxGroup(checkboxGroup);
            }
            ++n;
        }
    }

    public void busyAllModems() {
        int n = 0;
        while (n < 6) {
            if (this.m_cards[n] != null && this.m_cards[n].getState()) {
                int n2 = 0;
                while (n2 < 10) {
                    int n3 = n * 10 + n2;
                    if (this.m_modems[n3] != null && this.m_modems[n3].isEnabled() && (this.m_modems[n3].getState() == 2 || this.m_modems[n3].getState() == 1)) {
                        this.m_modems[n3].setState(0);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void enableAllModems() {
        int n = 0;
        while (n < 6) {
            if (this.m_cards[n] != null && this.m_cards[n].getState()) {
                int n2 = 0;
                while (n2 < 10) {
                    int n3 = n * 10 + n2;
                    if (this.m_modems[n3] != null && this.m_modems[n3].isEnabled() && (this.m_modems[n3].getState() == 0 || this.m_modems[n3].getState() == 1)) {
                        this.m_modems[n3].setState(2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void lastCallAllModems() {
        int n = 0;
        while (n < 6) {
            if (this.m_cards[n] != null && this.m_cards[n].getState()) {
                int n2 = 0;
                while (n2 < 10) {
                    int n3 = n * 10 + n2;
                    if (this.m_modems[n3] != null && this.m_modems[n3].isEnabled() && (this.m_modems[n3].getState() == 2 || this.m_modems[n3].getState() == 0)) {
                        this.m_modems[n3].setState(1);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public Checkbox getFirstSlot() {
        Checkbox checkbox = null;
        int n = 0;
        while (checkbox == null && n < this.m_cards.length) {
            checkbox = this.m_cards[n];
            ++n;
        }
        return checkbox;
    }

    public void refresh() {
        if (this.m_config != null) {
            this.m_config.refresh();
        }
    }

    public void save() {
        if (this.m_config == null) {
            return;
        }
        int n = 0;
        while (n < this.m_modems.length) {
            String string;
            String string2;
            if (this.m_modems[n] != null && this.m_modems[n].isEnabled() && (string2 = (String)this.m_config.get(string = this.m_modems[n].getLabel())) != null) {
                if (this.m_modems[n].getState() == 2) {
                    if (string2.equals("ADMIN") || string2.equals("ACT(LC)")) {
                        this.m_config.set(string, "READY");
                    }
                } else if (this.m_modems[n].getState() == 1) {
                    if (!string2.equals("ACT(LC)")) {
                        this.m_config.set(string, "ACT(LC)");
                    }
                } else if (!string2.equals("ADMIN")) {
                    this.m_config.set(string, "ADMIN");
                }
            }
            ++n;
        }
        LEVector lEVector = this.m_config.saveChanges();
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.getFrame(this), this.m_pm, lEVector);
            this.refresh();
        }
    }

    void buildMainPanel() {
        int n = 0;
        while (n < 6) {
            this.add(this.buildModemCard(n));
            ++n;
        }
    }

    Panel buildModemCard(int n) {
        String string;
        LEBorderPanel lEBorderPanel = new LEBorderPanel(3);
        lEBorderPanel.setLayout(new BorderLayout(0, 0));
        this.m_cards[n] = new Checkbox("Slot " + n);
        this.m_cards[n].setFont(LEFont.getBoldFont());
        this.m_cards[n].addItemListener(this.m_listener);
        lEBorderPanel.add("North", this.m_cards[n]);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 5, 10, 3));
        int n2 = n * 10;
        LEVector lEVector = new LEVector(3);
        lEVector.addElement("Available");
        lEVector.addElement("Last Call");
        lEVector.addElement("Busy");
        int n3 = 0;
        while (n3 < 10) {
            string = "M" + (n2 + n3);
            this.m_modems[n2 + n3] = new LETriStateBox(string);
            this.m_modems[n2 + n3].setHelp(lEVector);
            panel.add(this.m_modems[n2 + n3]);
            this.setModemState(string);
            n3 += 2;
        }
        int n4 = 1;
        while (n4 < 10) {
            string = "M" + (n2 + n4);
            this.m_modems[n2 + n4] = new LETriStateBox(string);
            this.m_modems[n2 + n4].setHelp(lEVector);
            panel.add(this.m_modems[n2 + n4]);
            this.setModemState(string);
            n4 += 2;
        }
        lEBorderPanel.add("Center", panel);
        return lEBorderPanel;
    }

    void setModemState(String string) {
        try {
            String string2 = (String)this.m_config.get(string);
            int n = Integer.parseInt(string.substring(1));
            if (this.m_modems[n] == null) {
                return;
            }
            if (string2 != null) {
                if (string2.equals("ADMIN")) {
                    this.m_modems[n].setEnabled(true);
                    this.m_modems[n].setState(0);
                    return;
                }
                if (string2.equals("DOWN")) {
                    this.m_modems[n].setState(0);
                    this.m_modems[n].setEnabled(false);
                    return;
                }
                if (string2.equals("ACT(LC)")) {
                    this.m_modems[n].setEnabled(true);
                    this.m_modems[n].setState(1);
                    return;
                }
                this.m_modems[n].setEnabled(true);
                this.m_modems[n].setState(2);
                return;
            }
            this.m_modems[n].setState(0);
            this.m_modems[n].setEnabled(false);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

