/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LENetworkRanges;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LENetworkRangesForm
extends LETableForm {
    public void add() {
        LEVector lEVector = new LEVector();
        if (this.m_pms.length > 1) {
            this.determinePMs(lEVector);
        } else {
            lEVector.addElement(this.m_pms[0]);
        }
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster = (LEPortMaster)lEVector.elementAt(n2);
            LETable lETable = this.getTable(lEPortMaster);
            if (lETable instanceof LENetworkRanges) {
                this.add(lEPortMaster, (LENetworkRanges)lETable);
            }
            ++n2;
        }
        this.layoutGrid();
    }

    void determinePMs(LEVector lEVector) {
        Component[][] componentArray = new Component[this.m_pms.length][2];
        componentArray[0][0] = new Label("Add Network Range to:", 0);
        componentArray[0][0].setFont(LEFont.getBoldFont());
        int n = 0;
        while (n < this.m_pms.length) {
            componentArray[n][1] = new Checkbox(this.m_pms[n].getHostname(), true, null);
            ++n;
        }
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Network Range", new LECompGrid(componentArray, 2, false));
        if (lEAddDialog.okay()) {
            int n2 = 0;
            while (n2 < this.m_pms.length) {
                if (((Checkbox)componentArray[n2][1]).getState()) {
                    lEVector.addElement(this.m_pms[n2]);
                }
                ++n2;
            }
        }
    }

    void add(LEPortMaster lEPortMaster, LENetworkRanges lENetworkRanges) {
        if (lENetworkRanges.size() == 8) {
            new LEErrorDialog(LEUiUtils.getFrame(this), String.valueOf(lEPortMaster.getHostname()) + " already has 8 network ranges for this area");
            return;
        }
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("Add Network Range to " + lEPortMaster.getHostname(), 1);
        label.setFont(LEFont.getBoldFont());
        panel.add("North", label);
        LEDataSpec lEDataSpec = lENetworkRanges.getKeySpec();
        LEDataSpec lEDataSpec2 = lENetworkRanges.getSpecFor("entry");
        Component[][] componentArray = new Component[2][2];
        componentArray[0][0] = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(lEPortMaster, null, null, lEDataSpec);
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec2.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(lEPortMaster, null, null, lEDataSpec2);
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.getFrame(this), "Add Network Range", panel);
        if (lEAddDialog.okay()) {
            String string = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            String string2 = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            if (lENetworkRanges.get(string) == null) {
                LEVector lEVector = lENetworkRanges.add(string, string2);
                if (lEVector != null) {
                    new LECmdErrorDialog(LEUiUtils.getFrame(this), lEPortMaster, lEVector);
                }
                this.addEntry(lENetworkRanges.getPortMaster().getHostname(), lENetworkRanges, string);
                return;
            }
            new LEErrorDialog(LEUiUtils.getFrame(this), String.valueOf(lEPortMaster.getHostname()) + " already contains the network " + string);
        }
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LENetworkRanges)) {
            return;
        }
        LENetworkRanges lENetworkRanges = (LENetworkRanges)lETable;
        LEVector lEVector = lENetworkRanges.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.getFrame(this), lEPortMaster, lEVector);
        }
    }
}

