/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEConfigPanel;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LERebootDialog;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LECompMatrix;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEStatusDialog;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LESaveConfigDialog
extends Dialog
implements ActionListener {
    public static final String SAVE = "Save";
    public static final String OLD_VALUE = "Old Value";
    public static final String NEW_VALUE = "New Value";
    public static final String VALID_VALUES = "Valid Values";
    LEVector m_keys = new LEVector();
    LEVector m_allKeys;
    LEVector m_panels;
    int m_index;
    LEConfigPanel m_panel;
    LECompMatrix m_matrix;
    Frame m_parent;
    Button m_ok;

    public LESaveConfigDialog(Frame frame, LEVector lEVector, LEVector lEVector2) {
        super(frame, SAVE, true);
        this.m_allKeys = lEVector;
        this.m_parent = frame;
        this.m_panels = lEVector2;
        this.m_index = 0;
        this.setLayout(new BorderLayout(5, 5));
        this.saveNext();
    }

    public void saveNext() {
        if (this.m_index == this.m_panels.size()) {
            return;
        }
        this.m_panel = (LEConfigPanel)this.m_panels.elementAt(this.m_index++);
        this.removeAll();
        this.buildValues(this.m_allKeys, this.m_panel);
        if (this.m_matrix != null) {
            LEPortMaster lEPortMaster = this.m_panel.getPortMaster();
            Label label = new Label(lEPortMaster.getHostname(), 1);
            label.setFont(LEFont.getBoldFont());
            this.add("North", label);
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(1));
            Panel panel2 = new Panel();
            panel2.setLayout(new GridLayout(1, 2, 10, 10));
            this.m_ok = new Button("OK");
            panel2.add(this.m_ok);
            this.m_ok.addActionListener(this);
            Button button = new Button("Cancel");
            panel2.add(button);
            button.addActionListener(this);
            panel.add(panel2);
            this.add("South", panel);
            ((Component)this).setVisible(true);
            return;
        }
        this.saveNext();
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dimension.width, dimension.height);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
        if (actionEvent.getSource() == this.m_ok) {
            this.save();
        }
    }

    void save() {
        LEStatusDialog lEStatusDialog;
        Object object;
        LEConfig lEConfig = this.m_panel.getConfig();
        boolean bl = false;
        int n = this.m_keys.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = (String)this.m_keys.elementAt(n3);
            Checkbox checkbox = (Checkbox)this.m_matrix.getComponent(n3, 0);
            if (checkbox.getState()) {
                Label label = (Label)this.m_matrix.getComponent(n3, 2);
                lEConfig.set(string, label.getText());
                if (lEConfig.requiresReboot(string)) {
                    bl = true;
                }
                ++n2;
            }
            ++n3;
        }
        if (bl && !((LERebootDialog)(object = new LERebootDialog(this.m_parent))).shouldReboot()) {
            bl = false;
        }
        object = null;
        if (n2 > 0) {
            lEStatusDialog = new LEStatusDialog(this.m_parent);
            object = lEConfig.saveChanges(bl);
            lEStatusDialog.hideStatus();
        }
        if (object != null) {
            new LECmdErrorDialog(this.m_parent, this.m_panel.getPortMaster(), (LEVector)object);
            lEStatusDialog = new LEStatusDialog(this.m_parent);
            lEConfig.refresh();
            lEStatusDialog.hideStatus();
        }
        this.saveNext();
    }

    void buildValues(LEVector lEVector, LEConfigPanel lEConfigPanel) {
        int n;
        LEFormLine lEFormLine;
        String string;
        this.m_matrix = null;
        this.m_keys.removeAllElements();
        LEConfig lEConfig = lEConfigPanel.getConfig();
        boolean bl = true;
        int n2 = lEVector.size();
        int n3 = 0;
        while (n3 < n2) {
            string = (String)lEVector.elementAt(n3);
            Component component = lEConfigPanel.getFormComponent(string);
            if (component instanceof LEFormLine && component.isEnabled() && !(lEFormLine = (LEFormLine)((Object)component)).equalsField(lEConfig.get(string))) {
                this.m_keys.addElement(string);
                if (!lEFormLine.isValueValid()) {
                    bl = false;
                }
            }
            ++n3;
        }
        int n4 = bl ? 3 : 4;
        String[] stringArray = new String[n4];
        stringArray[0] = SAVE;
        stringArray[1] = OLD_VALUE;
        stringArray[2] = NEW_VALUE;
        if (!bl) {
            stringArray[3] = VALID_VALUES;
        }
        if ((n = this.m_keys.size()) == 0) {
            return;
        }
        String[] stringArray2 = new String[n];
        Component[][] componentArray = new Component[n][n4];
        int n5 = 0;
        while (n5 < n) {
            string = (String)this.m_keys.elementAt(n5);
            stringArray2[n5] = String.valueOf(lEConfig.getDescriptionFor(string)) + ":";
            componentArray[n5][1] = new Label(lEConfig.get(string).toString(), 0);
            lEFormLine = (LEFormLine)((Object)lEConfigPanel.getFormComponent(string));
            componentArray[n5][2] = new Label(lEFormLine.getValue(), 0);
            if (!lEFormLine.isValueValid()) {
                componentArray[n5][0] = new Checkbox(null, null, false);
                componentArray[n5][0].setEnabled(false);
                componentArray[n5][2].setForeground(Color.red);
                componentArray[n5][3] = new Label(lEFormLine.getValidValues(), 0);
            } else {
                componentArray[n5][0] = new Checkbox(null, null, true);
            }
            ++n5;
        }
        this.m_matrix = new LECompMatrix(stringArray2, stringArray, componentArray, true);
        this.add("Center", this.m_matrix);
    }
}

