/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.model.LEDebugSetting;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEDebugFacility {
    LEDSSPortMaster m_dss;
    LEVector m_settings = new LEVector();
    LEVector m_hex = new LEVector();
    int m_mask;
    long m_hexRequest;

    public LEDebugFacility(LEDSSPortMaster dss) {
        this.m_dss = dss;
    }

    public synchronized boolean startDebug(int entity, int debug) {
        if (entity == 393216) {
            return this.startHexDebug(debug);
        }
        return this.startEntityDebug(entity, debug);
    }

    public synchronized void stopDebug(int entity, int debug) {
        if (entity == 393216) {
            this.stopHexDebug(debug);
        } else {
            this.stopEntityDebug(entity, debug);
        }
    }

    boolean startHexDebug(int hex) {
        int old_mask = this.m_mask;
        this.m_mask |= hex;
        this.m_hex.addElement(new Integer(hex));
        if (this.m_mask == old_mask) {
            return true;
        }
        return this.resetHexDebug();
    }

    boolean startEntityDebug(int entity, int debug) {
        boolean success = true;
        LEDebugSetting setting = this.getSetting(entity, debug);
        if (setting == null) {
            try {
                long request = this.m_dss.debug(entity, debug);
                setting = new LEDebugSetting(entity, debug, request);
                this.m_settings.addElement(setting);
            }
            catch (Exception e) {
                success = false;
                LEDebug.getLog().logln(20, e);
            }
        } else {
            setting.increment();
        }
        return success;
    }

    void stopHexDebug(int hex) {
        this.m_hex.removeElement(new Integer(hex));
        int mask = 0;
        int len = this.m_hex.size();
        int i = 0;
        while (i < len) {
            Integer val = (Integer)this.m_hex.elementAt(i);
            mask |= val.intValue();
            ++i;
        }
        if (this.m_mask == mask) {
            return;
        }
        this.m_mask = mask;
        this.resetHexDebug();
    }

    void stopEntityDebug(int entity, int debug) {
        block3: {
            LEDebugSetting setting = this.getSetting(entity, debug);
            if (setting == null) {
                return;
            }
            if (setting.decrement() != 0) break block3;
            this.m_settings.removeElement(setting);
            try {
                this.m_dss.killDebug(setting.getRequestID());
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
    }

    boolean resetHexDebug() {
        if (this.m_hexRequest > 0L) {
            try {
                this.m_dss.killDebug(this.m_hexRequest);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
            this.m_hexRequest = 0L;
        }
        if (this.m_mask > 0) {
            try {
                this.m_hexRequest = this.m_dss.debug(393216, this.m_mask);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                this.m_mask = 0;
                return false;
            }
        }
        return true;
    }

    LEDebugSetting getSetting(int entity, int debug) {
        LEDebugSetting setting = null;
        int len = this.m_settings.size();
        int i = 0;
        while (setting == null && i < len) {
            setting = (LEDebugSetting)this.m_settings.elementAt(i);
            if (!setting.matches(entity, debug)) {
                setting = null;
            }
            ++i;
        }
        return setting;
    }
}

