/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEFilter;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEFilters
extends LETable {
    public LEFilters(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LEFilters config = new LEFilters(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("filter", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            if (ret.getStatus()) {
                LEFilter filter = (LEFilter)this.getConfig(name);
                filter.initialize();
            } else {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("filter", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        LEFilter filter = (LEFilter)child;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("filter ");
        buf.append(filter.getName());
        cmds.addElement(new String(buf));
        child.getAllCommands(cmds);
        return true;
    }

    LEConfig createConfig(String key) {
        return new LEFilter(this.m_pm, key);
    }
}

