/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LEOSPF
extends LEConfig {
    public static final String PRIORITY = "97";
    public static final String ROUTER_ID = "100";
    public static final int KEY_COUNT = 2;
    public static final String OSPF_TAG = "ospf";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[2];
            int i = 0;
            LEOSPF.s_keys[i++] = PRIORITY;
            LEOSPF.s_keys[i++] = ROUTER_ID;
        }
        return s_keys;
    }

    public LEOSPF(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LEOSPF config = new LEOSPF(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public boolean requiresReboot(String key) {
        return key.equals(ROUTER_ID);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        boolean reboot = false;
        int start = cmds.size();
        if (allCmds || keys.contains(PRIORITY)) {
            this.makeSetCommand(cmds, OSPF_TAG, PRIORITY, "priority");
        }
        if (allCmds || keys.contains(ROUTER_ID)) {
            reboot = this.makeSetCommand(cmds, OSPF_TAG, ROUTER_ID, "router-id");
        }
        cmds.addElement("save all");
        cmds.addElement("reboot");
        return cmds.size() > start;
    }
}

