/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.amf.LEAMManager;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEPortIOMessage;
import COM.livingston.backend.LESendResponse;
import COM.livingston.model.LEAsyncPort;
import COM.livingston.model.LEAsyncPorts;
import COM.livingston.model.LEChoicenet;
import COM.livingston.model.LEDBLoginUser;
import COM.livingston.model.LEDBLoginUsers;
import COM.livingston.model.LEDBNetUser;
import COM.livingston.model.LEDBNetUsers;
import COM.livingston.model.LEDLCIList;
import COM.livingston.model.LEDialScript;
import COM.livingston.model.LEEthernet;
import COM.livingston.model.LEEthernets;
import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEGlobal;
import COM.livingston.model.LEHostOverrides;
import COM.livingston.model.LEIPRule;
import COM.livingston.model.LEIPRules;
import COM.livingston.model.LEIPXRule;
import COM.livingston.model.LEIPXRules;
import COM.livingston.model.LEISDNPort;
import COM.livingston.model.LEISDNPorts;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.model.LELoginUser;
import COM.livingston.model.LELoginUsers;
import COM.livingston.model.LENetUser;
import COM.livingston.model.LENetUsers;
import COM.livingston.model.LEParallelPort;
import COM.livingston.model.LEParallelPorts;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LEPorts;
import COM.livingston.model.LERadius;
import COM.livingston.model.LESAPRule;
import COM.livingston.model.LESAPRules;
import COM.livingston.model.LESyncPort;
import COM.livingston.model.LESyncPorts;
import COM.livingston.model.LEUsers;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEOctets;
import COM.livingston.util.LETokenizer;
import java.io.EOFException;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;

public class LEPMOldParser {
    public static final int GL_OPT_RIP = 1;
    public static final int GL_OPT_SLIP = 2;
    public static final int GL_OPT_ETHER_DOWN = 4;
    public static final int GL_OPT_BROAD_HIGH = 8;
    public static final int GL_OPT_SNMP = 16;
    public static final int GL_OPT_NO_LISTEN = 32;
    public static final int GL_OPT_DEF_RIP = 64;
    public static final int GL_OPT_DEF_LISTEN = 128;
    public static final int GL_OPT_IP_FILTER = 256;
    public static final int GL_OPT_DNS = 512;
    public static final int GL_OPT_PMEMSG = 1024;
    public static final int GL_OPT_NO_LCL_IP = 2048;
    public static final int GL_OPT_ETHER_IPX = 4096;
    public static final int GL_OPT_NETBIOS = 8192;
    public static final int GL_OPT_ACCOUNTING = 16384;
    public static final int GL_OPT_NO_PAP = 32768;
    public static final int GL_XOPT_NO_IPX = 65536;
    public static final int GL_XOPT_NO_CHAP = 131072;
    public static final int GL_XOPT_NO_SERIAL_ADMIN = 262144;
    public static final int GL_XOPT_ANY_USER_NETMASK = 524288;
    public static final int GL_XOPT_OSPF = 0x100000;
    public static final int GL_XOPT_ISDN_MSN = 0x200000;
    public static final int GL_XOPT_BGP = 0x400000;
    public static final int GL_XOPT_ISDN_AUTO = 0x800000;
    public static final int GL_XOPT_CALL_CHECK = 0x1000000;
    public static final int GL_XOPT_NO_PROXY_ARP = 0x2000000;
    public static final int GL_ISDN_PRI = 64;
    public static final String FIL_IP_FILTERS = "bigfilt";
    public static final String FIL_IPX_FILTERS = "ipxfilt";
    public static final String FIL_SAP_FILTERS = "sapfilt";
    public static final String FIL_BLANK_IP = "0.0.0.0/0";
    public static final int FIL_IP_OPT_SRC = 1;
    public static final int FIL_IP_OPT_DST = 2;
    public static final int FIL_IP_OPT_PROTO = 4;
    public static final int FIL_IP_OPT_SPORT = 8;
    public static final int FIL_IP_OPT_DPORT = 16;
    public static final int FIL_IP_OPT_ESTAB = 32;
    public static final int FIL_IP_OPT_DENY = 64;
    public static final int FIL_IP_OPT_SPORT_LT = 256;
    public static final int FIL_IP_OPT_SPORT_GT = 512;
    public static final int FIL_IP_OPT_DPORT_LT = 1024;
    public static final int FIL_IP_OPT_DPORT_GT = 2048;
    public static final int FIL_IP_OPT_LOG = 4096;
    public static final int FIL_IP_OPT_NOTIFY = 8192;
    public static final int FIL_IP_OPT_SCNET = 16384;
    public static final int FIL_IP_OPT_DCNET = 32768;
    public static final int FIL_IP_PROTO_IP = 0;
    public static final int FIL_IP_PROTO_ICMP = 1;
    public static final int FIL_IP_PROTO_IPIP = 4;
    public static final int FIL_IP_PROTO_TCP = 6;
    public static final int FIL_IP_PROTO_UDP = 17;
    public static final int FIL_IP_PROTO_ESP = 50;
    public static final int FIL_IP_PROTO_AH = 51;
    public static final int FIL_IPX_OPT_SRC_NETWORK = 1;
    public static final int FIL_IPX_OPT_DST_NETWORK = 2;
    public static final int FIL_IPX_OPT_SRC_HOST = 4;
    public static final int FIL_IPX_OPT_DST_HOST = 8;
    public static final int FIL_IPX_OPT_SRC_SOCKET = 16;
    public static final int FIL_IPX_OPT_DST_SOCKET = 32;
    public static final int FIL_IPX_OPT_DENY = 64;
    public static final int FIL_IPX_OPT_SRC_LT = 256;
    public static final int FIL_IPX_OPT_SRC_GT = 512;
    public static final int FIL_IPX_OPT_DST_LT = 1024;
    public static final int FIL_IPX_OPT_DST_GT = 2048;
    public static final int FIL_IPX_OPT_LOG = 4096;
    public static final int FIL_IPX_OPT_NOTIFY = 8192;
    public static final int FIL_SAP_OPT_SERVER = 1;
    public static final int FIL_SAP_OPT_NETWORK = 2;
    public static final int FIL_SAP_OPT_HOST = 4;
    public static final int FIL_SAP_OPT_NOT_USED = 8;
    public static final int FIL_SAP_OPT_SOCKET = 16;
    public static final int FIL_SAP_OPT_SERVICE = 32;
    public static final int FIL_SAP_OPT_DENY = 64;
    public static final int FIL_SAP_OPT_LT = 256;
    public static final int FIL_SAP_OPT_GT = 512;
    public static final String USER_ID = "passwd";
    public static final String USER_TYPE_LOGIN = "USER";
    public static final String USER_TYPE_LOGIN_BACK = "USERBACK";
    public static final String USER_TYPE_NET = "IPIN";
    public static final String USER_TYPE_NET_BACK = "IPBACK";
    public static final String USER_IP_NEGOTIATED = "255.255.255.255";
    public static final String USER_IP_ASSIGNED = "255.255.255.254";
    public static final String USER_HOST_DEFAULT_KEY = "0.0.0.0";
    public static final String USER_HOST_PROMPT_KEY = "255.255.255.255";
    public static final int USER_OPT_ROUTE = 1;
    public static final int USER_OPT_COMPRESSION = 2;
    public static final int USER_OPT_PPP_PROTO = 4;
    public static final int USER_OPT_NO_LISTEN = 8;
    public static final int USER_OPT_IP_NEGOTIATED = 256;
    public static final int USER_OPT_IP_ASSIGNED = 512;
    public static final int USER_XOPT_FILTER = 16;
    public static final int USER_XOPT_INVALID = 32;
    public static final int USER_XOPT_LOOKING = 64;
    public static final int USER_XOPT_NEW = 128;
    public static final int USER_XOPT_PROTO_IP = 256;
    public static final int USER_XOPT_PROTO_IPX = 512;
    public static final int USER_XOPT_RADIUS = 1024;
    public static final int USER_XOPT_CHALLENGE = 2048;
    public static final int USER_XOPT_DISC_RADIUS = 4096;
    public static final int USER_XOPT_PROTO_ATALK = 8192;
    public static final int USER_XOPT_END_NODE = 16384;
    public static final int USER_XOPT_IDLE_SECONDS = 32768;
    public static final String LOC_ID = "location";
    public static final int LOC_OPT_ROUTE_QUIET = 1;
    public static final int LOC_OPT_CONTINUOUS = 2;
    public static final int LOC_OPT_ON_DEMAND = 4;
    public static final int LOC_OPT_COMPRESSION = 8;
    public static final int LOC_OPT_FRAME_RELAY = 16;
    public static final int LOC_OPT_PPP = 32;
    public static final int LOC_OPT_ROUTE_NOLIST = 64;
    public static final int LOC_XOPT_ATALK = 1;
    public static final int LOC_XOPT_MLPPP = 2;
    public static final int LOC_XOPT_ISDN_VOICE = 4;
    public static final int LOC_XOPT_LOCAL_ADDR = 8;
    public static final int LOC_XOPT_GEN_SCRIPT = 16;
    public static final int LOC_XOPT_NO_RIPDIAL = 32;
    public static final int LOC_XOPT_CHAP = 64;
    public static final int LOC_XOPT_OLD_OSPF = 128;
    public static final int LOC_XOPT_IDLE_SECONDS = 256;
    public static final int LOC_XOPT_ISDN_ANALOG = 512;
    public static final int LOC_XOPT_CCPLZS = 1024;
    public static final int LOC_XOPT_DIALBACK = 2048;
    public static final String LOC_IP_NEGOTIATED = "255.255.255.255";
    public static final String LOC_IP_BLANK = "0.0.0.0";
    public static String DIAL_FS = null;
    public static String DIAL_EOL = null;
    public static final String ETHERNET_ID = "ether";
    public static final int ETHER_OPT_RIP = 1;
    public static final int ETHER_OPT_IP_DOWN = 4;
    public static final int ETHER_OPT_BROAD_HIGH = 8;
    public static final int ETHER_OPT_NO_LISTEN = 32;
    public static final int ETHER_OPT_DEF_RIP = 64;
    public static final int ETHER_OPT_DEF_LISTEN = 128;
    public static final int ETHER_OPT_IP_FILTER = 256;
    public static final int ETHER_OPT_OSPF_MIGR = 2048;
    public static final int ETHER_OPT_IPX = 4096;
    public static final int ETHER_OPT_APPLETALK = 8192;
    public static final int ETHER_OPT_NO_SEED = 16384;
    public static final int ETHER_OPT_OSPF = 32768;
    public static final int PORT_OPT_NOXONXOFF = 4;
    public static final int PORT_OPT_RTSCTS = 32;
    public static final int PORT_OPT_NONE = 0;
    public static final int PORT_OPT_HOSTNAME = 1;
    public static final int PORT_OPT_EXTENDED = 2;
    public static final int PORT_OPT_LOGIN_PROMPT = 4;
    public static final int PORT_OPT_ROUTE_BROAD = 8;
    public static final int PORT_OPT_SLIP_DIALIN = 16;
    public static final int PORT_OPT_SLIP_DIALOUT = 32;
    public static final int PORT_OPT_EPS = 64;
    public static final int PORT_OPT_DTR_IDLE = 128;
    public static final int PORT_OPT_COMPRESS = 256;
    public static final int PORT_OPT_PPP = 512;
    public static final int PORT_OPT_ROUTE_NOLIST = 1024;
    public static final int PORT_OPT_ALT_ENCODE = 2048;
    public static final int PORT_OPT_SECURE = 4096;
    public static final int PORT_OPT_DMA = 8192;
    public static final int PORT_OPT_ACCESS = 16384;
    public static final int PORT_OPT_ANNEXD = 16384;
    public static final int PORT_OPT_NO_DISCONN = 32768;
    public static final int PORT_OPT_ATALK = 65536;
    public static final int PORT_OPT_ATALK_NODE = 131072;
    public static final int PORT_OPT_OSPF = 262144;
    public static final int PORT_OPT_IDLE_SECS = 524288;
    public static final int PORT_OPT_CCP = 0x200000;
    public static final int PORT_OPT_OVER_XONXOFF = 1;
    public static final int PORT_OPT_OVER_SPEED = 2;
    public static final int PORT_OPT_OVER_DATABITS = 4;
    public static final int PORT_OPT_OVER_STOPBITS = 8;
    public static final int PORT_OPT_OVER_PARITY = 16;
    public static final int PORT_OPT_OVER_RTSCTS = 32;
    public static final int PORT_OPT_OVER_PARCTL = 64;
    public static final String PORT_TYPE_LOGIN = "Login";
    public static final String PORT_TYPE_TWOWAY = "TwoWay";
    public static final String PORT_TYPE_DEVICE = "Device";
    public static final String PORT_TYPE_NETWORK = "Netwrk";
    public static final String PORT_TYPE_SLIP = "SLIP";
    public static final String PORT_TYPE_PPP = "PPP";
    public static final String PORT_DEF_IP = "0.0.0.0";
    public static final String PORT_DEF_IPX = "00000000";
    public static final String PORT_NO_DEVICE = "/";
    public static final String PORT_LMI_LMI = "LMI";
    public static final String PORT_LMI_ANNEXD = "ANNEXD";
    public static final String PORT_MTU_BUG = "0";
    public static final String PORT_MTU_DEF = "1500";
    public static final String PORT_PO = "P0";
    public static final String PORT_DLCI_PRE = "DLCI:";

    public static boolean Parse(String key, LEDSSPortMaster dss, LEPortMaster pm) {
        if (key.equals("global") || key.equals("radius") || key.equals("choicenet")) {
            return LEPMOldParser.ParseGlobal(dss, pm);
        }
        if (key.equals("filter")) {
            return LEPMOldParser.ParseFilters(dss, pm);
        }
        if (key.equals("port")) {
            return LEPMOldParser.ParsePorts(dss, pm);
        }
        if (key.equals("user")) {
            return LEPMOldParser.ParseUsers(dss, pm);
        }
        if (key.equals(LOC_ID)) {
            return LEPMOldParser.ParseLocations(dss, pm);
        }
        if (key.equals("ethernet")) {
            return LEPMOldParser.ParseEthernets(dss, pm);
        }
        return false;
    }

    public static boolean ParseGlobal(LEDSSPortMaster dss, LEPortMaster pm) {
        LETokenizer tok = null;
        try {
            byte[] req = new byte[]{0};
            LESendResponse resp = dss.send((byte)8, (short)req.length, req, false);
            if (resp.successful()) {
                tok = resp.getStreamTok();
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        if (tok == null) {
            return false;
        }
        try {
            String tmp = tok.getNextString();
            tmp = tok.getNextString();
            LEGlobal global = (LEGlobal)pm.getConfig("global");
            global.setField("host_1", tok.getNextString());
            global.setField("gateway", tok.getNextString());
            tmp = tok.getNextString();
            global.setField("port", tok.getNextString());
            tmp = tok.getNextString();
            global.setField("swversion", tok.getNextString());
            global.setField("host_2", tok.getNextString());
            global.setField("host_3", tok.getNextString());
            global.setField("host_4", tok.getNextString());
            global.setField("nameserver", tok.getNextString());
            global.setField("domain", tok.getNextQuotedString());
            int options = tok.getNextInt();
            if ((options & 0x10) != 0) {
                global.setField("snmp", "on");
            } else {
                global.setField("snmp", "off");
            }
            if ((options & 0x40) != 0) {
                global.setField("def_rip", "on");
            } else {
                global.setField("def_rip", "off");
            }
            if ((options & 0x80) != 0) {
                global.setField("def_listen", "on");
            } else {
                global.setField("def_listen", "off");
            }
            if ((options & 0x200) != 0) {
                global.setField("namesvc", "dns");
            } else {
                global.setField("namesvc", "nis");
            }
            if ((options & 0x800) != 0) {
                global.setField("localip", "off");
            } else {
                global.setField("localip", "on");
            }
            if ((options & 0x2000) != 0) {
                global.setField("netbios", "on");
            } else {
                global.setField("netbios", "off");
            }
            if ((options & 0x8000) != 0) {
                global.setField("pap", "off");
            } else {
                global.setField("pap", "on");
            }
            if ((options & 0x10000) != 0) {
                global.setField("IPX", "off");
            } else {
                global.setField("IPX", "on");
            }
            if ((options & 0x20000) != 0) {
                global.setField("chap", "off");
            } else {
                global.setField("chap", "on");
            }
            if ((options & 0x40000) != 0) {
                global.setField("serial-admin", "off");
            } else {
                global.setField("serial-admin", "on");
            }
            if ((options & 0x80000) != 0) {
                global.setField("user-netmask", "on");
            } else {
                global.setField("user-netmask", "off");
            }
            if ((options & 0x100000) != 0) {
                global.setField("ospf", "enable");
            } else {
                global.setField("ospf", "disable");
            }
            if ((options & 0x400000) != 0) {
                global.setField("BGP", "enable");
            } else {
                global.setField("BGP", "disable");
            }
            if ((options & 0x1000000) != 0) {
                global.setField("call-check", "on");
            } else {
                global.setField("call-check", "off");
            }
            if ((options & 0x2000000) != 0) {
                global.setField("arp-proxy", "disable");
            } else {
                global.setField("arp-proxy", "enable");
            }
            global.setField("telnet", tok.getNextString());
            global.setField("loghost", tok.getNextString());
            global.setField("assigned_address", tok.getNextString());
            global.setField("IPGatewayMetric", tok.getNextString());
            global.setField("hwversion", tok.getNextString());
            tmp = tok.getNextQuotedString();
            tmp = tok.getNextQuotedString();
            LERadius radius = (LERadius)pm.getConfig("radius");
            radius.setField("authentication_server", tok.getNextString());
            radius.setField("alternate_auth_server", tok.getNextString());
            tmp = tok.getNextString();
            tmp = tok.getNextString();
            tmp = tok.getNextString();
            tmp = tok.getNextString();
            global.setField("numethers", tok.getNextString());
            int swType = tok.getNextInt();
            boolean isPri = (swType & 0x40) != 0;
            String swName = "";
            String key = isPri ? "pri_switch" : "bri_switch";
            switch (swType &= 0xFFFFFFBF) {
                case 0: {
                    if (isPri) break;
                    swName = "ni-1";
                    break;
                }
                case 1: {
                    swName = "att-5ess";
                    break;
                }
                case 2: {
                    swName = "dms-100";
                    break;
                }
                case 3: {
                    swName = "ccitt";
                    break;
                }
                case 4: {
                    swName = "att-5ess-ptp";
                    break;
                }
                case 5: {
                    swName = "net3";
                    break;
                }
                case 6: {
                    swName = "net3-swiss";
                    break;
                }
                case 7: {
                    swName = "1tr6";
                    break;
                }
                case 8: {
                    swName = "kdd";
                    break;
                }
                case 9: {
                    swName = "ntt";
                    break;
                }
                case 10: {
                    swName = "vn2";
                    break;
                }
                case 11: {
                    swName = "vn3";
                    break;
                }
                case 12: {
                    swName = "vn4";
                    break;
                }
                case 13: {
                    swName = "vnP";
                    break;
                }
                case 14: {
                    swName = "att-4ess";
                    break;
                }
                case 15: {
                    swName = "net5";
                    break;
                }
                case 16: {
                    swName = "net5-swiss";
                    break;
                }
                case 17: {
                    swName = "ni-2";
                    break;
                }
            }
            global.setField(key, swName);
            if (!isPri) {
                if ((options & 0x200000) != 0) {
                    global.setField("isdn-msn", "on");
                } else {
                    global.setField("isdn-msn", "off");
                }
                if ((options & 0x800000) != 0) {
                    global.setField("isdn-numberauto", "on");
                } else {
                    global.setField("isdn-numberauto", "off");
                }
            }
            global.setField("max_pmconsole", tok.getNextString());
            global.setField("alt_name_server", tok.getNextString());
            global.setField("uptime", tok.getNextString());
            global.setField("reported_ip", tok.getNextQuotedString());
            radius.setField("accounting", tok.getNextQuotedString());
            radius.setField("alt_acct_server", tok.getNextQuotedString());
            LEChoicenet cnet = (LEChoicenet)pm.getConfig("choicenet");
            cnet.setField("choicenet", tok.getNextQuotedString());
            cnet.setField("alt_cnet_server", tok.getNextQuotedString());
            global.setField("pri_nbns_server", tok.getNextQuotedString());
            global.setField("alt_nbns_server", tok.getNextQuotedString());
            tmp = tok.getNextQuotedString();
            tmp = tok.getNextQuotedString();
            global.setField("endpoint", tok.getNextQuotedString());
            tmp = tok.getNextQuotedString();
            global.setField("pool", tok.getNextString());
            global.setField("password", "");
            radius.setField("secret", "");
            cnet.setField("choicenet-secret", "");
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return true;
    }

    public static boolean ParseFilters(LEDSSPortMaster dss, LEPortMaster pm) {
        boolean success = LEPMOldParser.ParseIPFilters(dss, pm);
        success |= LEPMOldParser.ParseIPXFilters(dss, pm);
        return success |= LEPMOldParser.ParseSAPFilters(dss, pm);
    }

    public static boolean ParseIPFilters(LEDSSPortMaster dss, LEPortMaster pm) {
        LEFilters filters = (LEFilters)pm.getConfig("filter");
        boolean success = true;
        try {
            LESendResponse resp = dss.send((byte)17, (short)FIL_IP_FILTERS.length(), FIL_IP_FILTERS, true);
            if (resp.successful()) {
                LETokenizer tok = resp.getStreamTok();
                String tmp = tok.getNextString();
                int count = tok.getNextInt();
                int numRules = tok.getNextInt();
                int blkSize = tok.getNextInt();
                if (count > 0) {
                    resp = dss.recv(true);
                    if (resp.successful()) {
                        tok = resp.getStreamTok();
                        success = LEPMOldParser.ParseIPFilter(dss, filters, tok, 0);
                        int i = 1;
                        while (success && i < count) {
                            String id = "bigfilt " + i + " 0";
                            dss.done();
                            resp = dss.send((byte)17, (short)id.length(), id, true);
                            if (resp.successful()) {
                                tok = resp.getStreamTok();
                                success = LEPMOldParser.ParseIPFilter(dss, filters, tok, i);
                            } else {
                                success = false;
                            }
                            ++i;
                        }
                    } else {
                        success = false;
                    }
                }
            } else {
                success = false;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            success = false;
        }
        dss.done();
        return success;
    }

    public static boolean ParseIPFilter(LEDSSPortMaster dss, LEFilters filters, LETokenizer tok, int filterNum) {
        try {
            String name = tok.getNextString();
            LEFilter filter = (LEFilter)filters.getConfig(name);
            LEIPRules rules = (LEIPRules)filter.getConfig("ip_rule");
            filter.getConfig("ipx_rule");
            filter.getConfig("sap_rule");
            int numRules = tok.getNextInt();
            int ruleNum = tok.getNextInt();
            String sep = tok.getNextString();
            int i = ruleNum;
            while (i < numRules) {
                if (LEPMOldParser.ParseIPRule(rules, tok) && i < numRules - 1) {
                    String tmp = "bigfilt " + filterNum + " " + (i + 1);
                    dss.done();
                    LESendResponse resp = dss.send((byte)17, (short)tmp.length(), tmp, true);
                    if (resp.successful() && filterNum == 0) {
                        resp = dss.recv(true);
                    }
                    if (!resp.successful()) {
                        return false;
                    }
                    tok = resp.getStreamTok();
                    tok.getNextString();
                    tok.getNextInt();
                    tok.getNextInt();
                    tok.getNextString();
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public static boolean ParseIPRule(LEIPRules rules, LETokenizer tok) {
        boolean lastRule = true;
        try {
            String dPort;
            String ruleNum = tok.getNextString();
            int options = tok.getNextInt();
            String srcAddr = tok.getNextString();
            String srcBits = tok.getNextString();
            String dstAddr = tok.getNextString();
            String dstBits = tok.getNextString();
            int proto = tok.getNextInt();
            String sPort = tok.getNextString();
            String num3str = tok.getNextString();
            int icmpType = 0;
            int protoNum = 0;
            boolean estab = false;
            boolean log = false;
            boolean notify = false;
            String sPortComp = "";
            String dPortComp = "";
            int len = num3str.length();
            if (len > 0 && num3str.charAt(len - 1) == '|') {
                dPort = num3str.substring(0, len - 1);
                lastRule = false;
            } else {
                dPort = num3str;
            }
            LEIPRule rule = (LEIPRule)rules.getConfig(ruleNum);
            if ((options & 0x40) != 0) {
                rule.setField("action", "deny");
            } else {
                rule.setField("action", "permit");
            }
            if ((options & 1) != 0) {
                rule.setField("source", String.valueOf(srcAddr) + PORT_NO_DEVICE + srcBits);
            } else if ((options & 0x4000) != 0) {
                rule.setField("source", srcAddr);
            } else {
                rule.setField("source", FIL_BLANK_IP);
            }
            if ((options & 2) != 0) {
                rule.setField("destination", String.valueOf(dstAddr) + PORT_NO_DEVICE + dstBits);
            } else if ((options & 0x8000) != 0) {
                rule.setField("destination", dstAddr);
            } else {
                rule.setField("destination", FIL_BLANK_IP);
            }
            switch (proto) {
                case 0: {
                    rule.setField("protocol", "ip");
                    break;
                }
                case 1: {
                    rule.setField("protocol", "icmp");
                    if ((options & 8) == 0) break;
                    icmpType = Integer.parseInt(sPort);
                    break;
                }
                case 4: {
                    rule.setField("protocol", "ipip");
                    break;
                }
                case 6: 
                case 17: {
                    if (proto == 6) {
                        rule.setField("protocol", "tcp");
                    } else {
                        rule.setField("protocol", "udp");
                    }
                    if ((options & 8) != 0) {
                        sPortComp = LEPMOldParser.GetComp(options & 0x100, options & 0x200);
                    }
                    if ((options & 0x10) != 0) {
                        dPortComp = LEPMOldParser.GetComp(options & 0x400, options & 0x800);
                    }
                    if ((options & 0x20) == 0) break;
                    estab = true;
                    break;
                }
                case 50: {
                    rule.setField("protocol", "esp");
                    break;
                }
                case 51: {
                    rule.setField("protocol", "ah");
                    break;
                }
                default: {
                    rule.setField("protocol", "protocol");
                    protoNum = proto;
                }
            }
            rule.setField("src_cmp", sPortComp);
            rule.setField("src_port", sPort);
            rule.setField("dst_cmp", dPortComp);
            rule.setField("dst_port", dPort);
            rule.setField("type", Integer.toString(icmpType));
            rule.setField("protocol_number", Integer.toString(protoNum));
            rule.setField("protocol_number", Integer.toString(protoNum));
            if (estab) {
                rule.setField("estab", "on");
            } else {
                rule.setField("estab", "off");
            }
            if ((options & 0x1000) != 0) {
                rule.setField("log", "on");
            } else {
                rule.setField("log", "off");
            }
            if ((options & 0x2000) != 0) {
                rule.setField("notify", "on");
            } else {
                rule.setField("notify", "off");
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return lastRule;
    }

    public static boolean ParseIPXFilters(LEDSSPortMaster dss, LEPortMaster pm) {
        boolean success = true;
        try {
            LESendResponse resp = dss.send((byte)17, (short)FIL_IPX_FILTERS.length(), FIL_IPX_FILTERS, true);
            if (resp.successful()) {
                LETokenizer tok = resp.getStreamTok();
                String tmp = tok.getNextString();
                int count = tok.getNextInt();
                int blkSize = tok.getNextInt();
                if (count > 0) {
                    LEFilters filters = (LEFilters)pm.getConfig("filter");
                    resp = dss.recv(true);
                    if (resp.successful()) {
                        LEPMOldParser.ParseIPXFilter(filters, resp.getStreamTok());
                        int i = 1;
                        while (success && i < count) {
                            String id = "ipxfilt " + i;
                            dss.done();
                            resp = dss.send((byte)17, (short)id.length(), id, true);
                            if (resp.successful()) {
                                tok = resp.getStreamTok();
                                LEPMOldParser.ParseIPXFilter(filters, resp.getStreamTok());
                            } else {
                                success = false;
                            }
                            ++i;
                        }
                    } else {
                        success = false;
                    }
                }
            } else {
                success = false;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            success = false;
        }
        dss.done();
        return success;
    }

    public static void ParseIPXFilter(LEFilters filters, LETokenizer tok) {
        try {
            String name = tok.getNextString();
            LEFilter filter = (LEFilter)filters.getConfig(name);
            LEIPXRules rules = (LEIPXRules)filter.getConfig("ipx_rule");
            filter.getConfig("ip_rule");
            filter.getConfig("sap_rule");
            int count = tok.getNextInt();
            if (count == 0) {
                return;
            }
            String sep = tok.getNextString();
            boolean foundSep = true;
            while (foundSep) {
                LEIPXRule rule = (LEIPXRule)rules.getConfig(tok.getNextString());
                int options = tok.getNextInt();
                if ((options & 0x40) != 0) {
                    rule.setField("action", "deny");
                } else {
                    rule.setField("action", "permit");
                }
                if ((options & 0x10) != 0) {
                    rule.setField("src_cmp", LEPMOldParser.GetComp(options & 0x100, options & 0x200));
                } else {
                    rule.setField("src_cmp", "");
                }
                if ((options & 0x20) != 0) {
                    rule.setField("dst_cmp", LEPMOldParser.GetComp(options & 0x400, options & 0x800));
                } else {
                    rule.setField("dst_cmp", "");
                }
                String tmp = tok.getNextString();
                if ((options & 1) != 0) {
                    rule.setField("src_net", tmp);
                } else {
                    rule.setField("src_net", "");
                }
                tmp = tok.getNextString();
                if ((options & 4) != 0) {
                    rule.setField("src_host", tmp);
                } else {
                    rule.setField("src_host", "");
                }
                tmp = tok.getNextString();
                if ((options & 0x10) != 0) {
                    rule.setField("src_socket", tmp);
                } else {
                    rule.setField("src_socket", "1");
                }
                tmp = tok.getNextString();
                if ((options & 2) != 0) {
                    rule.setField("dst_net", tmp);
                } else {
                    rule.setField("dst_net", "");
                }
                tmp = tok.getNextString();
                if ((options & 8) != 0) {
                    rule.setField("dst_host", tmp);
                } else {
                    rule.setField("dst_host", "");
                }
                tmp = tok.getNextString();
                if (tmp.endsWith(sep)) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                } else {
                    foundSep = false;
                }
                if ((options & 0x20) != 0) {
                    rule.setField("dst_socket", tmp);
                    continue;
                }
                rule.setField("dst_socket", "1");
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public static boolean ParseSAPFilters(LEDSSPortMaster dss, LEPortMaster pm) {
        boolean success = true;
        try {
            LESendResponse resp = dss.send((byte)17, (short)FIL_SAP_FILTERS.length(), FIL_SAP_FILTERS, true);
            if (resp.successful()) {
                LETokenizer tok = resp.getStreamTok();
                String tmp = tok.getNextString();
                int count = tok.getNextInt();
                int blkSize = tok.getNextInt();
                if (count > 0) {
                    LEFilters filters = (LEFilters)pm.getConfig("filter");
                    resp = dss.recv(true);
                    if (resp.successful()) {
                        LEPMOldParser.ParseSAPFilter(filters, resp.getStreamTok());
                        int i = 1;
                        while (success && i < count) {
                            String id = "sapfilt " + i;
                            dss.done();
                            resp = dss.send((byte)17, (short)id.length(), id, true);
                            if (resp.successful()) {
                                tok = resp.getStreamTok();
                                LEPMOldParser.ParseSAPFilter(filters, resp.getStreamTok());
                            } else {
                                success = false;
                            }
                            ++i;
                        }
                    } else {
                        success = false;
                    }
                }
            } else {
                success = false;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            success = false;
        }
        dss.done();
        return true;
    }

    public static void ParseSAPFilter(LEFilters filters, LETokenizer tok) {
        try {
            String name = tok.getNextString();
            LEFilter filter = (LEFilter)filters.getConfig(name);
            LESAPRules rules = (LESAPRules)filter.getConfig("sap_rule");
            filter.getConfig("ip_rule");
            filter.getConfig("ipx_rule");
            int count = tok.getNextInt();
            if (count == 0) {
                return;
            }
            String sep = tok.getNextString();
            boolean foundSep = true;
            while (foundSep) {
                LESAPRule rule = (LESAPRule)rules.getConfig(tok.getNextString());
                int options = tok.getNextInt();
                if ((options & 0x40) != 0) {
                    rule.setField("action", "deny");
                } else {
                    rule.setField("action", "permit");
                }
                if ((options & 0x10) != 0) {
                    rule.setField("cmp", LEPMOldParser.GetComp(options & 0x100, options & 0x200));
                } else {
                    rule.setField("cmp", "");
                }
                rule.setField("server", tok.getNextQuotedString());
                tok.getNextString();
                String tmp = tok.getNextString();
                if ((options & 2) != 0) {
                    rule.setField("network", tmp);
                } else {
                    rule.setField("network", "");
                }
                tmp = tok.getNextString();
                if ((options & 4) != 0) {
                    rule.setField("host", tmp);
                } else {
                    rule.setField("host", "");
                }
                tmp = tok.getNextString();
                if (tmp.endsWith(sep)) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                } else {
                    foundSep = false;
                }
                if ((options & 0x10) != 0) {
                    rule.setField("socket", tmp);
                    continue;
                }
                rule.setField("socket", "1");
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    static String GetComp(int lt, int gt) {
        if (lt != 0) {
            return "lt";
        }
        if (gt != 0) {
            return "gt";
        }
        return "eq";
    }

    public static boolean ParseUsers(LEDSSPortMaster dss, LEPortMaster pm) {
        boolean success = true;
        try {
            LESendResponse resp = dss.send((byte)17, (short)USER_ID.length(), USER_ID, true);
            if (!resp.successful()) {
                dss.done();
                return false;
            }
            LEUsers users = (LEUsers)pm.getConfig("user");
            users.getConfig("logindialback");
            users.getConfig("netdialback");
            users.getConfig("user");
            users.getConfig("netuser");
            LETokenizer tok = resp.getStreamTok();
            String tmp = tok.getNextString();
            int count = tok.getNextInt();
            int blockSize = tok.getNextInt();
            int i = 0;
            while (i < count) {
                if (i % blockSize == 0 && i > 0) {
                    dss.done();
                    tmp = "passwd " + Integer.toString(i);
                    resp = dss.send((byte)17, (short)tmp.length(), tmp, true);
                } else {
                    resp = dss.recv(true);
                }
                if (!resp.successful()) {
                    dss.done();
                    return false;
                }
                LEPMOldParser.ParseUser(users, resp.getStreamTok());
                ++i;
            }
        }
        catch (Exception e) {
            success = false;
            LEDebug.getLog().logln(20, e);
        }
        dss.done();
        return success;
    }

    public static void ParseUser(LEUsers users, LETokenizer tok) {
        try {
            String username = tok.getNextString();
            String usertype = tok.getNextString();
            if (usertype.equals(USER_TYPE_NET)) {
                LENetUsers netusers = (LENetUsers)users.getConfig("netuser");
                LENetUser user = (LENetUser)netusers.getConfig(username);
                String ipaddress = tok.getNextQuotedString();
                user.setField("netmask", tok.getNextQuotedString());
                int options = tok.getNextInt();
                String destination = (options & 0x100) != 0 ? "negotiated" : ((options & 0x200) != 0 ? "assigned" : (ipaddress.equals("255.255.255.255") ? "negotiated" : (ipaddress.equals(USER_IP_ASSIGNED) ? "assigned" : "specified")));
                user.setField("destination", destination);
                user.setField("IPAddress", ipaddress);
                if ((options & 1) != 0) {
                    user.setField("RIPBroadcast", "on");
                } else {
                    user.setField("RIPBroadcast", "off");
                }
                if ((options & 4) != 0) {
                    user.setField("protocol", "ppp");
                } else {
                    user.setField("protocol", "slip");
                }
                if ((options & 2) != 0) {
                    user.setField("compression", "on");
                } else {
                    user.setField("compression", "off");
                }
                if ((options & 8) != 0) {
                    user.setField("RIPListen", "off");
                } else {
                    user.setField("RIPListen", "on");
                }
                user.setField("mtu", tok.getNextString());
                user.setField("map", tok.getNextString());
                tok.getNextString();
                user.setField("password", "");
                user.setField("ifilter", tok.getNextQuotedString());
                user.setField("ofilter", tok.getNextQuotedString());
                user.setField("ipxnet", tok.getNextString());
                options = (int)tok.getNextHex();
                String idle = String.valueOf(tok.getNextString()) + " ";
                idle = (options & 0x8000) != 0 ? String.valueOf(idle) + "seconds" : String.valueOf(idle) + "minutes";
                user.setField("idle", idle);
                user.setField("session", tok.getNextString());
                user.setField("maxports", tok.getNextString());
                user.setField("local-ip-address", tok.getNextString());
            } else if (usertype.equals(USER_TYPE_NET_BACK)) {
                LEDBNetUsers netusers = (LEDBNetUsers)users.getConfig("netdialback");
                LEDBNetUser user = (LEDBNetUser)netusers.getConfig(username);
                user.setField(LOC_ID, tok.getNextString());
                user.setField("password", "");
            } else if (usertype.equals(USER_TYPE_LOGIN)) {
                LELoginUsers lusers = (LELoginUsers)users.getConfig("user");
                LELoginUser user = (LELoginUser)lusers.getConfig(username);
                String host = tok.getNextString();
                if (host.equals("0.0.0.0")) {
                    user.setField("host", "default");
                    user.setField("HostAddress", "");
                } else if (host.equals("255.255.255.255")) {
                    user.setField("host", "prompt");
                    user.setField("HostAddress", "");
                } else {
                    user.setField("host", "specified");
                    user.setField("HostAddress", host);
                }
                int servNum = tok.getNextInt();
                String port = tok.getNextString();
                String service = null;
                switch (servNum) {
                    case 0: {
                        service = "portmaster";
                        break;
                    }
                    case 1: {
                        service = "rlogin";
                        break;
                    }
                    case 2: {
                        service = "telnet@" + port;
                        break;
                    }
                    case 3: {
                        service = "netdata@" + port;
                        break;
                    }
                }
                if (service != null) {
                    user.setField("service", service);
                }
                tok.getNextString();
                tok.getNextString();
                user.setField("password", "");
                user.setField("ifilter", tok.getNextQuotedString());
                int options = (int)tok.getNextHex();
                String idle = String.valueOf(tok.getNextString()) + " ";
                idle = (options & 0x8000) != 0 ? String.valueOf(idle) + "seconds" : String.valueOf(idle) + "minutes";
                user.setField("idle", idle);
                tok.getNextString();
            } else if (usertype.equals(USER_TYPE_LOGIN_BACK)) {
                LEDBLoginUsers lusers = (LEDBLoginUsers)users.getConfig("logindialback");
                LEDBLoginUser user = (LEDBLoginUser)lusers.getConfig(username);
                tok.getNextString();
                tok.getNextString();
                tok.getNextString();
                user.setField("telephone", tok.getNextString());
                tok.getNextString();
                tok.getNextQuotedString();
                int options = tok.getNextInt();
                String idle = String.valueOf(tok.getNextString()) + " ";
                idle = (options & 0x8000) != 0 ? String.valueOf(idle) + "seconds" : String.valueOf(idle) + "minutes";
                user.setField("idle", idle);
                tok.getNextString();
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public static boolean ParseLocations(LEDSSPortMaster dss, LEPortMaster pm) {
        boolean success = true;
        try {
            LESendResponse resp;
            LELocations locs = (LELocations)pm.getConfig(LOC_ID);
            if (DIAL_FS == null) {
                byte[] b1 = new byte[]{1};
                DIAL_FS = new String(b1, 0, 1);
                byte[] b2 = new byte[]{2};
                DIAL_EOL = new String(b2, 0, 1);
            }
            if (!(resp = dss.send((byte)17, (short)LOC_ID.length(), LOC_ID, true)).successful()) {
                dss.done();
                return false;
            }
            LETokenizer tok = resp.getStreamTok();
            tok.getNextString();
            int count = tok.getNextInt();
            int blockSize = tok.getNextInt();
            int i = 0;
            while (i < count) {
                if (i % blockSize == 0 && i > 0) {
                    dss.done();
                    String id = "location " + i;
                    resp = dss.send((byte)17, (short)id.length(), id, true);
                } else {
                    resp = dss.recv(true);
                }
                if (!resp.successful()) {
                    dss.done();
                    return false;
                }
                LEPMOldParser.ParseLocation(locs, resp.getStreamTok());
                ++i;
            }
        }
        catch (Exception e) {
            success = false;
            LEDebug.getLog().logln(20, e);
        }
        dss.done();
        return success;
    }

    public static void ParseLocation(LELocations locs, LETokenizer tok) {
        try {
            boolean stac;
            StringReader reader;
            String version;
            String name = tok.getNextString();
            LELocation loc = (LELocation)locs.getConfig(name);
            String ipaddress = tok.getNextString();
            if (ipaddress.equals("255.255.255.255")) {
                loc.setField("destination", "negotiated");
            } else {
                loc.setField("destination", "specified");
            }
            loc.setField("IPAddress", ipaddress);
            boolean pppip = true;
            if (ipaddress.length() == 0 || ipaddress.equals("0.0.0.0")) {
                pppip = false;
            }
            loc.setField("netmask", tok.getNextString());
            loc.setField("group", tok.getNextString());
            int options = tok.getNextInt();
            if ((options & 1) != 0) {
                loc.setField("RIPBroadcast", "off");
            } else {
                loc.setField("RIPBroadcast", "on");
            }
            if ((options & 0x40) != 0) {
                loc.setField("RIPListen", "off");
            } else {
                loc.setField("RIPListen", "on");
            }
            if ((options & 2) != 0) {
                loc.setField("type", "continuous");
            } else if ((options & 4) != 0) {
                loc.setField("type", "on_demand");
            } else {
                loc.setField("type", "manual");
            }
            String timeout = tok.getNextString();
            loc.setField("maxports", tok.getNextString());
            loc.setField("high_water", tok.getNextString());
            LEDialScript script = (LEDialScript)loc.getConfig("script");
            LEPMOldParser.LoadScript(script, tok.getNextQuotedString());
            loc.setField("mtu", tok.getNextString());
            loc.setField("map", tok.getNextString());
            loc.setField("ifilter", tok.getNextQuotedString());
            loc.setField("ofilter", tok.getNextQuotedString());
            String ipxnet = tok.getNextString();
            loc.setField("ipxnet", ipxnet);
            boolean pppipx = true;
            if (ipxnet.length() == 0 || Long.parseLong(ipxnet, 16) == 0L) {
                pppipx = false;
            }
            script = (LEDialScript)loc.getConfig("v25bis");
            LEPMOldParser.LoadScript(script, tok.getNextQuotedString());
            String papScript = tok.getNextQuotedString();
            String phone = "";
            String user = "";
            String pw = "";
            if (papScript.length() > 2 && Integer.parseInt(version = LEPMOldParser.ParsePAPScript(reader = new StringReader(papScript))) == 1) {
                phone = LEPMOldParser.ParsePAPScript(reader);
                user = LEPMOldParser.ParsePAPScript(reader);
                pw = LEPMOldParser.ParsePAPScript(reader);
            }
            loc.setField("phone", phone);
            loc.setField("username", user);
            loc.setField("password", pw);
            if ((options & 0x20) != 0) {
                loc.setField("protocol", "ppp");
            } else if ((options & 0x10) != 0) {
                loc.setField("protocol", "frame-relay");
            } else {
                loc.setField("protocol", "slip");
                pppip = false;
                pppipx = false;
            }
            if (pppip) {
                loc.setField("PPPIPType", "on");
            } else {
                loc.setField("PPPIPType", "off");
            }
            if (pppipx) {
                loc.setField("PPPIPXType", "on");
            } else {
                loc.setField("PPPIPXType", "off");
            }
            long xoptions = tok.getNextHex();
            if ((xoptions & 2L) != 0L) {
                loc.setField("multilink", "on");
            } else {
                loc.setField("multilink", "off");
            }
            if ((xoptions & 0x40L) != 0L) {
                loc.setField("chap", "on");
            } else {
                loc.setField("chap", "off");
            }
            if ((xoptions & 4L) != 0L) {
                loc.setField("voice", "on");
            } else {
                loc.setField("voice", "off");
            }
            timeout = (xoptions & 0x100L) != 0L ? String.valueOf(timeout) + " seconds" : String.valueOf(timeout) + " minutes";
            loc.setField("idle", timeout);
            if ((xoptions & 0x200L) != 0L) {
                loc.setField("analog", "on");
            } else {
                loc.setField("analog", "off");
            }
            boolean vj = (options & 8) != 0;
            boolean bl = stac = (xoptions & 0x400L) != 0L;
            if (vj && stac) {
                loc.setField("compression", "on");
            } else if (vj) {
                loc.setField("compression", "vj");
            } else if (stac) {
                loc.setField("compression", "stac");
            } else {
                loc.setField("compression", "off");
            }
            tok.getNextQuotedString();
            tok.getNextQuotedString();
            loc.setField("local-ip-address", tok.getNextString());
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public static void LoadScript(LEDialScript script, String data) {
        int fs = 1;
        int eol = 2;
        int start = 0;
        int end = 0;
        int len = data.length();
        int i = 0;
        while (i < 6) {
            String key = "send" + (i + 1);
            int ch = 0;
            while (end < len && ch != fs && ch != eol) {
                ch = data.charAt(end++);
            }
            String val = start < len ? data.substring(start, end - 1) : "";
            script.setField(key, val);
            start = end;
            key = "expect" + (i + 1);
            ch = 0;
            while (end < len && ch != fs && ch != eol) {
                ch = data.charAt(end++);
            }
            val = start < len ? data.substring(start, end - 1) : "";
            script.setField(key, val);
            start = end;
            ++i;
        }
    }

    public static String ParsePAPScript(StringReader reader) {
        StringBuffer buf = new StringBuffer();
        try {
            char ch = (char)reader.read();
            while (ch != '\u0002') {
                buf.append(ch);
                ch = (char)reader.read();
            }
        }
        catch (IOException iOException) {}
        return new String(buf);
    }

    public static boolean ParseEthernets(LEDSSPortMaster dss, LEPortMaster pm) {
        try {
            LEGlobal global = (LEGlobal)pm.get("global");
            String tmp = (String)global.get("numethers");
            int numEthers = Integer.parseInt(tmp);
            LEEthernets ethernets = (LEEthernets)pm.getConfig("ethernet");
            int i = 0;
            while (i < numEthers) {
                String id = ETHERNET_ID + i;
                LESendResponse resp = dss.send((byte)8, (short)id.length(), id, false);
                if (!resp.successful()) {
                    return false;
                }
                LEEthernet ethernet = (LEEthernet)ethernets.getConfig(id);
                LEPMOldParser.ParseEthernet(ethernet, resp.getStreamTok());
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public static void ParseEthernet(LEEthernet ether, LETokenizer tok) {
        try {
            int len;
            String etherName = tok.getNextString();
            ether.setField("address", tok.getNextString());
            ether.setField("netmask", tok.getNextString());
            int options = tok.getNextInt();
            if ((options & 8) != 0) {
                ether.setField("broadcast", "high");
            } else {
                ether.setField("broadcast", "low");
            }
            if ((options & 1) != 0) {
                ether.setField("RIPBroadcast", "on");
            } else {
                ether.setField("RIPBroadcast", "off");
            }
            if ((options & 0x20) != 0) {
                ether.setField("RIPListen", "off");
            } else {
                ether.setField("RIPListen", "on");
            }
            if ((options & 4) != 0) {
                ether.setField("ip", "disable");
            } else {
                ether.setField("ip", "enable");
            }
            if ((options & 0x1000) != 0) {
                ether.setField("ipx", "enable");
            } else {
                ether.setField("ipx", "disable");
            }
            ether.setField("ifilter", tok.getNextQuotedString());
            ether.setField("ofilter", tok.getNextQuotedString());
            String ipxnet = tok.getNextString();
            StringBuffer buf = new StringBuffer();
            int i = len = ipxnet.length();
            while (i < 8) {
                buf.append(0);
                ++i;
            }
            buf.append(ipxnet);
            ether.setField("ipxnet", buf.toString());
            int frameType = tok.getNextInt();
            switch (frameType) {
                case 0: {
                    ether.setField("ipxframe", "ethernet_802.2_ii");
                    break;
                }
                case 1: {
                    ether.setField("ipxframe", "ethernet_802.2");
                    break;
                }
                case 2: {
                    ether.setField("ipxframe", "ethernet_802.3");
                    break;
                }
                case 3: {
                    ether.setField("ipxframe", "ethernet_ii");
                    break;
                }
            }
            ether.setField("macaddress", tok.getNextString());
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public static boolean ParsePorts(LEDSSPortMaster dss, LEPortMaster pm) {
        try {
            LEPorts ports = (LEPorts)pm.getConfig("port");
            String host = pm.getHostname();
            int count = 0;
            boolean found = true;
            while (found) {
                String id;
                LESendResponse resp;
                if ((resp = dss.send((byte)8, (short)(id = Integer.toString(count++)).length(), id, false)).successful()) {
                    LETokenizer tok = resp.getStreamTok();
                    String portName = tok.getNextString();
                    String tmp = tok.getNextString();
                    if (tmp.equals("-")) {
                        LEPMOldParser.ParseParallelPort(host, ports, portName, tok);
                        continue;
                    }
                    LEPMOldParser.ParsePort(host, ports, portName, tok);
                    continue;
                }
                found = false;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public static void ParsePort(String hostname, LEPorts ports, String portName, LETokenizer tok) {
        LEPortIOMessage msg = new LEPortIOMessage();
        String databits = null;
        String stopbits = null;
        String parity = null;
        String modemControl = null;
        String portType = null;
        String networkType = null;
        String speed1 = null;
        String speed2 = null;
        String speed3 = null;
        String device = null;
        String message = null;
        String xonxoff = null;
        String rtscts = null;
        String host1 = null;
        String host2 = null;
        String host3 = null;
        String host4 = null;
        String destination = null;
        String netmask = null;
        String ipxnet = null;
        String localip = null;
        String dest2 = null;
        String netm2 = null;
        String ipx2 = null;
        String termType = null;
        String username = null;
        int portOptions = 0;
        boolean isNetwork = false;
        boolean isLogin = false;
        boolean isDevice = false;
        boolean isDialin = false;
        boolean isDialout = false;
        boolean isHardwired = false;
        String protocol = "ppp";
        String security = null;
        String hangup = null;
        String ripBroad = null;
        String ripListen = null;
        String compression = null;
        String ho_xonxoff = null;
        String ho_speed = null;
        String ho_databits = null;
        String ho_parity = null;
        String ho_rtscts = null;
        String prompt = null;
        String loginService = null;
        int lmiTimer = 0;
        String lmiType = null;
        String deviceService = null;
        String group = null;
        String mtu = null;
        String inputFilter = null;
        String outputFilter = null;
        String idleMinutes = null;
        String spid = null;
        String dirno = null;
        int pType = 16;
        String dialback = null;
        String modem = null;
        String idleSeconds = null;
        String access = null;
        String dtr = null;
        try {
            boolean ccp;
            msg.setPortName(portName);
            databits = tok.getNextString();
            stopbits = tok.getNextString();
            parity = tok.getNextString();
            modemControl = tok.getNextString();
            portType = tok.getNextString();
            msg.setState(tok.getNextString());
            msg.setInputBytes(tok.getNextLong());
            msg.setOutputBytes(tok.getNextLong());
            msg.setPendingBytes(tok.getNextLong());
            speed1 = tok.getNextString();
            speed2 = tok.getNextString();
            speed3 = tok.getNextString();
            device = tok.getNextString();
            if (device.equals(PORT_NO_DEVICE)) {
                device = "";
            } else if (device.startsWith("//")) {
                device = device.substring(1, device.length());
            }
            message = tok.getNextQuotedString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            int options = tok.getNextInt();
            xonxoff = (options & 4) != 0 ? "off" : "on";
            rtscts = (options & 0x20) != 0 ? "on" : "off";
            tok.getNextString();
            tok.getNextString();
            host1 = tok.getNextString();
            host2 = tok.getNextString();
            host3 = tok.getNextString();
            host4 = tok.getNextString();
            termType = tok.getNextQuotedString();
            msg.setOverrunErrors(tok.getNextLong());
            msg.setParityErrors(tok.getNextLong());
            msg.setFramingErrors(tok.getNextLong());
            username = tok.getNextQuotedString();
            if (username.length() > 8) {
                username = username.substring(0, 8);
            }
            portOptions = tok.getNextInt();
            String tmp = portType;
            int index = portType.indexOf(47);
            if (index != -1) {
                tmp = portType.substring(0, index);
            }
            if (tmp.equalsIgnoreCase(PORT_TYPE_LOGIN) || tmp.equalsIgnoreCase(PORT_TYPE_TWOWAY)) {
                isLogin = true;
            }
            if (tmp.equalsIgnoreCase(PORT_TYPE_DEVICE) || tmp.equalsIgnoreCase(PORT_TYPE_TWOWAY)) {
                isDevice = true;
            }
            if (index != -1) {
                tmp = portType.substring(index + 1);
            }
            portType = null;
            if (tmp.equalsIgnoreCase(PORT_TYPE_NETWORK) || tmp.equalsIgnoreCase(PORT_TYPE_SLIP) || tmp.equalsIgnoreCase(PORT_TYPE_PPP)) {
                isNetwork = true;
                if ((portOptions & 0x10) != 0) {
                    isDialin = true;
                }
                if ((portOptions & 0x20) != 0) {
                    isDialout = true;
                }
                if (!isDialin && !isDialout) {
                    isHardwired = true;
                }
                protocol = (portOptions & 0x200) != 0 ? "ppp" : "frame";
            }
            portType = isLogin && isDevice ? "twoway" : (isDevice ? "device" : "login");
            networkType = isHardwired ? "hardwired" : (isDialin && isDialout ? "twoway" : (isDialin ? "dialin" : (isDialout ? "dialout" : "none")));
            destination = host1;
            netmask = host2;
            ipxnet = host3;
            localip = host4;
            LEOctets octs = new LEOctets(ipxnet);
            ipxnet = octs.toHexString();
            dtr = (portOptions & 0x80) != 0 ? "off" : "on";
            security = (portOptions & 0x1000) != 0 ? "on" : "off";
            hangup = (portOptions & 0x8000) != 0 ? "off" : "on";
            ripBroad = (portOptions & 8) != 0 ? "on" : "off";
            ripListen = (portOptions & 0x400) != 0 ? "off" : "on";
            access = (portOptions & 0x4000) != 0 ? "on" : "off";
            boolean compress = (portOptions & 0x100) != 0;
            boolean bl = ccp = (portOptions & 0x200000) != 0;
            compression = compress && ccp ? "on" : (compress ? "vj" : (ccp ? "stac" : "off"));
            options = tok.getNextInt();
            ho_xonxoff = (options & 1) != 0 ? "on" : "off";
            ho_speed = (options & 2) != 0 ? "on" : "off";
            ho_databits = (options & 4) != 0 ? "on" : "off";
            ho_parity = (options & 0x10) != 0 ? "on" : "off";
            ho_rtscts = (options & 0x20) != 0 ? "on" : "off";
            prompt = tok.getNextQuotedString();
            tok.getNextString();
            loginService = tok.getNextString().toLowerCase();
            index = loginService.indexOf(64);
            if (index == -1 && loginService.equals("telnet")) {
                loginService = String.valueOf(loginService) + "@23";
            }
            boolean isLMI = false;
            boolean isAnnexD = false;
            if (index != -1) {
                tmp = loginService.substring(index + 1);
                lmiTimer = Integer.parseInt(tmp);
                tmp = loginService.substring(0, index);
                if (lmiTimer > 0) {
                    if (tmp.equalsIgnoreCase(PORT_LMI_LMI)) {
                        isLMI = true;
                    } else if (tmp.equalsIgnoreCase(PORT_LMI_ANNEXD)) {
                        isAnnexD = true;
                    }
                }
            }
            lmiType = isLMI ? "lmi" : (isAnnexD ? "annex-d" : "none");
            tok.getNextString();
            deviceService = tok.getNextString().toLowerCase();
            index = deviceService.indexOf(64);
            if (index == -1 && deviceService.equals("telnet")) {
                deviceService = String.valueOf(deviceService) + "@23";
            }
            dest2 = tok.getNextString();
            netm2 = tok.getNextString();
            if (portName.equals("C0")) {
                destination = dest2;
                netmask = netm2;
            }
            msg.setDestination(tok.getNextString());
            ipx2 = tok.getNextString();
            octs = new LEOctets(ipx2);
            ipx2 = octs.toHexString();
            tok.getNextQuotedString();
            tok.getNextString();
            group = tok.getNextString();
            mtu = tok.getNextString();
            if (mtu.equals(PORT_MTU_BUG)) {
                mtu = PORT_MTU_DEF;
            }
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            inputFilter = tok.getNextQuotedString();
            outputFilter = tok.getNextQuotedString();
            tok.getNextQuotedString();
            tok.getNextQuotedString();
            tok.getNextQuotedString();
            idleMinutes = tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            spid = tok.getNextQuotedString();
            dirno = tok.getNextQuotedString();
            pType = tok.getNextInt();
            if (pType == 0) {
                pType = 16;
            } else if (pType == 1) {
                pType = 32;
            } else if (pType == 2) {
                pType = 64;
            } else if (pType == 3) {
                pType = 128;
            } else if (pType == 17) {
                pType = 129;
            }
            if (pType == 16 && protocol.equals("frame")) {
                protocol = "slip";
            }
            dialback = tok.getNextString();
            tok.getNextString();
            modem = tok.getNextQuotedString();
            msg.setModemStatus(tok.getNextString());
            msg.setSessionTermination(tok.getNextHex());
            msg.setDisconnectCode(tok.getNextHex());
            idleSeconds = tok.getNextString();
            tok.getNextString();
        }
        catch (EOFException e) {
            if (portName.equals(PORT_PO)) {
                pType = 32;
            } else {
                LEDebug.getLog().logln(20, e);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        if (portName == null) {
            return;
        }
        String units = null;
        if (idleSeconds != null && (portOptions & 0x80000) != 0) {
            units = String.valueOf(idleSeconds) + " " + "seconds";
        } else if (idleMinutes != null) {
            units = String.valueOf(idleMinutes) + " " + "minutes";
        }
        switch (pType & 0xF0) {
            case 16: {
                LEAsyncPorts aports = (LEAsyncPorts)ports.getConfig("AsyncPort");
                LEAsyncPort aport = (LEAsyncPort)aports.getConfig(portName);
                if (networkType != null) {
                    aport.setField("NetworkType", networkType);
                }
                if (portType != null) {
                    aport.setField("PortType", portType);
                }
                if (access != null) {
                    aport.setField("access", access);
                }
                if (compression != null) {
                    aport.setField("compression", compression);
                }
                if (databits != null) {
                    aport.setField("databits", databits);
                }
                if (destination != null) {
                    aport.setField("destination", destination);
                }
                if (device != null) {
                    aport.setField("device", device);
                }
                if (deviceService != null) {
                    aport.setField("service_device", deviceService);
                }
                if (dialback != null) {
                    aport.setField("dialback_delay", dialback);
                }
                if (dtr != null) {
                    aport.setField("dtr_idle", dtr);
                }
                if (group != null) {
                    aport.setField("group", group);
                }
                if (hangup != null) {
                    aport.setField("hangup", hangup);
                }
                if (host1 != null) {
                    aport.setField("host_1", host1);
                }
                if (host2 != null) {
                    aport.setField("host_2", host2);
                }
                if (host3 != null) {
                    aport.setField("host_3", host3);
                }
                if (host4 != null) {
                    aport.setField("host_4", host4);
                }
                if (localip != null) {
                    aport.setField("address", localip);
                }
                if (units != null) {
                    aport.setField("idle", units);
                }
                if (inputFilter != null) {
                    aport.setField("ifilter", inputFilter);
                }
                if (loginService != null) {
                    aport.setField("service_login", loginService);
                }
                if (message != null) {
                    aport.setField("message", message);
                }
                if (modem != null) {
                    aport.setField("modem", modem);
                }
                if (modemControl != null) {
                    aport.setField("cd", modemControl);
                }
                if (mtu != null) {
                    aport.setField("mtu", mtu);
                }
                if (netmask != null) {
                    aport.setField("netmask", netmask);
                }
                if (outputFilter != null) {
                    aport.setField("ofilter", outputFilter);
                }
                LEHostOverrides overrides = (LEHostOverrides)aport.getConfig("override");
                if (ho_databits != null) {
                    overrides.setField("databits", ho_databits);
                }
                if (ho_parity != null) {
                    overrides.setField("parity", ho_parity);
                }
                if (ho_speed != null) {
                    overrides.setField("speed", ho_speed);
                }
                if (ho_rtscts != null) {
                    overrides.setField("rts", ho_rtscts);
                }
                if (ho_xonxoff != null) {
                    overrides.setField("xon", ho_xonxoff);
                }
                if (parity != null) {
                    aport.setField("parity", parity);
                }
                if (prompt != null) {
                    aport.setField("prompt", prompt);
                }
                if (protocol != null) {
                    aport.setField("protocol", protocol);
                }
                if (ripBroad != null) {
                    aport.setField("RIPBroadcast", ripBroad);
                }
                if (ripListen != null) {
                    aport.setField("RIPListen", ripListen);
                }
                if (rtscts != null) {
                    aport.setField("rts/cts", rtscts);
                }
                if (security != null) {
                    aport.setField("security", security);
                }
                if (speed1 != null) {
                    aport.setField("speed", speed1);
                }
                if (speed2 != null) {
                    aport.setField("speed2", speed2);
                }
                if (speed3 != null) {
                    aport.setField("speed3", speed3);
                }
                if (stopbits != null) {
                    aport.setField("stopbits", stopbits);
                }
                if (termType != null) {
                    aport.setField("termtype", termType);
                }
                if (username != null) {
                    aport.setField("username", username);
                }
                if (xonxoff == null) break;
                aport.setField("xon/xoff", xonxoff);
                break;
            }
            case 64: {
                LESyncPorts sports = (LESyncPorts)ports.getConfig("SyncPort");
                LESyncPort sport = (LESyncPort)sports.getConfig(portName);
                if (networkType != null) {
                    sport.setField("NetworkType", networkType);
                }
                if (dest2 != null) {
                    sport.setField("destination", dest2);
                }
                if (compression != null) {
                    sport.setField("compression", compression);
                }
                if (group != null) {
                    sport.setField("group", group);
                }
                if (hangup != null) {
                    sport.setField("hangup", hangup);
                }
                if (ipxnet != null) {
                    sport.setField("ipxnet", ipx2);
                }
                if (units != null) {
                    sport.setField("idle", units);
                }
                if (inputFilter != null) {
                    sport.setField("ifilter", inputFilter);
                }
                if (lmiType != null) {
                    sport.setField("LMIType", lmiType);
                    sport.setField("LMITimer", Integer.toString(lmiTimer));
                }
                if (localip != null) {
                    sport.setField("address", localip);
                }
                if (modemControl != null) {
                    sport.setField("cd", modemControl);
                }
                if (mtu != null) {
                    sport.setField("mtu", mtu);
                }
                if (netm2 != null) {
                    sport.setField("netmask", netm2);
                }
                if (outputFilter != null) {
                    sport.setField("ofilter", outputFilter);
                }
                if (protocol != null) {
                    sport.setField("protocol", protocol);
                }
                if (ripBroad != null) {
                    sport.setField("RIPBroadcast", ripBroad);
                }
                if (ripListen != null) {
                    sport.setField("RIPListen", ripListen);
                }
                if (speed1 != null) {
                    sport.setField("speed", speed1);
                }
                LEDLCIList dlciList = (LEDLCIList)sport.getConfig("dlci");
                if (message == null) break;
                dlciList.clearList();
                if (message.startsWith(PORT_DLCI_PRE)) {
                    message = message.substring(PORT_DLCI_PRE.length());
                }
                StringTokenizer stok = new StringTokenizer(message);
                while (stok.hasMoreTokens()) {
                    dlciList.addField(stok.nextToken());
                }
                break;
            }
            case 128: {
                LEISDNPorts iports = (LEISDNPorts)ports.getConfig("ISDNPort");
                LEISDNPort iport = (LEISDNPort)iports.getConfig(portName);
                if (networkType != null) {
                    iport.setField("NetworkType", networkType);
                }
                if (portType != null) {
                    iport.setField("PortType", portType);
                }
                if (compression != null) {
                    iport.setField("compression", compression);
                }
                if (destination != null) {
                    iport.setField("destination", destination);
                }
                if (device != null) {
                    iport.setField("device", device);
                }
                if (deviceService != null) {
                    iport.setField("service_device", deviceService);
                }
                if (dialback != null) {
                    iport.setField("dialback_delay", dialback);
                }
                if (dirno != null) {
                    iport.setField("directory", dirno);
                }
                if (group != null) {
                    iport.setField("group", group);
                }
                if (hangup != null) {
                    iport.setField("hangup", hangup);
                }
                if (host1 != null) {
                    iport.setField("host_1", host1);
                }
                if (host2 != null) {
                    iport.setField("host_2", host2);
                }
                if (host3 != null) {
                    iport.setField("host_3", host3);
                }
                if (host4 != null) {
                    iport.setField("host_4", host4);
                }
                if (units != null) {
                    iport.setField("idle", units);
                }
                if (inputFilter != null) {
                    iport.setField("ifilter", inputFilter);
                }
                if (ipxnet != null) {
                    iport.setField("ipxnet", ipxnet);
                }
                if (localip != null) {
                    iport.setField("address", localip);
                }
                if (loginService != null) {
                    iport.setField("service_login", loginService);
                }
                if (message != null) {
                    iport.setField("message", message);
                }
                if (mtu != null) {
                    iport.setField("mtu", mtu);
                }
                if (netmask != null) {
                    iport.setField("netmask", netmask);
                }
                if (outputFilter != null) {
                    iport.setField("ofilter", outputFilter);
                }
                if (parity != null) {
                    iport.setField("prompt", prompt);
                }
                if (ripBroad != null) {
                    iport.setField("RIPBroadcast", ripBroad);
                }
                if (ripListen != null) {
                    iport.setField("RIPListen", ripListen);
                }
                if (security != null) {
                    iport.setField("security", security);
                }
                if (speed1 != null) {
                    iport.setField("speed", speed1);
                }
                if (speed2 != null) {
                    iport.setField("speed2", speed2);
                }
                if (speed3 != null) {
                    iport.setField("speed3", speed3);
                }
                if (spid != null) {
                    iport.setField("spid", spid);
                }
                if (termType != null) {
                    iport.setField("termtype", termType);
                }
                if (username == null) break;
                iport.setField("username", username);
                break;
            }
        }
        LEAMManager.Process(hostname, "PORT_IO", msg);
    }

    public static void ParseParallelPort(String hostname, LEPorts ports, String portName, LETokenizer tok) {
        LEParallelPorts pports = (LEParallelPorts)ports.getConfig("ParallelPort");
        LEParallelPort port = (LEParallelPort)pports.getConfig(portName);
        try {
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            LEPortIOMessage msg = new LEPortIOMessage();
            msg.setState(tok.getNextString());
            msg.setInputBytes(tok.getNextLong());
            msg.setOutputBytes(tok.getNextLong());
            msg.setPendingBytes(tok.getNextLong());
            LEAMManager.Process(hostname, "PORT_IO", msg);
            tok.getNextLong();
            tok.getNextLong();
            tok.getNextLong();
            String device = tok.getNextString();
            if (device.length() > 1) {
                if (device.startsWith("//")) {
                    port.setField("device", device.substring(1));
                } else {
                    port.setField("device", device);
                }
            } else {
                port.setField("device", "");
            }
            tok.getNextQuotedString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextLong();
            tok.getNextString();
            tok.getNextLong();
            tok.getNextLong();
            tok.getNextString();
            tok.getNextString();
            port.setField("host", tok.getNextString());
            tok.getNextLong();
            tok.getNextLong();
            tok.getNextLong();
            tok.getNextQuotedString();
            tok.getNextLong();
            tok.getNextLong();
            tok.getNextLong();
            tok.getNextQuotedString();
            tok.getNextLong();
            tok.getNextLong();
            tok.getNextQuotedString();
            tok.getNextString();
            tok.getNextString();
            tok.getNextString();
            String service = tok.getNextString().toLowerCase();
            int index = service.indexOf(64);
            if (index == -1 && service.equals("telnet")) {
                service = String.valueOf(service) + "@23";
            }
            port.setField("service_device", service);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

